/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.BufferUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.BatchMode;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.RemoteEndpoint;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.WriteCallback;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.BlockingWriteCallback;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.LogicalConnection;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.WebSocketFrame;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.frames.BinaryFrame;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.frames.PingFrame;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.frames.PongFrame;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.io.FrameFlusher;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.io.FutureWriteCallback;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.WritePendingException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public class WebSocketRemoteEndpoint
implements RemoteEndpoint {
    private static final WriteCallback NOOP_CALLBACK = new WriteCallback(){

        @Override
        public void writeSuccess() {
        }

        @Override
        public void writeFailed(Throwable throwable) {
        }
    };
    private static final Logger LOG = Log.getLogger(WebSocketRemoteEndpoint.class);
    private final LogicalConnection connection;
    private final OutgoingFrames outgoing;
    private final AtomicInteger msgState = new AtomicInteger();
    private final BlockingWriteCallback blocker = new BlockingWriteCallback();
    private final AtomicInteger numOutgoingFrames = new AtomicInteger();
    private volatile BatchMode batchMode;
    private int maxNumOutgoingFrames = -1;

    public WebSocketRemoteEndpoint(LogicalConnection logicalConnection, OutgoingFrames outgoingFrames, BatchMode batchMode) {
        if (logicalConnection == null) {
            throw new IllegalArgumentException("LogicalConnection cannot be null");
        }
        this.connection = logicalConnection;
        this.outgoing = outgoingFrames;
        this.batchMode = batchMode;
    }

    private boolean lockMsg(MsgType msgType) {
        while (true) {
            int n2 = this.msgState.get();
            switch (msgType) {
                case BLOCKING: {
                    if ((n2 & 0xC0000) != 0) {
                        throw new IllegalStateException(String.format("Partial message pending %x for %s", new Object[]{n2, msgType}));
                    }
                    if ((n2 & 0x10000) != 0) {
                        throw new IllegalStateException(String.format("Blocking message pending %x for %s", new Object[]{n2, msgType}));
                    }
                    if (!this.msgState.compareAndSet(n2, n2 | 0x10000)) break;
                    return n2 == 0;
                }
                case ASYNC: {
                    if ((n2 & 0xC0000) != 0) {
                        throw new IllegalStateException(String.format("Partial message pending %x for %s", new Object[]{n2, msgType}));
                    }
                    if ((n2 & 0xFFFF) == 65535) {
                        throw new IllegalStateException(String.format("Too many async sends: %x", n2));
                    }
                    if (!this.msgState.compareAndSet(n2, n2 + 1)) break;
                    return n2 == 0;
                }
                case STREAMING: {
                    if ((n2 & 0xC0000) != 0) {
                        throw new IllegalStateException(String.format("Partial message pending %x for %s", new Object[]{n2, msgType}));
                    }
                    if ((n2 & 0x20000) != 0) {
                        throw new IllegalStateException(String.format("Already streaming %x for %s", new Object[]{n2, msgType}));
                    }
                    if (!this.msgState.compareAndSet(n2, n2 | 0x20000)) break;
                    return n2 == 0;
                }
                case PARTIAL_BINARY: {
                    if (n2 == 524288) {
                        return false;
                    }
                    if (n2 == 0 && this.msgState.compareAndSet(0, n2 | 0x80000)) {
                        return true;
                    }
                    throw new IllegalStateException(String.format("Cannot send %s in state %x", new Object[]{msgType, n2}));
                }
                case PARTIAL_TEXT: {
                    if (n2 == 262144) {
                        return false;
                    }
                    if (n2 == 0 && this.msgState.compareAndSet(0, n2 | 0x40000)) {
                        return true;
                    }
                    throw new IllegalStateException(String.format("Cannot send %s in state %x", new Object[]{msgType, n2}));
                }
            }
        }
    }

    private void unlockMsg(MsgType msgType) {
        while (true) {
            int n2 = this.msgState.get();
            switch (msgType) {
                case BLOCKING: {
                    if ((n2 & 0x10000) == 0) {
                        throw new IllegalStateException(String.format("Not Blocking in state %x", n2));
                    }
                    if (!this.msgState.compareAndSet(n2, n2 & 0xFFFEFFFF)) break;
                    return;
                }
                case ASYNC: {
                    if ((n2 & 0xFFFF) == 0) {
                        throw new IllegalStateException(String.format("Not Async in %x", n2));
                    }
                    if (!this.msgState.compareAndSet(n2, n2 - 1)) break;
                    return;
                }
                case STREAMING: {
                    if ((n2 & 0x20000) == 0) {
                        throw new IllegalStateException(String.format("Not Streaming in state %x", n2));
                    }
                    if (!this.msgState.compareAndSet(n2, n2 & 0xFFFDFFFF)) break;
                    return;
                }
                case PARTIAL_BINARY: {
                    if (this.msgState.compareAndSet(524288, 0)) {
                        return;
                    }
                    throw new IllegalStateException(String.format("Not Partial Binary in state %x", n2));
                }
                case PARTIAL_TEXT: {
                    if (this.msgState.compareAndSet(262144, 0)) {
                        return;
                    }
                    throw new IllegalStateException(String.format("Not Partial Text in state %x", n2));
                }
            }
        }
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        if (this.connection == null) {
            return null;
        }
        return this.connection.getRemoteAddress();
    }

    private Future<Void> sendAsyncFrame(WebSocketFrame webSocketFrame) {
        FutureWriteCallback futureWriteCallback = new FutureWriteCallback();
        this.uncheckedSendFrame(webSocketFrame, futureWriteCallback);
        return futureWriteCallback;
    }

    @Override
    public Future<Void> sendBytesByFuture(ByteBuffer byteBuffer) {
        this.lockMsg(MsgType.ASYNC);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("sendBytesByFuture with {}", BufferUtil.toDetailString(byteBuffer));
            }
            Future<Void> future = this.sendAsyncFrame(new BinaryFrame().setPayload(byteBuffer));
            return future;
        }
        finally {
            this.unlockMsg(MsgType.ASYNC);
        }
    }

    public void uncheckedSendFrame(WebSocketFrame webSocketFrame, WriteCallback writeCallback) {
        BatchMode batchMode = BatchMode.OFF;
        if (webSocketFrame.isDataFrame()) {
            batchMode = this.getBatchMode();
        }
        if (this.maxNumOutgoingFrames > 0 && webSocketFrame.isDataFrame()) {
            int n2 = this.numOutgoingFrames.incrementAndGet();
            writeCallback = WebSocketRemoteEndpoint.from(writeCallback, this.numOutgoingFrames::decrementAndGet);
            if (n2 > this.maxNumOutgoingFrames) {
                writeCallback.writeFailed(new WritePendingException());
                return;
            }
        }
        this.outgoing.outgoingFrame(webSocketFrame, writeCallback, batchMode);
    }

    @Override
    public void sendPing(ByteBuffer byteBuffer) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendPing with {}", BufferUtil.toDetailString(byteBuffer));
        }
        this.sendAsyncFrame(new PingFrame().setPayload(byteBuffer));
    }

    @Override
    public void sendPong(ByteBuffer byteBuffer) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendPong with {}", BufferUtil.toDetailString(byteBuffer));
        }
        this.sendAsyncFrame(new PongFrame().setPayload(byteBuffer));
    }

    public BatchMode getBatchMode() {
        return this.batchMode;
    }

    @Override
    public void setBatchMode(BatchMode batchMode) {
        this.batchMode = batchMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        this.lockMsg(MsgType.ASYNC);
        try (BlockingWriteCallback.WriteBlocker writeBlocker = this.blocker.acquireWriteBlocker();){
            this.uncheckedSendFrame(FrameFlusher.FLUSH_FRAME, writeBlocker);
            writeBlocker.block();
        }
        finally {
            this.unlockMsg(MsgType.ASYNC);
        }
    }

    public String toString() {
        return String.format("%s@%x[batching=%b]", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this.getBatchMode()});
    }

    private static WriteCallback from(final WriteCallback writeCallback, final Runnable runnable) {
        return new WriteCallback(){

            @Override
            public void writeFailed(Throwable throwable) {
                try {
                    writeCallback.writeFailed(throwable);
                }
                finally {
                    runnable.run();
                }
            }

            @Override
            public void writeSuccess() {
                try {
                    writeCallback.writeSuccess();
                }
                finally {
                    runnable.run();
                }
            }
        };
    }

    private static enum MsgType {
        BLOCKING,
        ASYNC,
        STREAMING,
        PARTIAL_TEXT,
        PARTIAL_BINARY;

    }
}

