/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.http.impl.cookie;

import com.gradle.scan.plugin.internal.dep.org.apache.http.cookie.ClientCookie;
import com.gradle.scan.plugin.internal.dep.org.apache.http.cookie.CommonCookieAttributeHandler;
import com.gradle.scan.plugin.internal.dep.org.apache.http.cookie.Cookie;
import com.gradle.scan.plugin.internal.dep.org.apache.http.cookie.CookieOrigin;
import com.gradle.scan.plugin.internal.dep.org.apache.http.cookie.CookieRestrictionViolationException;
import com.gradle.scan.plugin.internal.dep.org.apache.http.cookie.MalformedCookieException;
import com.gradle.scan.plugin.internal.dep.org.apache.http.cookie.SetCookie;
import com.gradle.scan.plugin.internal.dep.org.apache.http.cookie.SetCookie2;
import com.gradle.scan.plugin.internal.dep.org.apache.http.util.Args;

public class RFC2965VersionAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        Args.notNull(setCookie, "Cookie");
        if (string == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        int n2 = -1;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = -1;
        }
        if (n2 < 0) {
            throw new MalformedCookieException("Invalid cookie version.");
        }
        setCookie.setVersion(n2);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie instanceof SetCookie2 && cookie instanceof ClientCookie && !((ClientCookie)cookie).containsAttribute("version")) {
            throw new CookieRestrictionViolationException("Violates RFC 2965. Version attribute is required.");
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        return true;
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

