/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.commons.lang3.tuple;

import com.gradle.scan.plugin.internal.dep.org.apache.commons.lang3.builder.CompareToBuilder;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.lang3.tuple.ImmutablePair;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public abstract class Pair<L, R>
implements Serializable,
Comparable<Pair<L, R>>,
Map.Entry<L, R> {
    public static final Pair<?, ?>[] EMPTY_ARRAY = new PairAdapter[0];

    public static <L, R> Pair<L, R> of(L l2, R r2) {
        return ImmutablePair.of(l2, r2);
    }

    public static <L, R> Pair<L, R> of(Map.Entry<L, R> entry) {
        return ImmutablePair.of(entry);
    }

    @Override
    public int compareTo(Pair<L, R> pair) {
        return new CompareToBuilder().append(this.getLeft(), pair.getLeft()).append(this.getRight(), pair.getRight()).toComparison();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)object;
            return Objects.equals(this.getKey(), entry.getKey()) && Objects.equals(this.getValue(), entry.getValue());
        }
        return false;
    }

    @Override
    public final L getKey() {
        return this.getLeft();
    }

    public abstract L getLeft();

    public abstract R getRight();

    @Override
    public R getValue() {
        return this.getRight();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.getKey()) ^ Objects.hashCode(this.getValue());
    }

    public String toString() {
        return "(" + this.getLeft() + ',' + this.getRight() + ')';
    }

    private static final class PairAdapter<L, R>
    extends Pair<L, R> {
        private PairAdapter() {
        }

        @Override
        public L getLeft() {
            return null;
        }

        @Override
        public R getRight() {
            return null;
        }

        @Override
        public R setValue(R r2) {
            return null;
        }
    }
}

