/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jsr310.ser;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.type.WritableTypeId;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jsr310.ser.JSR310FormattedSerializerBase;
import java.io.IOException;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;

public class YearMonthSerializer
extends JSR310FormattedSerializerBase<YearMonth> {
    public static final YearMonthSerializer INSTANCE = new YearMonthSerializer();

    protected YearMonthSerializer() {
        this((DateTimeFormatter)null);
    }

    public YearMonthSerializer(DateTimeFormatter dateTimeFormatter) {
        super(YearMonth.class, dateTimeFormatter);
    }

    private YearMonthSerializer(YearMonthSerializer yearMonthSerializer, Boolean bl2, DateTimeFormatter dateTimeFormatter) {
        super(yearMonthSerializer, bl2, dateTimeFormatter, null);
    }

    protected YearMonthSerializer withFormat(Boolean bl2, DateTimeFormatter dateTimeFormatter, JsonFormat.Shape shape) {
        return new YearMonthSerializer(this, bl2, dateTimeFormatter);
    }

    @Override
    public void serialize(YearMonth yearMonth, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.useTimestamp(serializerProvider)) {
            jsonGenerator.writeStartArray();
            this._serializeAsArrayContents(yearMonth, jsonGenerator, serializerProvider);
            jsonGenerator.writeEndArray();
            return;
        }
        jsonGenerator.writeString(this._formatter == null ? yearMonth.toString() : yearMonth.format(this._formatter));
    }

    @Override
    public void serializeWithType(YearMonth yearMonth, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(yearMonth, this.serializationShape(serializerProvider)));
        if (writableTypeId.valueShape == JsonToken.START_ARRAY) {
            this._serializeAsArrayContents(yearMonth, jsonGenerator, serializerProvider);
        } else {
            jsonGenerator.writeString(this._formatter == null ? yearMonth.toString() : yearMonth.format(this._formatter));
        }
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    protected void _serializeAsArrayContents(YearMonth yearMonth, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeNumber(yearMonth.getYear());
        jsonGenerator.writeNumber(yearMonth.getMonthValue());
    }

    @Override
    protected void _acceptTimestampVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        boolean bl2;
        SerializerProvider serializerProvider = jsonFormatVisitorWrapper.getProvider();
        boolean bl3 = bl2 = serializerProvider != null && this.useTimestamp(serializerProvider);
        if (bl2) {
            super._acceptTimestampVisitor(jsonFormatVisitorWrapper, javaType);
        } else {
            JsonStringFormatVisitor jsonStringFormatVisitor = jsonFormatVisitorWrapper.expectStringFormat(javaType);
            if (jsonStringFormatVisitor != null) {
                jsonStringFormatVisitor.format(JsonValueFormat.DATE_TIME);
            }
        }
    }

    @Override
    protected JsonToken serializationShape(SerializerProvider serializerProvider) {
        return this.useTimestamp(serializerProvider) ? JsonToken.START_ARRAY : JsonToken.VALUE_STRING;
    }
}

