/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Base64Variant;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.FormatFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerationException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonStreamContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.ObjectCodec;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.PrettyPrinter;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.SerializableString;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.base.GeneratorBase;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.IOContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.NumberInput;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json.DupDetector;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileBufferRecycler;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileUtil;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileWriteContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public class SmileGenerator
extends GeneratorBase {
    protected final IOContext _ioContext;
    protected final OutputStream _out;
    protected int _formatFeatures;
    protected final SmileBufferRecycler<SharedStringNode> _smileBufferRecycler;
    protected SmileWriteContext _streamWriteContext;
    protected byte[] _outputBuffer;
    protected int _outputTail = 0;
    protected final int _outputEnd;
    protected int _bytesWritten;
    protected SharedStringNode[] _seenNames;
    protected int _seenNameCount;
    protected SharedStringNode[] _seenStringValues;
    protected int _seenStringValueCount;
    protected boolean _bufferRecyclable;
    protected static final ThreadLocal<SoftReference<SmileBufferRecycler<SharedStringNode>>> _smileRecyclerRef = new ThreadLocal();

    public SmileGenerator(IOContext iOContext, int n2, int n3, ObjectCodec objectCodec, OutputStream outputStream) {
        super(n2, objectCodec, null);
        DupDetector dupDetector = JsonGenerator.Feature.STRICT_DUPLICATE_DETECTION.enabledIn(n2) ? DupDetector.rootDetector(this) : null;
        this._streamWriteContext = SmileWriteContext.createRootContext(dupDetector);
        this._formatFeatures = n3;
        this._ioContext = iOContext;
        this._smileBufferRecycler = SmileGenerator._smileBufferRecycler();
        this._out = outputStream;
        this._bufferRecyclable = true;
        this._outputBuffer = iOContext.allocWriteEncodingBuffer();
        this._outputEnd = this._outputBuffer.length;
        if (this._outputEnd < 770) {
            throw new IllegalStateException(String.format("Internal encoding buffer length (%d) too short, must be at least %d", this._outputEnd, 770));
        }
        if (!Feature.CHECK_SHARED_NAMES.enabledIn(n3)) {
            this._seenNames = null;
            this._seenNameCount = -1;
        } else {
            this._seenNames = this._smileBufferRecycler.allocSeenNamesBuffer();
            if (this._seenNames == null) {
                this._seenNames = new SharedStringNode[64];
            }
            this._seenNameCount = 0;
        }
        if (!Feature.CHECK_SHARED_STRING_VALUES.enabledIn(n3)) {
            this._seenStringValues = null;
            this._seenStringValueCount = -1;
        } else {
            this._seenStringValues = this._smileBufferRecycler.allocSeenStringValuesBuffer();
            if (this._seenStringValues == null) {
                this._seenStringValues = new SharedStringNode[64];
            }
            this._seenStringValueCount = 0;
        }
    }

    public void writeHeader() throws IOException {
        int n2 = 0;
        if (Feature.CHECK_SHARED_NAMES.enabledIn(this._formatFeatures)) {
            n2 |= 1;
        }
        if (Feature.CHECK_SHARED_STRING_VALUES.enabledIn(this._formatFeatures)) {
            n2 |= 2;
        }
        if (!Feature.ENCODE_BINARY_AS_7BIT.enabledIn(this._formatFeatures)) {
            n2 |= 4;
        }
        this._writeBytes((byte)58, (byte)41, (byte)10, (byte)n2);
    }

    protected static final SmileBufferRecycler<SharedStringNode> _smileBufferRecycler() {
        SmileBufferRecycler<SharedStringNode> smileBufferRecycler;
        SoftReference<SmileBufferRecycler<SharedStringNode>> softReference = _smileRecyclerRef.get();
        SmileBufferRecycler<SharedStringNode> smileBufferRecycler2 = smileBufferRecycler = softReference == null ? null : softReference.get();
        if (smileBufferRecycler == null) {
            smileBufferRecycler = new SmileBufferRecycler();
            _smileRecyclerRef.set(new SoftReference<SmileBufferRecycler<SharedStringNode>>(smileBufferRecycler));
        }
        return smileBufferRecycler;
    }

    @Override
    public boolean canWriteBinaryNatively() {
        return true;
    }

    @Override
    public JsonGenerator setPrettyPrinter(PrettyPrinter prettyPrinter) {
        return this;
    }

    @Override
    public JsonGenerator overrideFormatFeatures(int n2, int n3) {
        this._formatFeatures = this._formatFeatures & ~n3 | n2 & n3;
        return this;
    }

    @Override
    public void setCurrentValue(Object object) {
        this._streamWriteContext.setCurrentValue(object);
    }

    @Override
    public JsonStreamContext getOutputContext() {
        return this._streamWriteContext;
    }

    @Override
    public final void writeFieldName(String string) throws IOException {
        if (!this._streamWriteContext.writeFieldName(string)) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(string);
    }

    @Override
    public final void writeFieldName(SerializableString serializableString) throws IOException {
        if (!this._streamWriteContext.writeFieldName(serializableString.getValue())) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(serializableString);
    }

    public final boolean isEnabled(Feature feature) {
        return (this._formatFeatures & feature.getMask()) != 0;
    }

    @Override
    public final void writeStartArray() throws IOException {
        this._verifyValueWrite("start an array");
        this._streamWriteContext = this._streamWriteContext.createChildArrayContext(null);
        this._writeByte((byte)-8);
    }

    @Override
    public final void writeStartArray(Object object) throws IOException {
        this._verifyValueWrite("start an array");
        this._streamWriteContext = this._streamWriteContext.createChildArrayContext(object);
        this._writeByte((byte)-8);
    }

    @Override
    public final void writeStartArray(Object object, int n2) throws IOException {
        this._verifyValueWrite("start an array");
        this._streamWriteContext = this._streamWriteContext.createChildArrayContext(object);
        this._writeByte((byte)-8);
    }

    @Override
    @Deprecated
    public final void writeStartArray(int n2) throws IOException {
        this._verifyValueWrite("start an array");
        this._streamWriteContext = this._streamWriteContext.createChildArrayContext(null);
        this._writeByte((byte)-8);
    }

    @Override
    public final void writeEndArray() throws IOException {
        if (!this._streamWriteContext.inArray()) {
            this._reportError("Current context not Array but " + this._streamWriteContext.typeDesc());
        }
        this._writeByte((byte)-7);
        this._streamWriteContext = this._streamWriteContext.getParent();
    }

    @Override
    public final void writeStartObject() throws IOException {
        this._verifyValueWrite("start an object");
        this._streamWriteContext = this._streamWriteContext.createChildObjectContext(null);
        this._writeByte((byte)-6);
    }

    @Override
    public final void writeStartObject(Object object) throws IOException {
        SmileWriteContext smileWriteContext;
        this._verifyValueWrite("start an object");
        this._streamWriteContext = smileWriteContext = this._streamWriteContext.createChildObjectContext(object);
        this._writeByte((byte)-6);
    }

    @Override
    public void writeStartObject(Object object, int n2) throws IOException {
        SmileWriteContext smileWriteContext;
        this._verifyValueWrite("start an object");
        this._streamWriteContext = smileWriteContext = this._streamWriteContext.createChildObjectContext(object);
        this._writeByte((byte)-6);
    }

    @Override
    public final void writeEndObject() throws IOException {
        if (!this._streamWriteContext.inObject()) {
            this._reportError("Current context not Object but " + this._streamWriteContext.typeDesc());
        }
        this._streamWriteContext = this._streamWriteContext.getParent();
        this._writeByte((byte)-5);
    }

    @Override
    public void writeArray(int[] nArray, int n2, int n3) throws IOException {
        this._verifyOffsets(nArray.length, n2, n3);
        this._verifyValueWrite("write int array");
        this._writeByte((byte)-8);
        int n4 = this._outputTail;
        int n5 = this._outputEnd;
        int n6 = n2 + n3;
        for (int i2 = n2; i2 < n6; ++i2) {
            if (n4 + 6 >= n5) {
                this._outputTail = n4;
                this._flushBuffer();
                n4 = this._outputTail;
            }
            n4 = this._writeNumberNoChecks(n4, nArray[i2]);
        }
        this._outputTail = n4;
        this._writeByte((byte)-7);
    }

    @Override
    public void writeArray(long[] lArray, int n2, int n3) throws IOException {
        this._verifyOffsets(lArray.length, n2, n3);
        this._verifyValueWrite("write int array");
        this._writeByte((byte)-8);
        int n4 = this._outputTail;
        int n5 = this._outputEnd;
        int n6 = n2 + n3;
        for (int i2 = n2; i2 < n6; ++i2) {
            if (n4 + 11 >= n5) {
                this._outputTail = n4;
                this._flushBuffer();
                n4 = this._outputTail;
            }
            n4 = this._writeNumberNoChecks(n4, lArray[i2]);
        }
        this._outputTail = n4;
        this._writeByte((byte)-7);
    }

    @Override
    public void writeArray(double[] dArray, int n2, int n3) throws IOException {
        this._verifyOffsets(dArray.length, n2, n3);
        this._verifyValueWrite("write int array");
        this._writeByte((byte)-8);
        int n4 = this._outputTail;
        int n5 = this._outputEnd;
        int n6 = n2 + n3;
        for (int i2 = n2; i2 < n6; ++i2) {
            if (n4 + 10 >= n5) {
                this._outputTail = n4;
                this._flushBuffer();
                n4 = this._outputTail;
            }
            n4 = this._writeNumberNoChecks(n4, dArray[i2]);
        }
        this._outputTail = n4;
        this._writeByte((byte)-7);
    }

    private final void _writeFieldName(String string) throws IOException {
        int n2;
        int n3;
        int n4 = string.length();
        if (n4 == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (this._seenNameCount >= 0 && (n3 = this._findSeenName(string)) >= 0) {
            this._writeSharedNameReference(n3);
            return;
        }
        if (n4 > 64) {
            this._writeNonShortFieldName(string, n4);
            return;
        }
        if (this._outputTail + 196 >= this._outputEnd) {
            this._flushBuffer();
        }
        n3 = this._outputTail++;
        int n5 = this._shortUTF8Encode(string, 0, n4);
        if (n5 == n4) {
            if (n5 <= 64) {
                n2 = (byte)(127 + n5);
            } else {
                n2 = 52;
                this._outputBuffer[this._outputTail++] = -4;
            }
        } else if (n5 <= 56) {
            n2 = (byte)(190 + n5);
        } else {
            n2 = 52;
            this._outputBuffer[this._outputTail++] = -4;
        }
        this._outputBuffer[n3] = n2;
        if (this._seenNameCount >= 0) {
            this._addSeenName(string);
        }
    }

    private final void _writeNonShortFieldName(String string, int n2) throws IOException {
        this._writeByte((byte)52);
        int n3 = n2 + n2 + n2;
        if (n3 <= this._outputBuffer.length) {
            if (this._outputTail + n3 >= this._outputEnd) {
                this._flushBuffer();
            }
            this._shortUTF8Encode(string, 0, n2);
        } else {
            this._mediumUTF8Encode(string, 0, n2);
        }
        if (this._seenNameCount >= 0) {
            this._addSeenName(string);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = -4;
    }

    protected final void _writeFieldName(SerializableString serializableString) throws IOException {
        int n2;
        int n3 = serializableString.charLength();
        if (n3 == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (this._seenNameCount >= 0 && (n2 = this._findSeenName(serializableString.getValue())) >= 0) {
            this._writeSharedNameReference(n2);
            return;
        }
        byte[] byArray = serializableString.asUnquotedUTF8();
        int n4 = byArray.length;
        if (n4 != n3) {
            this._writeFieldNameUnicode(serializableString, byArray);
            return;
        }
        if (n4 <= 64) {
            if (this._outputTail + n4 >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = (byte)(127 + n4);
            System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n4);
            this._outputTail += n4;
        } else {
            this._writeLongAsciiFieldName(byArray);
        }
        if (this._seenNameCount >= 0) {
            this._addSeenName(serializableString.getValue());
        }
    }

    private final void _writeLongAsciiFieldName(byte[] byArray) throws IOException {
        int n2 = byArray.length;
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 52;
        if (this._outputTail + n2 + 1 < this._outputEnd) {
            System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n2);
            this._outputTail += n2;
        } else {
            this._flushBuffer();
            if (n2 < 770) {
                System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n2);
                this._outputTail += n2;
            } else {
                if (this._outputTail > 0) {
                    this._flushBuffer();
                }
                this._out.write(byArray, 0, n2);
            }
        }
        this._outputBuffer[this._outputTail++] = -4;
    }

    protected final void _writeFieldNameUnicode(SerializableString serializableString, byte[] byArray) throws IOException {
        int n2 = byArray.length;
        if (n2 <= 56) {
            if (this._outputTail + n2 >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = (byte)(190 + n2);
            System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n2);
            this._outputTail += n2;
            if (this._seenNameCount >= 0) {
                this._addSeenName(serializableString.getValue());
            }
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 52;
        if (this._outputTail + n2 + 1 < this._outputEnd) {
            System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n2);
            this._outputTail += n2;
        } else {
            this._flushBuffer();
            if (n2 < 770) {
                System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n2);
                this._outputTail += n2;
            } else {
                if (this._outputTail > 0) {
                    this._flushBuffer();
                }
                this._out.write(byArray, 0, n2);
            }
        }
        this._outputBuffer[this._outputTail++] = -4;
        if (this._seenNameCount >= 0) {
            this._addSeenName(serializableString.getValue());
        }
    }

    private final void _writeSharedNameReference(int n2) throws IOException {
        if (n2 >= this._seenNameCount) {
            throw new IllegalArgumentException("Internal error: trying to write shared name with index " + n2 + "; but have only seen " + this._seenNameCount + " so far!");
        }
        if (n2 < 64) {
            this._writeByte((byte)(64 + n2));
        } else {
            this._writeBytes((byte)(48 + (n2 >> 8)), (byte)n2);
        }
    }

    @Override
    public void writeString(String string) throws IOException {
        int n2;
        if (string == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write String value");
        int n3 = string.length();
        if (n3 == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (n3 > 65) {
            this._writeNonSharedString(string, n3);
            return;
        }
        if (this._seenStringValueCount >= 0 && (n2 = this._findSeenStringValue(string)) >= 0) {
            this._writeSharedStringValueReference(n2);
            return;
        }
        if (this._outputTail + 196 >= this._outputEnd) {
            this._flushBuffer();
        }
        n2 = this._outputTail++;
        int n4 = this._shortUTF8Encode(string, 0, n3);
        if (n4 <= 64) {
            if (this._seenStringValueCount >= 0) {
                this._addSeenStringValue(string);
            }
            this._outputBuffer[n2] = n4 == n3 ? (byte)(63 + n4) : (byte)(126 + n4);
        } else {
            this._outputBuffer[n2] = n4 == n3 ? -32 : -28;
            this._outputBuffer[this._outputTail++] = -4;
        }
    }

    private final void _writeSharedStringValueReference(int n2) throws IOException {
        if (n2 >= this._seenStringValueCount) {
            throw new IllegalArgumentException("Internal error: trying to write shared String value with index " + n2 + "; but have only seen " + this._seenStringValueCount + " so far!");
        }
        if (n2 < 31) {
            this._writeByte((byte)(1 + n2));
        } else {
            this._writeBytes((byte)(236 + (n2 >> 8)), (byte)n2);
        }
    }

    private final void _writeNonSharedString(String string, int n2) throws IOException {
        int n3 = n2 + n2 + n2 + 2;
        if (n3 > this._outputBuffer.length) {
            this._writeByte((byte)-28);
            this._mediumUTF8Encode(string, 0, n2);
            this._writeByte((byte)-4);
            return;
        }
        if (this._outputTail + n3 >= this._outputEnd) {
            this._flushBuffer();
        }
        int n4 = this._outputTail;
        this._writeByte((byte)-32);
        int n5 = this._shortUTF8Encode(string, 0, n2);
        if (n5 > n2) {
            this._outputBuffer[n4] = -28;
        }
        this._outputBuffer[this._outputTail++] = -4;
    }

    @Override
    public void writeString(char[] cArray, int n2, int n3) throws IOException {
        if (n3 <= 65 && this._seenStringValueCount >= 0 && n3 > 0) {
            this.writeString(new String(cArray, n2, n3));
            return;
        }
        this._verifyValueWrite("write String value");
        if (n3 == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (n3 <= 64) {
            int n4;
            if (this._outputTail + 196 >= this._outputEnd) {
                this._flushBuffer();
            }
            int n5 = this._outputTail++;
            int n6 = this._shortUTF8Encode(cArray, n2, n2 + n3);
            if (n6 <= 64) {
                n4 = n6 == n3 ? (int)((byte)(63 + n6)) : (int)((byte)(126 + n6));
            } else {
                n4 = -28;
                this._outputBuffer[this._outputTail++] = -4;
            }
            this._outputBuffer[n5] = n4;
        } else {
            int n7 = n3 + n3 + n3 + 2;
            if (n7 <= this._outputBuffer.length) {
                if (this._outputTail + n7 >= this._outputEnd) {
                    this._flushBuffer();
                }
                int n8 = this._outputTail;
                this._writeByte((byte)-28);
                int n9 = this._shortUTF8Encode(cArray, n2, n2 + n3);
                if (n9 == n3) {
                    this._outputBuffer[n8] = -32;
                }
                this._outputBuffer[this._outputTail++] = -4;
            } else {
                this._writeByte((byte)-28);
                this._mediumUTF8Encode(cArray, n2, n2 + n3);
                this._writeByte((byte)-4);
            }
        }
    }

    @Override
    public final void writeString(SerializableString serializableString) throws IOException {
        int n2;
        this._verifyValueWrite("write String value");
        String string = serializableString.getValue();
        int n3 = string.length();
        if (n3 == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (n3 <= 65 && this._seenStringValueCount >= 0 && (n2 = this._findSeenStringValue(string)) >= 0) {
            this._writeSharedStringValueReference(n2);
            return;
        }
        byte[] byArray = serializableString.asUnquotedUTF8();
        int n4 = byArray.length;
        if (n4 <= 64) {
            if (this._outputTail + n4 + 1 >= this._outputEnd) {
                this._flushBuffer();
            }
            int n5 = n4 == n3 ? 63 + n4 : 126 + n4;
            this._outputBuffer[this._outputTail++] = (byte)n5;
            System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n4);
            this._outputTail += n4;
            if (this._seenStringValueCount >= 0) {
                this._addSeenStringValue(serializableString.getValue());
            }
        } else {
            byte by2 = n4 == n3 ? (byte)-32 : -28;
            this._writeByte(by2);
            this._writeBytes(byArray, 0, byArray.length);
            this._writeByte((byte)-4);
        }
    }

    @Override
    public void writeRaw(String string) throws IOException {
        throw this._notSupported();
    }

    @Override
    public void writeRaw(char[] cArray, int n2, int n3) throws IOException {
        throw this._notSupported();
    }

    @Override
    public void writeRaw(char c2) throws IOException {
        throw this._notSupported();
    }

    @Override
    public void writeRawValue(String string) throws IOException {
        throw this._notSupported();
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write Binary value");
        if (this.isEnabled(Feature.ENCODE_BINARY_AS_7BIT)) {
            this._writeByte((byte)-24);
            this._write7BitBinaryWithLength(byArray, n2, n3);
        } else {
            this._writeByte((byte)-3);
            this._writePositiveVInt(n3);
            this._writeBytes(byArray, n2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int writeBinary(InputStream inputStream, int n2) throws IOException {
        int n3;
        if (n2 < 0) {
            throw new UnsupportedOperationException("Must pass actual length for Smile encoded data");
        }
        this._verifyValueWrite("write Binary value");
        if (this.isEnabled(Feature.ENCODE_BINARY_AS_7BIT)) {
            this._writeByte((byte)-24);
            byte[] byArray = this._ioContext.allocBase64Buffer();
            try {
                n3 = this._write7BitBinaryWithLength(inputStream, n2, byArray);
            }
            finally {
                this._ioContext.releaseBase64Buffer(byArray);
            }
        } else {
            this._writeByte((byte)-3);
            this._writePositiveVInt(n2);
            n3 = this._writeBytes(inputStream, n2);
        }
        if (n3 > 0) {
            this._reportError("Too few bytes available: missing " + n3 + " bytes (out of " + n2 + ")");
        }
        return n2;
    }

    @Override
    public int writeBinary(Base64Variant base64Variant, InputStream inputStream, int n2) throws IOException {
        return this.writeBinary(inputStream, n2);
    }

    @Override
    public void writeBoolean(boolean bl2) throws IOException {
        this._verifyValueWrite("write boolean value");
        if (bl2) {
            this._writeByte((byte)35);
        } else {
            this._writeByte((byte)34);
        }
    }

    @Override
    public void writeNull() throws IOException {
        this._verifyValueWrite("write null value");
        this._writeByte((byte)33);
    }

    @Override
    public void writeNumber(int n2) throws IOException {
        this._verifyValueWrite("write number");
        n2 = SmileUtil.zigzagEncode(n2);
        if (n2 <= 63 && n2 >= 0) {
            if (n2 <= 31) {
                this._writeByte((byte)(192 + n2));
                return;
            }
            this._writeBytes((byte)36, (byte)(128 + n2));
            return;
        }
        byte by2 = (byte)(128 + (n2 & 0x3F));
        if ((n2 >>>= 6) <= 127) {
            this._writeBytes((byte)36, (byte)n2, by2);
            return;
        }
        byte by3 = (byte)(n2 & 0x7F);
        if ((n2 >>= 7) <= 127) {
            this._writeBytes((byte)36, (byte)n2, by3, by2);
            return;
        }
        byte by4 = (byte)(n2 & 0x7F);
        if ((n2 >>= 7) <= 127) {
            this._writeBytes((byte)36, (byte)n2, by4, by3, by2);
            return;
        }
        byte by5 = (byte)(n2 & 0x7F);
        this._writeBytes((byte)36, (byte)(n2 >> 7), by5, by4, by3, by2);
    }

    private final int _writeNumberNoChecks(int n2, int n3) throws IOException {
        byte[] byArray = this._outputBuffer;
        if ((n3 = SmileUtil.zigzagEncode(n3)) <= 63 && n3 >= 0) {
            if (n3 <= 31) {
                byArray[n2++] = (byte)(192 + n3);
                return n2;
            }
            byArray[n2++] = 36;
            byArray[n2++] = (byte)(128 + n3);
            return n2;
        }
        byArray[n2++] = 36;
        byte by2 = (byte)(128 + (n3 & 0x3F));
        if ((n3 >>>= 6) <= 127) {
            byArray[n2++] = (byte)n3;
            byArray[n2++] = by2;
            return n2;
        }
        byte by3 = (byte)(n3 & 0x7F);
        if ((n3 >>= 7) <= 127) {
            byArray[n2++] = (byte)n3;
            byArray[n2++] = by3;
            byArray[n2++] = by2;
            return n2;
        }
        byte by4 = (byte)(n3 & 0x7F);
        if ((n3 >>= 7) <= 127) {
            byArray[n2++] = (byte)n3;
            byArray[n2++] = by4;
            byArray[n2++] = by3;
            byArray[n2++] = by2;
            return n2;
        }
        byte by5 = (byte)(n3 & 0x7F);
        byArray[n2++] = (byte)(n3 >> 7);
        byArray[n2++] = by5;
        byArray[n2++] = by4;
        byArray[n2++] = by3;
        byArray[n2++] = by2;
        return n2;
    }

    @Override
    public void writeNumber(long l2) throws IOException {
        if (l2 <= Integer.MAX_VALUE && l2 >= Integer.MIN_VALUE) {
            this.writeNumber((int)l2);
            return;
        }
        this._verifyValueWrite("write number");
        l2 = SmileUtil.zigzagEncode(l2);
        int n2 = (int)l2;
        byte by2 = (byte)(128 + (n2 & 0x3F));
        byte by3 = (byte)(n2 >> 6 & 0x7F);
        byte by4 = (byte)(n2 >> 13 & 0x7F);
        byte by5 = (byte)(n2 >> 20 & 0x7F);
        byte by6 = (byte)((int)(l2 >>>= 27) & 0x7F);
        n2 = (int)(l2 >> 7);
        if (n2 == 0) {
            this._writeBytes((byte)37, by6, by5, by4, by3, by2);
            return;
        }
        if (n2 <= 127) {
            this._writeBytes((byte)37, (byte)n2);
            this._writeBytes(by6, by5, by4, by3, by2);
            return;
        }
        byte by7 = (byte)(n2 & 0x7F);
        if ((n2 >>= 7) <= 127) {
            this._writeBytes((byte)37, (byte)n2);
            this._writeBytes(by7, by6, by5, by4, by3, by2);
            return;
        }
        byte by8 = (byte)(n2 & 0x7F);
        if ((n2 >>= 7) <= 127) {
            this._writeBytes((byte)37, (byte)n2, by8);
            this._writeBytes(by7, by6, by5, by4, by3, by2);
            return;
        }
        byte by9 = (byte)(n2 & 0x7F);
        if ((n2 >>= 7) <= 127) {
            this._writeBytes((byte)37, (byte)n2, by9, by8);
            this._writeBytes(by7, by6, by5, by4, by3, by2);
            return;
        }
        byte by10 = (byte)(n2 & 0x7F);
        this._writeBytes((byte)37, (byte)(n2 >>= 7), by10, by9, by8);
        this._writeBytes(by7, by6, by5, by4, by3, by2);
    }

    private final int _writeNumberNoChecks(int n2, long l2) throws IOException {
        if (l2 <= Integer.MAX_VALUE && l2 >= Integer.MIN_VALUE) {
            return this._writeNumberNoChecks(n2, (int)l2);
        }
        l2 = SmileUtil.zigzagEncode(l2);
        int n3 = (int)l2;
        byte by2 = (byte)(128 + (n3 & 0x3F));
        byte by3 = (byte)(n3 >> 6 & 0x7F);
        byte by4 = (byte)(n3 >> 13 & 0x7F);
        byte by5 = (byte)(n3 >> 20 & 0x7F);
        byte by6 = (byte)((int)(l2 >>>= 27) & 0x7F);
        byte[] byArray = this._outputBuffer;
        byArray[n2++] = 37;
        n3 = (int)(l2 >> 7);
        if (n3 == 0) {
            byArray[n2++] = by6;
            byArray[n2++] = by5;
            byArray[n2++] = by4;
            byArray[n2++] = by3;
            byArray[n2++] = by2;
            return n2;
        }
        if (n3 <= 127) {
            byArray[n2++] = (byte)n3;
            byArray[n2++] = by6;
            byArray[n2++] = by5;
            byArray[n2++] = by4;
            byArray[n2++] = by3;
            byArray[n2++] = by2;
            return n2;
        }
        byte by7 = (byte)(n3 & 0x7F);
        if ((n3 >>= 7) <= 127) {
            byArray[n2++] = (byte)n3;
            byArray[n2++] = by7;
            byArray[n2++] = by6;
            byArray[n2++] = by5;
            byArray[n2++] = by4;
            byArray[n2++] = by3;
            byArray[n2++] = by2;
            return n2;
        }
        byte by8 = (byte)(n3 & 0x7F);
        if ((n3 >>= 7) <= 127) {
            byArray[n2++] = (byte)n3;
            byArray[n2++] = by8;
            byArray[n2++] = by7;
            byArray[n2++] = by6;
            byArray[n2++] = by5;
            byArray[n2++] = by4;
            byArray[n2++] = by3;
            byArray[n2++] = by2;
            return n2;
        }
        byte by9 = (byte)(n3 & 0x7F);
        if ((n3 >>= 7) <= 127) {
            byArray[n2++] = (byte)n3;
            byArray[n2++] = by9;
            byArray[n2++] = by8;
            byArray[n2++] = by7;
            byArray[n2++] = by6;
            byArray[n2++] = by5;
            byArray[n2++] = by4;
            byArray[n2++] = by3;
            byArray[n2++] = by2;
            return n2;
        }
        byte by10 = (byte)(n3 & 0x7F);
        byArray[n2++] = (byte)(n3 >>= 7);
        byArray[n2++] = by10;
        byArray[n2++] = by9;
        byArray[n2++] = by8;
        byArray[n2++] = by7;
        byArray[n2++] = by6;
        byArray[n2++] = by5;
        byArray[n2++] = by4;
        byArray[n2++] = by3;
        byArray[n2++] = by2;
        return n2;
    }

    @Override
    public void writeNumber(BigInteger bigInteger) throws IOException {
        if (bigInteger == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeByte((byte)38);
        byte[] byArray = bigInteger.toByteArray();
        this._write7BitBinaryWithLength(byArray, 0, byArray.length);
    }

    @Override
    public void writeNumber(double d2) throws IOException {
        this._ensureRoomForOutput(11);
        this._verifyValueWrite("write number");
        long l2 = Double.doubleToRawLongBits(d2);
        this._outputBuffer[this._outputTail++] = 41;
        int n2 = (int)(l2 >>> 35);
        this._outputBuffer[this._outputTail + 4] = (byte)(n2 & 0x7F);
        this._outputBuffer[this._outputTail + 3] = (byte)((n2 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 2] = (byte)((n2 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 1] = (byte)((n2 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail] = (byte)(n2 >>= 7);
        this._outputTail += 5;
        int n3 = (int)(l2 >> 28);
        this._outputBuffer[this._outputTail++] = (byte)(n3 & 0x7F);
        n3 = (int)l2;
        this._outputBuffer[this._outputTail + 3] = (byte)(n3 & 0x7F);
        this._outputBuffer[this._outputTail + 2] = (byte)((n3 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 1] = (byte)((n3 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail] = (byte)((n3 >>= 7) & 0x7F);
        this._outputTail += 4;
    }

    private final int _writeNumberNoChecks(int n2, double d2) throws IOException {
        long l2 = Double.doubleToRawLongBits(d2);
        byte[] byArray = this._outputBuffer;
        byArray[n2++] = 41;
        int n3 = (int)(l2 >>> 35);
        byArray[n2 + 4] = (byte)(n3 & 0x7F);
        byArray[n2 + 3] = (byte)((n3 >>= 7) & 0x7F);
        byArray[n2 + 2] = (byte)((n3 >>= 7) & 0x7F);
        byArray[n2 + 1] = (byte)((n3 >>= 7) & 0x7F);
        byArray[n2] = (byte)(n3 >>= 7);
        n2 += 5;
        int n4 = (int)(l2 >> 28);
        byArray[n2++] = (byte)(n4 & 0x7F);
        n4 = (int)l2;
        byArray[n2 + 3] = (byte)(n4 & 0x7F);
        byArray[n2 + 2] = (byte)((n4 >>= 7) & 0x7F);
        byArray[n2 + 1] = (byte)((n4 >>= 7) & 0x7F);
        byArray[n2] = (byte)((n4 >>= 7) & 0x7F);
        return n2 + 4;
    }

    @Override
    public void writeNumber(float f2) throws IOException {
        this._ensureRoomForOutput(6);
        this._verifyValueWrite("write number");
        int n2 = Float.floatToRawIntBits(f2);
        this._outputBuffer[this._outputTail++] = 40;
        this._outputBuffer[this._outputTail + 4] = (byte)(n2 & 0x7F);
        this._outputBuffer[this._outputTail + 3] = (byte)((n2 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 2] = (byte)((n2 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 1] = (byte)((n2 >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail] = (byte)((n2 >>= 7) & 0x7F);
        this._outputTail += 5;
    }

    @Override
    public void writeNumber(BigDecimal bigDecimal) throws IOException {
        if (bigDecimal == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeByte((byte)42);
        int n2 = bigDecimal.scale();
        this._writeSignedVInt(n2);
        BigInteger bigInteger = bigDecimal.unscaledValue();
        byte[] byArray = bigInteger.toByteArray();
        this._write7BitBinaryWithLength(byArray, 0, byArray.length);
    }

    @Override
    public void writeNumber(String string) throws IOException {
        char c2;
        int n2;
        if (string == null) {
            this.writeNull();
            return;
        }
        int n3 = string.length();
        boolean bl2 = string.startsWith("-");
        int n4 = n2 = bl2 ? 1 : 0;
        while ((c2 = string.charAt(n2)) <= '9' && c2 >= '0') {
            if (++n2 != n3) continue;
            this._writeIntegralNumber(string, bl2);
            return;
        }
        this._writeDecimalNumber(string);
    }

    protected void _writeIntegralNumber(String string, boolean bl2) throws IOException {
        int n2 = string.length();
        if (bl2) {
            --n2;
        }
        try {
            if (n2 <= 9) {
                this.writeNumber(Integer.parseInt(string));
            } else if (n2 <= 18) {
                this.writeNumber(Long.parseLong(string));
            } else {
                this.writeNumber(new BigInteger(string));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonGenerationException("Invalid String representation for Number ('" + string + "'); can not write using Smile format", this);
        }
    }

    protected void _writeDecimalNumber(String string) throws IOException {
        try {
            this.writeNumber(NumberInput.parseBigDecimal(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonGenerationException("Invalid String representation for Number ('" + string + "'); can not write using Smile format", this);
        }
    }

    @Override
    protected final void _verifyValueWrite(String string) throws IOException {
        if (!this._streamWriteContext.writeValue()) {
            this._reportError("Can not " + string + ", expecting field name");
        }
    }

    @Override
    public final void flush() throws IOException {
        this._flushBuffer();
        if (this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
            this._out.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this._outputBuffer != null && this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT)) {
            while (true) {
                JsonStreamContext jsonStreamContext;
                if ((jsonStreamContext = this.getOutputContext()).inArray()) {
                    this.writeEndArray();
                    continue;
                }
                if (!jsonStreamContext.inObject()) break;
                this.writeEndObject();
            }
        }
        boolean bl2 = this._closed;
        super.close();
        if (!bl2 && this.isEnabled(Feature.WRITE_END_MARKER)) {
            this._writeByte((byte)-1);
        }
        this._flushBuffer();
        if (this._ioContext.isResourceManaged() || this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
            this._out.close();
        } else if (this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
            this._out.flush();
        }
        this._releaseBuffers();
    }

    private final int _shortUTF8Encode(char[] cArray, int n2, int n3) throws IOException {
        int n4;
        int n5 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        do {
            if ((n4 = cArray[n2]) > 127) {
                return this._shortUTF8Encode2(cArray, n2, n3, n5);
            }
            byArray[n5++] = (byte)n4;
        } while (++n2 < n3);
        n4 = n5 - this._outputTail;
        this._outputTail = n5;
        return n4;
    }

    private final int _shortUTF8Encode2(char[] cArray, int n2, int n3, int n4) throws IOException {
        int n5;
        byte[] byArray = this._outputBuffer;
        while (n2 < n3) {
            if ((n5 = cArray[n2++]) <= 127) {
                byArray[n4++] = (byte)n5;
                continue;
            }
            if (n5 < 2048) {
                byArray[n4++] = (byte)(0xC0 | n5 >> 6);
                byArray[n4++] = (byte)(0x80 | n5 & 0x3F);
                continue;
            }
            if (n5 < 55296 || n5 > 57343) {
                byArray[n4++] = (byte)(0xE0 | n5 >> 12);
                byArray[n4++] = (byte)(0x80 | n5 >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | n5 & 0x3F);
                continue;
            }
            if (n5 <= 56319 && n2 < n3) {
                char c2 = cArray[n2];
                if (c2 <= '\udfff' && c2 >= '\udc00') {
                    ++n2;
                    n4 = this._decodeAndWriteSurrogate(n5, c2, byArray, n4);
                    continue;
                }
                n4 = this._invalidSurrogateEnd(n5, c2, byArray, n4);
                continue;
            }
            n4 = this._invalidSurrogateStart(n5, byArray, n4);
        }
        n5 = n4 - this._outputTail;
        this._outputTail = n4;
        return n5;
    }

    private final int _shortUTF8Encode(String string, int n2, int n3) throws IOException {
        int n4;
        int n5 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        do {
            if ((n4 = string.charAt(n2)) > 127) {
                return this._shortUTF8Encode2(string, n2, n3, n5);
            }
            byArray[n5++] = (byte)n4;
        } while (++n2 < n3);
        n4 = n5 - this._outputTail;
        this._outputTail = n5;
        return n4;
    }

    private final int _shortUTF8Encode2(String string, int n2, int n3, int n4) throws IOException {
        int n5;
        byte[] byArray = this._outputBuffer;
        while (n2 < n3) {
            if ((n5 = string.charAt(n2++)) <= 127) {
                byArray[n4++] = (byte)n5;
                continue;
            }
            if (n5 < 2048) {
                byArray[n4++] = (byte)(0xC0 | n5 >> 6);
                byArray[n4++] = (byte)(0x80 | n5 & 0x3F);
                continue;
            }
            if (n5 < 55296 || n5 > 57343) {
                byArray[n4++] = (byte)(0xE0 | n5 >> 12);
                byArray[n4++] = (byte)(0x80 | n5 >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | n5 & 0x3F);
                continue;
            }
            if (n5 <= 56319 && n2 < n3) {
                char c2 = string.charAt(n2);
                if (c2 <= '\udfff' && c2 >= '\udc00') {
                    ++n2;
                    n4 = this._decodeAndWriteSurrogate(n5, c2, byArray, n4);
                    continue;
                }
                n4 = this._invalidSurrogateEnd(n5, c2, byArray, n4);
                continue;
            }
            n4 = this._invalidSurrogateStart(n5, byArray, n4);
        }
        n5 = n4 - this._outputTail;
        this._outputTail = n4;
        return n5;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _mediumUTF8Encode(char[] cArray, int n2, int n3) throws IOException {
        int n4 = this._outputEnd - 4;
        block0: while (n2 < n3) {
            int n5;
            char c2;
            if (this._outputTail >= n4) {
                this._flushBuffer();
            }
            if ((c2 = cArray[n2++]) <= '\u007f') {
                this._outputBuffer[this._outputTail++] = (byte)c2;
                n5 = n3 - n2;
                int n6 = n4 - this._outputTail;
                if (n5 > n6) {
                    n5 = n6;
                }
                n5 += n2;
                while (true) {
                    if (n2 >= n5) continue block0;
                    if ((c2 = cArray[n2++]) > '\u007f') break;
                    this._outputBuffer[this._outputTail++] = (byte)c2;
                }
            }
            if (c2 < '\u0800') {
                this._outputBuffer[this._outputTail++] = (byte)(0xC0 | c2 >> 6);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            if (c2 < '\ud800' || c2 > '\udfff') {
                this._outputBuffer[this._outputTail++] = (byte)(0xE0 | c2 >> 12);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            if (c2 <= '\udbff' && n2 < n3) {
                n5 = cArray[n2];
                if (n5 <= 57343 && n5 >= 56320) {
                    ++n2;
                    this._outputTail = this._decodeAndWriteSurrogate(c2, n5, this._outputBuffer, this._outputTail);
                    continue;
                }
                this._outputTail = this._invalidSurrogateEnd(c2, n5, this._outputBuffer, this._outputTail);
                continue;
            }
            this._outputTail = this._invalidSurrogateStart(c2, this._outputBuffer, this._outputTail);
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _mediumUTF8Encode(String string, int n2, int n3) throws IOException {
        int n4 = this._outputEnd - 4;
        block0: while (n2 < n3) {
            int n5;
            char c2;
            if (this._outputTail >= n4) {
                this._flushBuffer();
            }
            if ((c2 = string.charAt(n2++)) <= '\u007f') {
                this._outputBuffer[this._outputTail++] = (byte)c2;
                n5 = n3 - n2;
                int n6 = n4 - this._outputTail;
                if (n5 > n6) {
                    n5 = n6;
                }
                n5 += n2;
                while (true) {
                    if (n2 >= n5) continue block0;
                    if ((c2 = string.charAt(n2++)) > '\u007f') break;
                    this._outputBuffer[this._outputTail++] = (byte)c2;
                }
            }
            if (c2 < '\u0800') {
                this._outputBuffer[this._outputTail++] = (byte)(0xC0 | c2 >> 6);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            if (c2 < '\ud800' || c2 > '\udfff') {
                this._outputBuffer[this._outputTail++] = (byte)(0xE0 | c2 >> 12);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            if (c2 <= '\udbff' && n2 < n3) {
                n5 = string.charAt(n2);
                if (n5 <= 57343 && n5 >= 56320) {
                    ++n2;
                    this._outputTail = this._decodeAndWriteSurrogate(c2, n5, this._outputBuffer, this._outputTail);
                    continue;
                }
                this._outputTail = this._invalidSurrogateEnd(c2, n5, this._outputBuffer, this._outputTail);
                continue;
            }
            this._outputTail = this._invalidSurrogateStart(c2, this._outputBuffer, this._outputTail);
        }
        return;
    }

    private int _invalidSurrogateStart(int n2, byte[] byArray, int n3) throws IOException {
        if (this.isEnabled(Feature.LENIENT_UTF_ENCODING)) {
            return this._appendReplacementChar(byArray, n3);
        }
        if (n2 <= 56319) {
            this._reportError(String.format("Unmatched surrogate pair, starts with valid high surrogate (0x%04X) but ends without low surrogate", n2));
        }
        this._reportError(String.format("Invalid surrogate pair, starts with invalid high surrogate (0x%04X), not in valid range [0xD800, 0xDBFF]", n2));
        return 0;
    }

    private int _invalidSurrogateEnd(int n2, int n3, byte[] byArray, int n4) throws IOException {
        if (this.isEnabled(Feature.LENIENT_UTF_ENCODING)) {
            return this._appendReplacementChar(byArray, n4);
        }
        this._reportError(String.format("Invalid surrogate pair, starts with valid high surrogate (0x%04X) but ends with invalid low surrogate (0x%04X), not in valid range [0xDC00, 0xDFFF]", n2, n3));
        return 0;
    }

    private int _appendReplacementChar(byte[] byArray, int n2) {
        byArray[n2++] = -17;
        byArray[n2++] = -65;
        byArray[n2++] = -67;
        return n2;
    }

    private int _decodeAndWriteSurrogate(int n2, int n3, byte[] byArray, int n4) {
        int n5 = 65536 + (n2 - 55296 << 10) + (n3 - 56320);
        byArray[n4++] = (byte)(0xF0 | n5 >> 18);
        byArray[n4++] = (byte)(0x80 | n5 >> 12 & 0x3F);
        byArray[n4++] = (byte)(0x80 | n5 >> 6 & 0x3F);
        byArray[n4++] = (byte)(0x80 | n5 & 0x3F);
        return n4;
    }

    private final void _ensureRoomForOutput(int n2) throws IOException {
        if (this._outputTail + n2 >= this._outputEnd) {
            this._flushBuffer();
        }
    }

    private final void _writeByte(byte by2) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = by2;
    }

    private final void _writeBytes(byte by2, byte by3) throws IOException {
        if (this._outputTail + 1 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = by2;
        this._outputBuffer[this._outputTail++] = by3;
    }

    private final void _writeBytes(byte by2, byte by3, byte by4) throws IOException {
        if (this._outputTail + 2 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = by2;
        this._outputBuffer[this._outputTail++] = by3;
        this._outputBuffer[this._outputTail++] = by4;
    }

    private final void _writeBytes(byte by2, byte by3, byte by4, byte by5) throws IOException {
        if (this._outputTail + 3 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = by2;
        this._outputBuffer[this._outputTail++] = by3;
        this._outputBuffer[this._outputTail++] = by4;
        this._outputBuffer[this._outputTail++] = by5;
    }

    private final void _writeBytes(byte by2, byte by3, byte by4, byte by5, byte by6) throws IOException {
        if (this._outputTail + 4 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = by2;
        this._outputBuffer[this._outputTail++] = by3;
        this._outputBuffer[this._outputTail++] = by4;
        this._outputBuffer[this._outputTail++] = by5;
        this._outputBuffer[this._outputTail++] = by6;
    }

    private final void _writeBytes(byte by2, byte by3, byte by4, byte by5, byte by6, byte by7) throws IOException {
        if (this._outputTail + 5 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = by2;
        this._outputBuffer[this._outputTail++] = by3;
        this._outputBuffer[this._outputTail++] = by4;
        this._outputBuffer[this._outputTail++] = by5;
        this._outputBuffer[this._outputTail++] = by6;
        this._outputBuffer[this._outputTail++] = by7;
    }

    private final void _writeBytes(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 == 0) {
            return;
        }
        if (this._outputTail + n3 >= this._outputEnd) {
            this._writeBytesLong(byArray, n2, n3);
            return;
        }
        System.arraycopy(byArray, n2, this._outputBuffer, this._outputTail, n3);
        this._outputTail += n3;
    }

    private final int _writeBytes(InputStream inputStream, int n2) throws IOException {
        while (n2 > 0) {
            int n3;
            int n4 = this._outputEnd - this._outputTail;
            if (n4 <= 0) {
                this._flushBuffer();
                n4 = this._outputEnd - this._outputTail;
            }
            if (n4 > n2) {
                n4 = n2;
            }
            if ((n3 = inputStream.read(this._outputBuffer, this._outputTail, n4)) < 0) break;
            this._outputTail += n3;
            n2 -= n3;
        }
        return n2;
    }

    private final void _writeBytesLong(byte[] byArray, int n2, int n3) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        while (true) {
            int n4 = Math.min(n3, this._outputEnd - this._outputTail);
            System.arraycopy(byArray, n2, this._outputBuffer, this._outputTail, n4);
            this._outputTail += n4;
            if ((n3 -= n4) == 0) break;
            n2 += n4;
            this._flushBuffer();
        }
    }

    private void _writePositiveVInt(int n2) throws IOException {
        this._ensureRoomForOutput(5);
        byte by2 = (byte)(128 + (n2 & 0x3F));
        if ((n2 >>= 6) <= 127) {
            if (n2 > 0) {
                this._outputBuffer[this._outputTail++] = (byte)n2;
            }
            this._outputBuffer[this._outputTail++] = by2;
            return;
        }
        byte by3 = (byte)(n2 & 0x7F);
        if ((n2 >>= 7) <= 127) {
            this._outputBuffer[this._outputTail++] = (byte)n2;
            this._outputBuffer[this._outputTail++] = by3;
            this._outputBuffer[this._outputTail++] = by2;
        } else {
            byte by4 = (byte)(n2 & 0x7F);
            if ((n2 >>= 7) <= 127) {
                this._outputBuffer[this._outputTail++] = (byte)n2;
                this._outputBuffer[this._outputTail++] = by4;
                this._outputBuffer[this._outputTail++] = by3;
                this._outputBuffer[this._outputTail++] = by2;
            } else {
                byte by5 = (byte)(n2 & 0x7F);
                this._outputBuffer[this._outputTail++] = (byte)(n2 >> 7);
                this._outputBuffer[this._outputTail++] = by5;
                this._outputBuffer[this._outputTail++] = by4;
                this._outputBuffer[this._outputTail++] = by3;
                this._outputBuffer[this._outputTail++] = by2;
            }
        }
    }

    private void _writeSignedVInt(int n2) throws IOException {
        this._writePositiveVInt(SmileUtil.zigzagEncode(n2));
    }

    protected void _write7BitBinaryWithLength(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        this._writePositiveVInt(n3);
        while (n3 >= 7) {
            if (this._outputTail + 8 >= this._outputEnd) {
                this._flushBuffer();
            }
            n4 = byArray[n2++];
            this._outputBuffer[this._outputTail++] = (byte)(n4 >> 1 & 0x7F);
            n4 = n4 << 8 | byArray[n2++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n4 >> 2 & 0x7F);
            n4 = n4 << 8 | byArray[n2++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n4 >> 3 & 0x7F);
            n4 = n4 << 8 | byArray[n2++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n4 >> 4 & 0x7F);
            n4 = n4 << 8 | byArray[n2++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n4 >> 5 & 0x7F);
            n4 = n4 << 8 | byArray[n2++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n4 >> 6 & 0x7F);
            n4 = n4 << 8 | byArray[n2++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n4 >> 7 & 0x7F);
            this._outputBuffer[this._outputTail++] = (byte)(n4 & 0x7F);
            n3 -= 7;
        }
        if (n3 > 0) {
            if (this._outputTail + 7 >= this._outputEnd) {
                this._flushBuffer();
            }
            n4 = byArray[n2++];
            this._outputBuffer[this._outputTail++] = (byte)(n4 >> 1 & 0x7F);
            if (n3 > 1) {
                n4 = (n4 & 1) << 8 | byArray[n2++] & 0xFF;
                this._outputBuffer[this._outputTail++] = (byte)(n4 >> 2 & 0x7F);
                if (n3 > 2) {
                    n4 = (n4 & 3) << 8 | byArray[n2++] & 0xFF;
                    this._outputBuffer[this._outputTail++] = (byte)(n4 >> 3 & 0x7F);
                    if (n3 > 3) {
                        n4 = (n4 & 7) << 8 | byArray[n2++] & 0xFF;
                        this._outputBuffer[this._outputTail++] = (byte)(n4 >> 4 & 0x7F);
                        if (n3 > 4) {
                            n4 = (n4 & 0xF) << 8 | byArray[n2++] & 0xFF;
                            this._outputBuffer[this._outputTail++] = (byte)(n4 >> 5 & 0x7F);
                            if (n3 > 5) {
                                n4 = (n4 & 0x1F) << 8 | byArray[n2++] & 0xFF;
                                this._outputBuffer[this._outputTail++] = (byte)(n4 >> 6 & 0x7F);
                                this._outputBuffer[this._outputTail++] = (byte)(n4 & 0x3F);
                            } else {
                                this._outputBuffer[this._outputTail++] = (byte)(n4 & 0x1F);
                            }
                        } else {
                            this._outputBuffer[this._outputTail++] = (byte)(n4 & 0xF);
                        }
                    } else {
                        this._outputBuffer[this._outputTail++] = (byte)(n4 & 7);
                    }
                } else {
                    this._outputBuffer[this._outputTail++] = (byte)(n4 & 3);
                }
            } else {
                this._outputBuffer[this._outputTail++] = (byte)(n4 & 1);
            }
        }
    }

    protected int _write7BitBinaryWithLength(InputStream inputStream, int n2, byte[] byArray) throws IOException {
        int n3;
        this._writePositiveVInt(n2);
        int n4 = 0;
        int n5 = 0;
        int n6 = -7;
        while (n2 >= 7) {
            if (n4 > n6) {
                n5 = this._readMore(inputStream, byArray, n4, n5, n2);
                n4 = 0;
                if (n5 < 7) {
                    n2 -= n5;
                    break;
                }
                n6 = n5 - 7;
            }
            if (this._outputTail + 8 >= this._outputEnd) {
                this._flushBuffer();
            }
            n3 = byArray[n4++];
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 1 & 0x7F);
            n3 = n3 << 8 | byArray[n4++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 2 & 0x7F);
            n3 = n3 << 8 | byArray[n4++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 3 & 0x7F);
            n3 = n3 << 8 | byArray[n4++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 4 & 0x7F);
            n3 = n3 << 8 | byArray[n4++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 5 & 0x7F);
            n3 = n3 << 8 | byArray[n4++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 6 & 0x7F);
            n3 = n3 << 8 | byArray[n4++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 7 & 0x7F);
            this._outputBuffer[this._outputTail++] = (byte)(n3 & 0x7F);
            n2 -= 7;
        }
        if (n2 > 0) {
            if (this._outputTail + 7 >= this._outputEnd) {
                this._flushBuffer();
            }
            n5 = this._readMore(inputStream, byArray, n4, n5, n2);
            n4 = 0;
            if (n5 > 0) {
                n2 -= n5;
                n3 = byArray[n4++];
                this._outputBuffer[this._outputTail++] = (byte)(n3 >> 1 & 0x7F);
                if (n5 > 1) {
                    n3 = (n3 & 1) << 8 | byArray[n4++] & 0xFF;
                    this._outputBuffer[this._outputTail++] = (byte)(n3 >> 2 & 0x7F);
                    if (n5 > 2) {
                        n3 = (n3 & 3) << 8 | byArray[n4++] & 0xFF;
                        this._outputBuffer[this._outputTail++] = (byte)(n3 >> 3 & 0x7F);
                        if (n5 > 3) {
                            n3 = (n3 & 7) << 8 | byArray[n4++] & 0xFF;
                            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 4 & 0x7F);
                            if (n5 > 4) {
                                n3 = (n3 & 0xF) << 8 | byArray[n4++] & 0xFF;
                                this._outputBuffer[this._outputTail++] = (byte)(n3 >> 5 & 0x7F);
                                if (n5 > 5) {
                                    n3 = (n3 & 0x1F) << 8 | byArray[n4++] & 0xFF;
                                    this._outputBuffer[this._outputTail++] = (byte)(n3 >> 6 & 0x7F);
                                    this._outputBuffer[this._outputTail++] = (byte)(n3 & 0x3F);
                                } else {
                                    this._outputBuffer[this._outputTail++] = (byte)(n3 & 0x1F);
                                }
                            } else {
                                this._outputBuffer[this._outputTail++] = (byte)(n3 & 0xF);
                            }
                        } else {
                            this._outputBuffer[this._outputTail++] = (byte)(n3 & 7);
                        }
                    } else {
                        this._outputBuffer[this._outputTail++] = (byte)(n3 & 3);
                    }
                } else {
                    this._outputBuffer[this._outputTail++] = (byte)(n3 & 1);
                }
            }
        }
        return n2;
    }

    private int _readMore(InputStream inputStream, byte[] byArray, int n2, int n3, int n4) throws IOException {
        int n5;
        int n6 = 0;
        while (n2 < n3) {
            byArray[n6++] = byArray[n2++];
        }
        n2 = 0;
        n3 = n6;
        n4 = Math.min(n4, byArray.length);
        while ((n5 = n4 - n3) != 0) {
            int n7 = inputStream.read(byArray, n3, n5);
            if (n7 < 0) {
                return n3;
            }
            if ((n3 += n7) < 7) continue;
        }
        return n3;
    }

    @Override
    protected void _releaseBuffers() {
        Object[] objectArray;
        byte[] byArray = this._outputBuffer;
        if (byArray != null && this._bufferRecyclable) {
            this._outputBuffer = null;
            this._ioContext.releaseWriteEncodingBuffer(byArray);
        }
        if ((objectArray = this._seenNames) != null && objectArray.length == 64) {
            this._seenNames = null;
            if (this._seenNameCount > 0) {
                Arrays.fill(objectArray, null);
            }
            this._smileBufferRecycler.releaseSeenNamesBuffer((SharedStringNode[])objectArray);
        }
        if ((objectArray = this._seenStringValues) != null && objectArray.length == 64) {
            this._seenStringValues = null;
            if (this._seenStringValueCount > 0) {
                Arrays.fill(objectArray, null);
            }
            this._smileBufferRecycler.releaseSeenStringValuesBuffer((SharedStringNode[])objectArray);
        }
    }

    protected final void _flushBuffer() throws IOException {
        if (this._outputTail > 0) {
            this._bytesWritten += this._outputTail;
            this._out.write(this._outputBuffer, 0, this._outputTail);
            this._outputTail = 0;
        }
    }

    private final int _findSeenName(String string) {
        int n2 = string.hashCode();
        SharedStringNode sharedStringNode = this._seenNames[n2 & this._seenNames.length - 1];
        if (sharedStringNode == null) {
            return -1;
        }
        SharedStringNode sharedStringNode2 = sharedStringNode;
        if (sharedStringNode2.value == string) {
            return sharedStringNode2.index;
        }
        while ((sharedStringNode2 = sharedStringNode2.next) != null) {
            if (sharedStringNode2.value != string) continue;
            return sharedStringNode2.index;
        }
        sharedStringNode2 = sharedStringNode;
        do {
            String string2;
            if ((string2 = sharedStringNode2.value).hashCode() != n2 || !string2.equals(string)) continue;
            return sharedStringNode2.index;
        } while ((sharedStringNode2 = sharedStringNode2.next) != null);
        return -1;
    }

    private final void _addSeenName(String string) {
        int n2;
        int n3;
        if (this._seenNameCount == this._seenNames.length) {
            if (this._seenNameCount == 1024) {
                Arrays.fill(this._seenNames, null);
                this._seenNameCount = 0;
            } else {
                SharedStringNode[] sharedStringNodeArray = this._seenNames;
                this._seenNames = new SharedStringNode[1024];
                n3 = 1023;
                for (SharedStringNode sharedStringNode : sharedStringNodeArray) {
                    while (sharedStringNode != null) {
                        int n4 = sharedStringNode.value.hashCode() & 0x3FF;
                        SharedStringNode sharedStringNode2 = sharedStringNode.next;
                        sharedStringNode.next = this._seenNames[n4];
                        this._seenNames[n4] = sharedStringNode;
                        sharedStringNode = sharedStringNode2;
                    }
                }
            }
        }
        if (SmileGenerator._validBackRef(n2 = this._seenNameCount)) {
            n3 = string.hashCode() & this._seenNames.length - 1;
            this._seenNames[n3] = new SharedStringNode(string, n2, this._seenNames[n3]);
        }
        this._seenNameCount = n2 + 1;
    }

    private final int _findSeenStringValue(String string) {
        int n2 = string.hashCode();
        SharedStringNode sharedStringNode = this._seenStringValues[n2 & this._seenStringValues.length - 1];
        if (sharedStringNode != null) {
            SharedStringNode sharedStringNode2 = sharedStringNode;
            do {
                if (sharedStringNode2.value != string) continue;
                return sharedStringNode2.index;
            } while ((sharedStringNode2 = sharedStringNode2.next) != null);
            sharedStringNode2 = sharedStringNode;
            do {
                String string2;
                if ((string2 = sharedStringNode2.value).hashCode() != n2 || !string2.equals(string)) continue;
                return sharedStringNode2.index;
            } while ((sharedStringNode2 = sharedStringNode2.next) != null);
        }
        return -1;
    }

    private final void _addSeenStringValue(String string) {
        int n2;
        int n3;
        if (this._seenStringValueCount == this._seenStringValues.length) {
            if (this._seenStringValueCount == 1024) {
                Arrays.fill(this._seenStringValues, null);
                this._seenStringValueCount = 0;
            } else {
                SharedStringNode[] sharedStringNodeArray = this._seenStringValues;
                this._seenStringValues = new SharedStringNode[1024];
                n3 = 1023;
                for (SharedStringNode sharedStringNode : sharedStringNodeArray) {
                    while (sharedStringNode != null) {
                        int n4 = sharedStringNode.value.hashCode() & 0x3FF;
                        SharedStringNode sharedStringNode2 = sharedStringNode.next;
                        sharedStringNode.next = this._seenStringValues[n4];
                        this._seenStringValues[n4] = sharedStringNode;
                        sharedStringNode = sharedStringNode2;
                    }
                }
            }
        }
        if (SmileGenerator._validBackRef(n2 = this._seenStringValueCount)) {
            n3 = string.hashCode() & this._seenStringValues.length - 1;
            this._seenStringValues[n3] = new SharedStringNode(string, n2, this._seenStringValues[n3]);
        }
        this._seenStringValueCount = n2 + 1;
    }

    private static final boolean _validBackRef(int n2) {
        return (n2 & 0xFF) < 254;
    }

    protected UnsupportedOperationException _notSupported() {
        return new UnsupportedOperationException();
    }

    protected static final class SharedStringNode {
        public final String value;
        public final int index;
        public SharedStringNode next;

        public SharedStringNode(String string, int n2, SharedStringNode sharedStringNode) {
            this.value = string;
            this.index = n2;
            this.next = sharedStringNode;
        }
    }

    public static enum Feature implements FormatFeature
    {
        WRITE_HEADER(true),
        WRITE_END_MARKER(false),
        ENCODE_BINARY_AS_7BIT(true),
        CHECK_SHARED_NAMES(true),
        CHECK_SHARED_STRING_VALUES(false),
        LENIENT_UTF_ENCODING(false);

        protected final boolean _defaultState;
        protected final int _mask;

        public static int collectDefaults() {
            int n2 = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n2 |= feature.getMask();
            }
            return n2;
        }

        private Feature(boolean bl2) {
            this._defaultState = bl2;
            this._mask = 1 << this.ordinal();
        }

        @Override
        public boolean enabledByDefault() {
            return this._defaultState;
        }

        @Override
        public int getMask() {
            return this._mask;
        }

        @Override
        public boolean enabledIn(int n2) {
            return (n2 & this._mask) != 0;
        }
    }
}

