/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser.std;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.type.WritableTypeId;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.SerializationFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.node.ObjectNode;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser.std.ArraySerializerBase;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser.std.ByteArraySerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;

public class StdArraySerializers {
    protected static final HashMap<String, JsonSerializer<?>> _arraySerializers = new HashMap();

    public static JsonSerializer<?> findStandardImpl(Class<?> clazz) {
        return _arraySerializers.get(clazz.getName());
    }

    static {
        _arraySerializers.put(boolean[].class.getName(), new BooleanArraySerializer());
        _arraySerializers.put(byte[].class.getName(), new ByteArraySerializer());
        _arraySerializers.put(char[].class.getName(), new CharArraySerializer());
        _arraySerializers.put(short[].class.getName(), new ShortArraySerializer());
        _arraySerializers.put(int[].class.getName(), new IntArraySerializer());
        _arraySerializers.put(long[].class.getName(), new LongArraySerializer());
        _arraySerializers.put(float[].class.getName(), new FloatArraySerializer());
        _arraySerializers.put(double[].class.getName(), new DoubleArraySerializer());
    }

    @JacksonStdImpl
    public static class DoubleArraySerializer
    extends ArraySerializerBase<double[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Double.TYPE);

        public DoubleArraySerializer() {
            super(double[].class);
        }

        protected DoubleArraySerializer(DoubleArraySerializer doubleArraySerializer, BeanProperty beanProperty, Boolean bl2) {
            super(doubleArraySerializer, beanProperty, bl2);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty beanProperty, Boolean bl2) {
            return new DoubleArraySerializer(this, beanProperty, bl2);
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
            return this;
        }

        @Override
        public boolean isEmpty(SerializerProvider serializerProvider, double[] dArray) {
            return dArray.length == 0;
        }

        @Override
        public boolean hasSingleElement(double[] dArray) {
            return dArray.length == 1;
        }

        @Override
        public final void serialize(double[] dArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            int n2 = dArray.length;
            if (n2 == 1 && this._shouldUnwrapSingle(serializerProvider)) {
                this.serializeContents(dArray, jsonGenerator, serializerProvider);
                return;
            }
            jsonGenerator.writeArray(dArray, 0, dArray.length);
        }

        @Override
        public void serializeContents(double[] dArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            int n2 = dArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                jsonGenerator.writeNumber(dArray[i2]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("number"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
            this.visitArrayFormat(jsonFormatVisitorWrapper, javaType, JsonFormatTypes.NUMBER);
        }
    }

    @JacksonStdImpl
    public static class FloatArraySerializer
    extends TypedPrimitiveArraySerializer<float[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Float.TYPE);

        public FloatArraySerializer() {
            super(float[].class);
        }

        public FloatArraySerializer(FloatArraySerializer floatArraySerializer, BeanProperty beanProperty, Boolean bl2) {
            super(floatArraySerializer, beanProperty, bl2);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty beanProperty, Boolean bl2) {
            return new FloatArraySerializer(this, beanProperty, bl2);
        }

        @Override
        public boolean isEmpty(SerializerProvider serializerProvider, float[] fArray) {
            return fArray.length == 0;
        }

        @Override
        public boolean hasSingleElement(float[] fArray) {
            return fArray.length == 1;
        }

        @Override
        public final void serialize(float[] fArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            int n2 = fArray.length;
            if (n2 == 1 && this._shouldUnwrapSingle(serializerProvider)) {
                this.serializeContents(fArray, jsonGenerator, serializerProvider);
                return;
            }
            jsonGenerator.writeStartArray(fArray, n2);
            this.serializeContents(fArray, jsonGenerator, serializerProvider);
            jsonGenerator.writeEndArray();
        }

        @Override
        public void serializeContents(float[] fArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            int n2 = fArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                jsonGenerator.writeNumber(fArray[i2]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("number"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
            this.visitArrayFormat(jsonFormatVisitorWrapper, javaType, JsonFormatTypes.NUMBER);
        }
    }

    @JacksonStdImpl
    public static class LongArraySerializer
    extends TypedPrimitiveArraySerializer<long[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Long.TYPE);

        public LongArraySerializer() {
            super(long[].class);
        }

        public LongArraySerializer(LongArraySerializer longArraySerializer, BeanProperty beanProperty, Boolean bl2) {
            super(longArraySerializer, beanProperty, bl2);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty beanProperty, Boolean bl2) {
            return new LongArraySerializer(this, beanProperty, bl2);
        }

        @Override
        public boolean isEmpty(SerializerProvider serializerProvider, long[] lArray) {
            return lArray.length == 0;
        }

        @Override
        public boolean hasSingleElement(long[] lArray) {
            return lArray.length == 1;
        }

        @Override
        public final void serialize(long[] lArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            int n2 = lArray.length;
            if (n2 == 1 && this._shouldUnwrapSingle(serializerProvider)) {
                this.serializeContents(lArray, jsonGenerator, serializerProvider);
                return;
            }
            jsonGenerator.writeArray(lArray, 0, lArray.length);
        }

        @Override
        public void serializeContents(long[] lArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            int n2 = lArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                jsonGenerator.writeNumber(lArray[i2]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("number", true));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
            this.visitArrayFormat(jsonFormatVisitorWrapper, javaType, JsonFormatTypes.NUMBER);
        }
    }

    @JacksonStdImpl
    public static class IntArraySerializer
    extends ArraySerializerBase<int[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Integer.TYPE);

        public IntArraySerializer() {
            super(int[].class);
        }

        protected IntArraySerializer(IntArraySerializer intArraySerializer, BeanProperty beanProperty, Boolean bl2) {
            super(intArraySerializer, beanProperty, bl2);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty beanProperty, Boolean bl2) {
            return new IntArraySerializer(this, beanProperty, bl2);
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
            return this;
        }

        @Override
        public boolean isEmpty(SerializerProvider serializerProvider, int[] nArray) {
            return nArray.length == 0;
        }

        @Override
        public boolean hasSingleElement(int[] nArray) {
            return nArray.length == 1;
        }

        @Override
        public final void serialize(int[] nArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            int n2 = nArray.length;
            if (n2 == 1 && this._shouldUnwrapSingle(serializerProvider)) {
                this.serializeContents(nArray, jsonGenerator, serializerProvider);
                return;
            }
            jsonGenerator.writeArray(nArray, 0, nArray.length);
        }

        @Override
        public void serializeContents(int[] nArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            int n2 = nArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                jsonGenerator.writeNumber(nArray[i2]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            return this.createSchemaNode("array", true).set("items", this.createSchemaNode("integer"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
            this.visitArrayFormat(jsonFormatVisitorWrapper, javaType, JsonFormatTypes.INTEGER);
        }
    }

    @JacksonStdImpl
    public static class CharArraySerializer
    extends StdSerializer<char[]> {
        public CharArraySerializer() {
            super(char[].class);
        }

        @Override
        public boolean isEmpty(SerializerProvider serializerProvider, char[] cArray) {
            return cArray.length == 0;
        }

        @Override
        public void serialize(char[] cArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (serializerProvider.isEnabled(SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS)) {
                jsonGenerator.writeStartArray(cArray, cArray.length);
                this._writeArrayContents(jsonGenerator, cArray);
                jsonGenerator.writeEndArray();
            } else {
                jsonGenerator.writeString(cArray, 0, cArray.length);
            }
        }

        @Override
        public void serializeWithType(char[] cArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            WritableTypeId writableTypeId;
            boolean bl2 = serializerProvider.isEnabled(SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS);
            if (bl2) {
                writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(cArray, JsonToken.START_ARRAY));
                this._writeArrayContents(jsonGenerator, cArray);
            } else {
                writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(cArray, JsonToken.VALUE_STRING));
                jsonGenerator.writeString(cArray, 0, cArray.length);
            }
            typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
        }

        private final void _writeArrayContents(JsonGenerator jsonGenerator, char[] cArray) throws IOException {
            int n2 = cArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                jsonGenerator.writeString(cArray, i2, 1);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            ObjectNode objectNode = this.createSchemaNode("array", true);
            ObjectNode objectNode2 = this.createSchemaNode("string");
            objectNode2.put("type", "string");
            return objectNode.set("items", objectNode2);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
            this.visitArrayFormat(jsonFormatVisitorWrapper, javaType, JsonFormatTypes.STRING);
        }
    }

    @JacksonStdImpl
    public static class ShortArraySerializer
    extends TypedPrimitiveArraySerializer<short[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Short.TYPE);

        public ShortArraySerializer() {
            super(short[].class);
        }

        public ShortArraySerializer(ShortArraySerializer shortArraySerializer, BeanProperty beanProperty, Boolean bl2) {
            super(shortArraySerializer, beanProperty, bl2);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty beanProperty, Boolean bl2) {
            return new ShortArraySerializer(this, beanProperty, bl2);
        }

        @Override
        public boolean isEmpty(SerializerProvider serializerProvider, short[] sArray) {
            return sArray.length == 0;
        }

        @Override
        public boolean hasSingleElement(short[] sArray) {
            return sArray.length == 1;
        }

        @Override
        public final void serialize(short[] sArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            int n2 = sArray.length;
            if (n2 == 1 && this._shouldUnwrapSingle(serializerProvider)) {
                this.serializeContents(sArray, jsonGenerator, serializerProvider);
                return;
            }
            jsonGenerator.writeStartArray(sArray, n2);
            this.serializeContents(sArray, jsonGenerator, serializerProvider);
            jsonGenerator.writeEndArray();
        }

        @Override
        public void serializeContents(short[] sArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            int n2 = sArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                jsonGenerator.writeNumber((int)sArray[i2]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            ObjectNode objectNode = this.createSchemaNode("array", true);
            return objectNode.set("items", this.createSchemaNode("integer"));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
            this.visitArrayFormat(jsonFormatVisitorWrapper, javaType, JsonFormatTypes.INTEGER);
        }
    }

    @JacksonStdImpl
    public static class BooleanArraySerializer
    extends ArraySerializerBase<boolean[]> {
        private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Boolean.class);

        public BooleanArraySerializer() {
            super(boolean[].class);
        }

        protected BooleanArraySerializer(BooleanArraySerializer booleanArraySerializer, BeanProperty beanProperty, Boolean bl2) {
            super(booleanArraySerializer, beanProperty, bl2);
        }

        @Override
        public JsonSerializer<?> _withResolved(BeanProperty beanProperty, Boolean bl2) {
            return new BooleanArraySerializer(this, beanProperty, bl2);
        }

        @Override
        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
            return this;
        }

        @Override
        public boolean isEmpty(SerializerProvider serializerProvider, boolean[] blArray) {
            return blArray.length == 0;
        }

        @Override
        public boolean hasSingleElement(boolean[] blArray) {
            return blArray.length == 1;
        }

        @Override
        public final void serialize(boolean[] blArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            int n2 = blArray.length;
            if (n2 == 1 && this._shouldUnwrapSingle(serializerProvider)) {
                this.serializeContents(blArray, jsonGenerator, serializerProvider);
                return;
            }
            jsonGenerator.writeStartArray(blArray, n2);
            this.serializeContents(blArray, jsonGenerator, serializerProvider);
            jsonGenerator.writeEndArray();
        }

        @Override
        public void serializeContents(boolean[] blArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            int n2 = blArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                jsonGenerator.writeBoolean(blArray[i2]);
            }
        }

        @Override
        public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
            ObjectNode objectNode = this.createSchemaNode("array", true);
            objectNode.set("items", this.createSchemaNode("boolean"));
            return objectNode;
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
            this.visitArrayFormat(jsonFormatVisitorWrapper, javaType, JsonFormatTypes.BOOLEAN);
        }
    }

    protected static abstract class TypedPrimitiveArraySerializer<T>
    extends ArraySerializerBase<T> {
        protected TypedPrimitiveArraySerializer(Class<T> clazz) {
            super(clazz);
        }

        protected TypedPrimitiveArraySerializer(TypedPrimitiveArraySerializer<T> typedPrimitiveArraySerializer, BeanProperty beanProperty, Boolean bl2) {
            super(typedPrimitiveArraySerializer, beanProperty, bl2);
        }

        @Override
        public final ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
            return this;
        }
    }
}

