/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.framework;

import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.TestFilterBuilder;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.TestFrameworkTemplate;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.TestNames;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.framework.JunitTestFrameworkStrategy;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.framework.SpockParameterClassVisitor;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.framework.TestFrameworkStrategy;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.testsreader.TestsReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseJunitTestFrameworkStrategy
implements TestFrameworkStrategy {
    public static final Logger LOGGER = LoggerFactory.getLogger(JunitTestFrameworkStrategy.class);
    static final Set<String> ERROR_SYNTHETIC_TEST_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("classMethod", "executionError", "initializationError", "unnecessary Mockito stubbings")));

    BaseJunitTestFrameworkStrategy() {
    }

    @Override
    public boolean isLifecycleFailureTest(TestsReader testsReader, String string, String string2) {
        return ERROR_SYNTHETIC_TEST_NAMES.contains(string2);
    }

    protected DefaultTestFilter testFilterFor(TestNames testNames, boolean bl2, TestFrameworkTemplate testFrameworkTemplate) {
        TestFilterBuilder testFilterBuilder = testFrameworkTemplate.filterBuilder();
        this.addFilters(testFilterBuilder, testFrameworkTemplate.testsReader, testNames, bl2);
        return testFilterBuilder.build();
    }

    protected void addFilters(TestFilterBuilder testFilterBuilder, TestsReader testsReader, TestNames testNames, boolean bl2) {
        testNames.stream().forEach(entry -> {
            String string = (String)entry.getKey();
            Set set = (Set)entry.getValue();
            if (set.isEmpty()) {
                testFilterBuilder.clazz(string);
                return;
            }
            if (set.stream().anyMatch(ERROR_SYNTHETIC_TEST_NAMES::contains)) {
                testFilterBuilder.clazz(string);
                return;
            }
            if (this.processSpockTest(testFilterBuilder, testsReader, bl2, string, set)) {
                return;
            }
            set.forEach(string2 -> this.addPotentiallyParameterizedSuffixed(testFilterBuilder, string, (String)string2));
        });
    }

    private boolean processSpockTest(TestFilterBuilder testFilterBuilder, TestsReader testsReader, boolean bl2, String string, Set<String> set) {
        try {
            Optional optional = testsReader.readTestClassDirClass(string, () -> new SpockParameterClassVisitor(set, testsReader));
            if (optional.isPresent()) {
                Map map = (Map)optional.get();
                if (map.isEmpty()) {
                    return false;
                }
                if (bl2) {
                    map.forEach((string3, list) -> {
                        if (list.isEmpty()) {
                            this.addPotentiallyParameterizedSuffixed(testFilterBuilder, string, (String)string3);
                        } else {
                            list.forEach(string2 -> testFilterBuilder.test(string, (String)string2));
                        }
                    });
                } else {
                    boolean bl3 = map.entrySet().stream().allMatch(entry -> ((List)entry.getValue()).size() == 1 && ((String)((List)entry.getValue()).get(0)).equals(entry.getKey()));
                    if (bl3) {
                        set.forEach(string2 -> testFilterBuilder.test(string, (String)string2));
                    } else {
                        testFilterBuilder.clazz(string);
                    }
                }
                return true;
            }
        }
        catch (Throwable throwable) {
            LOGGER.warn("Unable to determine if class " + string + " contains Spock @Unroll parameterizations", throwable);
        }
        return false;
    }

    private void addPotentiallyParameterizedSuffixed(TestFilterBuilder testFilterBuilder, String string, String string2) {
        String string3 = string2.replaceAll("(?:\\([^)]*?\\)|\\[[^]]*?])*$", "");
        testFilterBuilder.test(string, string3);
        testFilterBuilder.test(string, string2);
    }
}

