/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.compression;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.component.AbstractLifeCycle;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class CompressionPool<T>
extends AbstractLifeCycle {
    private final Queue<T> _pool;
    private final AtomicInteger _numObjects = new AtomicInteger(0);
    private final int _capacity;

    public CompressionPool(int n2) {
        this._capacity = n2;
        this._pool = this._capacity == 0 ? null : new ConcurrentLinkedQueue();
    }

    protected abstract T newObject();

    protected abstract void end(T var1);

    protected abstract void reset(T var1);

    public T acquire() {
        T t2;
        if (this._capacity == 0) {
            t2 = this.newObject();
        } else {
            t2 = this._pool.poll();
            if (t2 == null) {
                t2 = this.newObject();
            } else if (this._capacity > 0) {
                this._numObjects.decrementAndGet();
            }
        }
        return t2;
    }

    public void release(T t2) {
        block5: {
            if (t2 == null) {
                return;
            }
            if (this._capacity == 0 || !this.isRunning()) {
                this.end(t2);
                return;
            }
            if (this._capacity < 0) {
                this.reset(t2);
                this._pool.add(t2);
            } else {
                int n2;
                do {
                    if ((n2 = this._numObjects.get()) < this._capacity) continue;
                    this.end(t2);
                    break block5;
                } while (!this._numObjects.compareAndSet(n2, n2 + 1));
                this.reset(t2);
                this._pool.add(t2);
            }
        }
    }

    @Override
    public void doStop() {
        T t2 = this._pool.poll();
        while (t2 != null) {
            this.end(t2);
            t2 = this._pool.poll();
        }
        this._numObjects.set(0);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append('@').append(Integer.toHexString(this.hashCode()));
        stringBuilder.append('{').append(this.getState());
        stringBuilder.append(",size=").append(this._pool == null ? -1 : this._pool.size());
        stringBuilder.append(",capacity=").append(this._capacity <= 0 ? "UNLIMITED" : Integer.valueOf(this._capacity));
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

