/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.ContentDecoder;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.ByteBufferPool;
import java.nio.ByteBuffer;

public class GZIPContentDecoder
extends com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.GZIPContentDecoder
implements ContentDecoder {
    public GZIPContentDecoder() {
        this(8192);
    }

    public GZIPContentDecoder(int n2) {
        this(null, n2);
    }

    public GZIPContentDecoder(ByteBufferPool byteBufferPool, int n2) {
        super(byteBufferPool, n2);
    }

    @Override
    protected boolean decodedChunk(ByteBuffer byteBuffer) {
        super.decodedChunk(byteBuffer);
        return true;
    }

    public static class Factory
    extends ContentDecoder.Factory {
        private final int bufferSize;
        private final ByteBufferPool byteBufferPool;

        public Factory() {
            this(8192);
        }

        public Factory(int n2) {
            this(null, n2);
        }

        public Factory(ByteBufferPool byteBufferPool) {
            this(byteBufferPool, 8192);
        }

        public Factory(ByteBufferPool byteBufferPool, int n2) {
            super("gzip");
            this.byteBufferPool = byteBufferPool;
            this.bufferSize = n2;
        }

        @Override
        public ContentDecoder newContentDecoder() {
            return new GZIPContentDecoder(this.byteBufferPool, this.bufferSize);
        }
    }
}

