/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jsr310.deser;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.NumberInput;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jsr310.DecimalUtils;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InstantDeserializer<T extends Temporal>
extends JSR310DateTimeDeserializerBase<T> {
    private static final Pattern ISO8601_UTC_ZERO_OFFSET_SUFFIX_REGEX = Pattern.compile("\\+00:?(00)?$");
    protected static final Pattern ISO8601_COLONLESS_OFFSET_REGEX = Pattern.compile("[+-][0-9]{4}(?=\\[|$)");
    public static final InstantDeserializer<Instant> INSTANT = new InstantDeserializer<Instant>(Instant.class, DateTimeFormatter.ISO_INSTANT, Instant::from, fromIntegerArguments -> Instant.ofEpochMilli(fromIntegerArguments.value), fromDecimalArguments -> Instant.ofEpochSecond(fromDecimalArguments.integer, fromDecimalArguments.fraction), null, true);
    public static final InstantDeserializer<OffsetDateTime> OFFSET_DATE_TIME = new InstantDeserializer<OffsetDateTime>(OffsetDateTime.class, DateTimeFormatter.ISO_OFFSET_DATE_TIME, OffsetDateTime::from, fromIntegerArguments -> OffsetDateTime.ofInstant(Instant.ofEpochMilli(fromIntegerArguments.value), fromIntegerArguments.zoneId), fromDecimalArguments -> OffsetDateTime.ofInstant(Instant.ofEpochSecond(fromDecimalArguments.integer, fromDecimalArguments.fraction), fromDecimalArguments.zoneId), (offsetDateTime, zoneId) -> offsetDateTime.isEqual(OffsetDateTime.MIN) || offsetDateTime.isEqual(OffsetDateTime.MAX) ? offsetDateTime : offsetDateTime.withOffsetSameInstant(zoneId.getRules().getOffset(offsetDateTime.toLocalDateTime())), true);
    public static final InstantDeserializer<ZonedDateTime> ZONED_DATE_TIME = new InstantDeserializer<ZonedDateTime>(ZonedDateTime.class, DateTimeFormatter.ISO_ZONED_DATE_TIME, ZonedDateTime::from, fromIntegerArguments -> ZonedDateTime.ofInstant(Instant.ofEpochMilli(fromIntegerArguments.value), fromIntegerArguments.zoneId), fromDecimalArguments -> ZonedDateTime.ofInstant(Instant.ofEpochSecond(fromDecimalArguments.integer, fromDecimalArguments.fraction), fromDecimalArguments.zoneId), ZonedDateTime::withZoneSameInstant, false);
    protected final Function<FromIntegerArguments, T> fromMilliseconds;
    protected final Function<FromDecimalArguments, T> fromNanoseconds;
    protected final Function<TemporalAccessor, T> parsedToValue;
    protected final BiFunction<T, ZoneId, T> adjust;
    protected final boolean replaceZeroOffsetAsZ;
    protected final Boolean _adjustToContextTZOverride;

    protected InstantDeserializer(Class<T> clazz, DateTimeFormatter dateTimeFormatter, Function<TemporalAccessor, T> function, Function<FromIntegerArguments, T> function2, Function<FromDecimalArguments, T> function3, BiFunction<T, ZoneId, T> biFunction, boolean bl2) {
        super(clazz, dateTimeFormatter);
        this.parsedToValue = function;
        this.fromMilliseconds = function2;
        this.fromNanoseconds = function3;
        this.adjust = biFunction == null ? (temporal, zoneId) -> temporal : biFunction;
        this.replaceZeroOffsetAsZ = bl2;
        this._adjustToContextTZOverride = null;
    }

    protected InstantDeserializer(InstantDeserializer<T> instantDeserializer, DateTimeFormatter dateTimeFormatter) {
        super(instantDeserializer.handledType(), dateTimeFormatter);
        this.parsedToValue = instantDeserializer.parsedToValue;
        this.fromMilliseconds = instantDeserializer.fromMilliseconds;
        this.fromNanoseconds = instantDeserializer.fromNanoseconds;
        this.adjust = instantDeserializer.adjust;
        this.replaceZeroOffsetAsZ = this._formatter == DateTimeFormatter.ISO_INSTANT;
        this._adjustToContextTZOverride = instantDeserializer._adjustToContextTZOverride;
    }

    protected InstantDeserializer(InstantDeserializer<T> instantDeserializer, Boolean bl2) {
        super(instantDeserializer.handledType(), instantDeserializer._formatter);
        this.parsedToValue = instantDeserializer.parsedToValue;
        this.fromMilliseconds = instantDeserializer.fromMilliseconds;
        this.fromNanoseconds = instantDeserializer.fromNanoseconds;
        this.adjust = instantDeserializer.adjust;
        this.replaceZeroOffsetAsZ = instantDeserializer.replaceZeroOffsetAsZ;
        this._adjustToContextTZOverride = bl2;
    }

    protected InstantDeserializer(InstantDeserializer<T> instantDeserializer, DateTimeFormatter dateTimeFormatter, Boolean bl2) {
        super(instantDeserializer.handledType(), dateTimeFormatter, bl2);
        this.parsedToValue = instantDeserializer.parsedToValue;
        this.fromMilliseconds = instantDeserializer.fromMilliseconds;
        this.fromNanoseconds = instantDeserializer.fromNanoseconds;
        this.adjust = instantDeserializer.adjust;
        this.replaceZeroOffsetAsZ = this._formatter == DateTimeFormatter.ISO_INSTANT;
        this._adjustToContextTZOverride = instantDeserializer._adjustToContextTZOverride;
    }

    @Override
    protected InstantDeserializer<T> withDateFormat(DateTimeFormatter dateTimeFormatter) {
        if (dateTimeFormatter == this._formatter) {
            return this;
        }
        return new InstantDeserializer<T>(this, dateTimeFormatter);
    }

    @Override
    protected InstantDeserializer<T> withLeniency(Boolean bl2) {
        return new InstantDeserializer<T>(this, this._formatter, bl2);
    }

    @Override
    protected InstantDeserializer<T> withShape(JsonFormat.Shape shape) {
        return this;
    }

    @Override
    protected JSR310DateTimeDeserializerBase<?> _withFormatOverrides(DeserializationContext deserializationContext, BeanProperty beanProperty, JsonFormat.Value value) {
        InstantDeserializer instantDeserializer = (InstantDeserializer)super._withFormatOverrides(deserializationContext, beanProperty, value);
        Boolean bl2 = value.getFeature(JsonFormat.Feature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
        if (!Objects.equals(bl2, instantDeserializer._adjustToContextTZOverride)) {
            return new InstantDeserializer<T>(instantDeserializer, bl2);
        }
        return instantDeserializer;
    }

    @Override
    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        switch (jsonParser.currentTokenId()) {
            case 8: {
                return this._fromDecimal(deserializationContext, jsonParser.getDecimalValue());
            }
            case 7: {
                return this._fromLong(deserializationContext, jsonParser.getLongValue());
            }
            case 6: {
                return this._fromString(jsonParser, deserializationContext, jsonParser.getText());
            }
            case 1: {
                return this._fromString(jsonParser, deserializationContext, deserializationContext.extractScalarFromObject(jsonParser, this, this.handledType()));
            }
            case 12: {
                return (T)((Temporal)jsonParser.getEmbeddedObject());
            }
            case 3: {
                return (T)((Temporal)this._deserializeFromArray(jsonParser, deserializationContext));
            }
        }
        return (T)((Temporal)this._handleUnexpectedToken(deserializationContext, jsonParser, JsonToken.VALUE_STRING, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_NUMBER_FLOAT));
    }

    protected boolean shouldAdjustToContextTimezone(DeserializationContext deserializationContext) {
        return this._adjustToContextTZOverride != null ? this._adjustToContextTZOverride.booleanValue() : deserializationContext.isEnabled(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
    }

    protected int _countPeriods(String string) {
        int n2 = 0;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '0' && c2 <= '9') continue;
            if (c2 == '.') {
                ++n2;
                continue;
            }
            return -1;
        }
        return n2;
    }

    protected T _fromString(JsonParser jsonParser, DeserializationContext deserializationContext, String string) throws IOException {
        Temporal temporal;
        String string2 = string.trim();
        if (string2.length() == 0) {
            return (T)((Temporal)this._fromEmptyString(jsonParser, deserializationContext, string2));
        }
        if (this._formatter == DateTimeFormatter.ISO_INSTANT || this._formatter == DateTimeFormatter.ISO_OFFSET_DATE_TIME || this._formatter == DateTimeFormatter.ISO_ZONED_DATE_TIME) {
            int n2 = this._countPeriods(string2);
            if (n2 >= 0) {
                try {
                    if (n2 == 0) {
                        return this._fromLong(deserializationContext, NumberInput.parseLong(string2));
                    }
                    if (n2 == 1) {
                        return this._fromDecimal(deserializationContext, NumberInput.parseBigDecimal(string2));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            string2 = this.replaceZeroOffsetAsZIfNecessary(string2);
        }
        if (this._formatter == DateTimeFormatter.ISO_OFFSET_DATE_TIME || this._formatter == DateTimeFormatter.ISO_ZONED_DATE_TIME) {
            string2 = this.addInColonToOffsetIfMissing(string2);
        }
        try {
            TemporalAccessor temporalAccessor = this._formatter.parse(string2);
            temporal = (Temporal)this.parsedToValue.apply(temporalAccessor);
            if (this.shouldAdjustToContextTimezone(deserializationContext)) {
                return (T)((Temporal)this.adjust.apply(temporal, this.getZone(deserializationContext)));
            }
        }
        catch (DateTimeException dateTimeException) {
            temporal = (Temporal)this._handleDateTimeException(deserializationContext, dateTimeException, string2);
        }
        return (T)temporal;
    }

    protected T _fromLong(DeserializationContext deserializationContext, long l2) {
        if (deserializationContext.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
            return (T)((Temporal)this.fromNanoseconds.apply(new FromDecimalArguments(l2, 0, this.getZone(deserializationContext))));
        }
        return (T)((Temporal)this.fromMilliseconds.apply(new FromIntegerArguments(l2, this.getZone(deserializationContext))));
    }

    protected T _fromDecimal(DeserializationContext deserializationContext, BigDecimal bigDecimal) {
        FromDecimalArguments fromDecimalArguments = DecimalUtils.extractSecondsAndNanos(bigDecimal, (l2, n2) -> new FromDecimalArguments((long)l2, (int)n2, this.getZone(deserializationContext)));
        return (T)((Temporal)this.fromNanoseconds.apply(fromDecimalArguments));
    }

    private ZoneId getZone(DeserializationContext deserializationContext) {
        return this._valueClass == Instant.class ? null : deserializationContext.getTimeZone().toZoneId();
    }

    private String replaceZeroOffsetAsZIfNecessary(String string) {
        if (this.replaceZeroOffsetAsZ) {
            return ISO8601_UTC_ZERO_OFFSET_SUFFIX_REGEX.matcher(string).replaceFirst("Z");
        }
        return string;
    }

    private String addInColonToOffsetIfMissing(String string) {
        Matcher matcher = ISO8601_COLONLESS_OFFSET_REGEX.matcher(string);
        if (matcher.find()) {
            StringBuilder stringBuilder = new StringBuilder(matcher.group(0));
            stringBuilder.insert(3, ":");
            return matcher.replaceFirst(stringBuilder.toString());
        }
        return string;
    }

    public static class FromDecimalArguments {
        public final long integer;
        public final int fraction;
        public final ZoneId zoneId;

        FromDecimalArguments(long l2, int n2, ZoneId zoneId) {
            this.integer = l2;
            this.fraction = n2;
            this.zoneId = zoneId;
        }
    }

    public static class FromIntegerArguments {
        public final long value;
        public final ZoneId zoneId;

        FromIntegerArguments(long l2, ZoneId zoneId) {
            this.value = l2;
            this.zoneId = zoneId;
        }
    }
}

