/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.events.annotated;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.InvalidWebSocketException;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.events.ParamList;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.events.annotated.CallableMethod;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.events.annotated.InvalidSignatureException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public abstract class AbstractMethodAnnotationScanner<T> {
    protected void assertIsPublicNonStatic(Method method) {
        int n2 = method.getModifiers();
        if (!Modifier.isPublic(n2)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid declaration of ");
            stringBuilder.append(method);
            stringBuilder.append(System.lineSeparator());
            stringBuilder.append("Method modifier must be public");
            throw new InvalidWebSocketException(stringBuilder.toString());
        }
        if (Modifier.isStatic(n2)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid declaration of ");
            stringBuilder.append(method);
            stringBuilder.append(System.lineSeparator());
            stringBuilder.append("Method modifier may not be static");
            throw new InvalidWebSocketException(stringBuilder.toString());
        }
    }

    protected void assertIsReturn(Method method, Class<?> clazz) {
        if (!clazz.equals(method.getReturnType())) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid declaration of ");
            stringBuilder.append(method);
            stringBuilder.append(System.lineSeparator());
            stringBuilder.append("Return type must be ").append(clazz);
            throw new InvalidWebSocketException(stringBuilder.toString());
        }
    }

    protected void assertUnset(CallableMethod callableMethod, Class<? extends Annotation> clazz, Method method) {
        if (callableMethod != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Duplicate @").append(clazz.getSimpleName()).append(" declaration on ");
            stringBuilder.append(method);
            stringBuilder.append(System.lineSeparator());
            stringBuilder.append("@").append(clazz.getSimpleName()).append(" previously declared at ");
            stringBuilder.append(callableMethod.getMethod());
            throw new InvalidWebSocketException(stringBuilder.toString());
        }
    }

    protected void assertValidSignature(Method method, Class<? extends Annotation> clazz, ParamList paramList) {
        this.assertIsPublicNonStatic(method);
        this.assertIsReturn(method, Void.TYPE);
        boolean bl2 = false;
        Class<?>[] classArray = method.getParameterTypes();
        for (Class[] classArray2 : paramList) {
            if (!this.isSameParameters(classArray, classArray2)) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            throw InvalidSignatureException.build(method, clazz, paramList);
        }
    }

    public boolean isAnnotation(Annotation annotation, Class<? extends Annotation> clazz) {
        return annotation.annotationType().equals(clazz);
    }

    public boolean isSameParameters(Class<?>[] classArray, Class<?>[] classArray2) {
        if (classArray.length != classArray2.length) {
            return false;
        }
        int n2 = classArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (classArray[i2].equals(classArray2[i2])) continue;
            return false;
        }
        return true;
    }

    protected boolean isSignatureMatch(Method method, ParamList paramList) {
        this.assertIsPublicNonStatic(method);
        this.assertIsReturn(method, Void.TYPE);
        Class<?>[] classArray = method.getParameterTypes();
        for (Class[] classArray2 : paramList) {
            if (!this.isSameParameters(classArray, classArray2)) continue;
            return true;
        }
        return false;
    }

    public abstract void onMethodAnnotation(T var1, Class<?> var2, Method var3, Annotation var4);

    public void scanMethodAnnotations(T t2, Class<?> clazz) {
        for (Class<?> clazz2 = clazz; clazz2 != null && Object.class.isAssignableFrom(clazz2); clazz2 = clazz2.getSuperclass()) {
            for (Method method : clazz2.getDeclaredMethods()) {
                Annotation[] annotationArray = method.getAnnotations();
                if (annotationArray == null || annotationArray.length <= 0) continue;
                for (Annotation annotation : annotationArray) {
                    this.onMethodAnnotation(t2, clazz2, method, annotation);
                }
            }
        }
    }
}

