/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.resource;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.resource.BadResource;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.resource.JarFileResource;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.resource.JarResource;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.resource.PathResource;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.resource.URLResource;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;

public abstract class Resource
implements Closeable {
    private static final Logger LOG = Log.getLogger(Resource.class);
    public static boolean __defaultUseCaches = true;

    public static Resource newResource(URL uRL) {
        return Resource.newResource(uRL, __defaultUseCaches);
    }

    static Resource newResource(URL uRL, boolean bl2) {
        if (uRL == null) {
            return null;
        }
        String string = uRL.toExternalForm();
        if (string.startsWith("file:")) {
            try {
                return new PathResource(uRL);
            }
            catch (Exception exception) {
                LOG.warn(exception.toString(), new Object[0]);
                LOG.debug("EXCEPTION ", exception);
                return new BadResource(uRL, exception.toString());
            }
        }
        if (string.startsWith("jar:file:")) {
            return new JarFileResource(uRL, bl2);
        }
        if (string.startsWith("jar:")) {
            return new JarResource(uRL, bl2);
        }
        return new URLResource(uRL, null, bl2);
    }

    public static Resource newResource(String string) throws IOException {
        return Resource.newResource(string, __defaultUseCaches);
    }

    public static Resource newResource(String string, boolean bl2) throws IOException {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            if (!(string.startsWith("ftp:") || string.startsWith("file:") || string.startsWith("jar:"))) {
                return new PathResource(Paths.get(string, new String[0]));
            }
            LOG.warn("Bad Resource: " + string, new Object[0]);
            throw malformedURLException;
        }
        return Resource.newResource(uRL, bl2);
    }

    protected void finalize() {
        this.close();
    }

    @Override
    public abstract void close();

    public abstract boolean exists();

    public abstract String getName();

    public abstract InputStream getInputStream() throws IOException;
}

