/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.io.InputStream;
import java.time.Instant;
import java.util.Properties;

public class Jetty {
    private static final Logger LOG;
    public static final String VERSION;
    public static final String POWERED_BY;
    public static final boolean STABLE;
    public static final String GIT_HASH;
    public static final String BUILD_TIMESTAMP;
    private static final Properties __buildProperties;

    private Jetty() {
    }

    private static String formatTimestamp(String string) {
        try {
            long l2 = Long.parseLong(string);
            return Instant.ofEpochMilli(l2).toString();
        }
        catch (NumberFormatException numberFormatException) {
            LOG.ignore(numberFormatException);
            return "unknown";
        }
    }

    static {
        Object object;
        LOG = Log.getLogger(Jetty.class);
        __buildProperties = new Properties();
        try {
            object = Jetty.class.getResourceAsStream("/com/gradle/scan/plugin/internal/dep/org/eclipse/jetty/version/build.properties");
            try {
                __buildProperties.load((InputStream)object);
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
        }
        catch (Exception exception) {
            LOG.ignore(exception);
        }
        object = __buildProperties.getProperty("buildNumber", "unknown");
        if (((String)object).startsWith("${")) {
            object = "unknown";
        }
        GIT_HASH = object;
        System.setProperty("jetty.git.hash", GIT_HASH);
        BUILD_TIMESTAMP = Jetty.formatTimestamp(__buildProperties.getProperty("timestamp", "unknown"));
        Package package_ = Jetty.class.getPackage();
        VERSION = package_ != null && "Eclipse Jetty Project".equals(package_.getImplementationVendor()) && package_.getImplementationVersion() != null ? package_.getImplementationVersion() : System.getProperty("jetty.version", __buildProperties.getProperty("version", "9.4.z-SNAPSHOT"));
        POWERED_BY = "<a href=\"https://eclipse.org/jetty\">Powered by Jetty:// " + VERSION + "</a>";
        STABLE = !VERSION.matches("^.*\\.(RC|M)[0-9]+$");
    }
}

