/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.ArrayTrie;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.Trie;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.TypeUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.URIUtil;
import java.util.EnumSet;

public class HttpURI {
    private static final Trie<Boolean> __ambiguousSegments = new ArrayTrie<Boolean>();
    private String _scheme;
    private String _user;
    private String _host;
    private int _port;
    private String _path;
    private String _param;
    private String _query;
    private String _fragment;
    private String _uri;
    private String _decodedPath;
    private final EnumSet<Violation> _violations = EnumSet.noneOf(Violation.class);
    private boolean _emptySegment;

    public HttpURI() {
    }

    public HttpURI(String string) {
        this._port = -1;
        this.parse(State.START, string, 0, string.length());
    }

    private void parse(State state, String string, int n2, int n3) {
        int n4 = n2;
        int n5 = 0;
        int n6 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n7 = 0;
        int n8 = 0;
        boolean bl4 = false;
        block75: for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            switch (state) {
                case START: {
                    switch (c2) {
                        case '/': {
                            n4 = i2;
                            state = State.HOST_OR_PATH;
                            continue block75;
                        }
                        case ';': {
                            this.checkSegment(string, n6, i2, true);
                            n4 = i2 + 1;
                            state = State.PARAM;
                            continue block75;
                        }
                        case '?': {
                            this.checkSegment(string, n6, i2, false);
                            this._path = "";
                            n4 = i2 + 1;
                            state = State.QUERY;
                            continue block75;
                        }
                        case '#': {
                            this.checkSegment(string, n6, i2, false);
                            this._path = "";
                            n4 = i2 + 1;
                            state = State.FRAGMENT;
                            continue block75;
                        }
                        case '*': {
                            this._path = "*";
                            state = State.ASTERISK;
                            continue block75;
                        }
                        case '%': {
                            bl2 = true;
                            n7 = 2;
                            n8 = 0;
                            n5 = n6 = i2;
                            n4 = n6;
                            state = State.PATH;
                            continue block75;
                        }
                        case '.': {
                            bl4 = true;
                            n5 = n6 = i2;
                            state = State.PATH;
                            continue block75;
                        }
                    }
                    n4 = i2;
                    if (this._scheme == null) {
                        state = State.SCHEME_OR_PATH;
                        continue block75;
                    }
                    n5 = n6 = i2;
                    state = State.PATH;
                    continue block75;
                }
                case SCHEME_OR_PATH: {
                    switch (c2) {
                        case ':': {
                            this._scheme = string.substring(n4, i2);
                            state = State.START;
                            continue block75;
                        }
                        case '/': {
                            n6 = i2 + 1;
                            state = State.PATH;
                            continue block75;
                        }
                        case ';': {
                            n4 = i2 + 1;
                            state = State.PARAM;
                            continue block75;
                        }
                        case '?': {
                            this._path = string.substring(n4, i2);
                            n4 = i2 + 1;
                            state = State.QUERY;
                            continue block75;
                        }
                        case '%': {
                            bl2 = true;
                            n7 = 2;
                            n8 = 0;
                            state = State.PATH;
                            continue block75;
                        }
                        case '#': {
                            this._path = string.substring(n4, i2);
                            state = State.FRAGMENT;
                            continue block75;
                        }
                    }
                    continue block75;
                }
                case HOST_OR_PATH: {
                    switch (c2) {
                        case '/': {
                            this._host = "";
                            n4 = i2 + 1;
                            state = State.HOST;
                            continue block75;
                        }
                        case '#': 
                        case '%': 
                        case '.': 
                        case ';': 
                        case '?': 
                        case '@': {
                            --i2;
                            n5 = n4;
                            n6 = n4 + 1;
                            state = State.PATH;
                            continue block75;
                        }
                    }
                    n5 = n4;
                    n6 = n4 + 1;
                    state = State.PATH;
                    continue block75;
                }
                case HOST: {
                    switch (c2) {
                        case '/': {
                            this._host = string.substring(n4, i2);
                            n5 = n4 = i2;
                            n6 = n4 + 1;
                            state = State.PATH;
                            continue block75;
                        }
                        case ':': {
                            if (i2 > n4) {
                                this._host = string.substring(n4, i2);
                            }
                            n4 = i2 + 1;
                            state = State.PORT;
                            continue block75;
                        }
                        case '@': {
                            if (this._user != null) {
                                throw new IllegalArgumentException("Bad authority");
                            }
                            this._user = string.substring(n4, i2);
                            n4 = i2 + 1;
                            continue block75;
                        }
                        case '[': {
                            state = State.IPV6;
                            continue block75;
                        }
                    }
                    continue block75;
                }
                case IPV6: {
                    switch (c2) {
                        case '/': {
                            throw new IllegalArgumentException("No closing ']' for ipv6 in " + string);
                        }
                        case ']': {
                            c2 = string.charAt(++i2);
                            this._host = string.substring(n4, i2);
                            if (c2 == ':') {
                                n4 = i2 + 1;
                                state = State.PORT;
                                continue block75;
                            }
                            n5 = n4 = i2;
                            state = State.PATH;
                            continue block75;
                        }
                    }
                    continue block75;
                }
                case PORT: {
                    if (c2 == '@') {
                        if (this._user != null) {
                            throw new IllegalArgumentException("Bad authority");
                        }
                        this._user = this._host + ":" + string.substring(n4, i2);
                        n4 = i2 + 1;
                        state = State.HOST;
                        continue block75;
                    }
                    if (c2 != '/') continue block75;
                    this._port = TypeUtil.parseInt(string, n4, i2 - n4, 10);
                    n5 = n4 = i2;
                    n6 = i2 + 1;
                    state = State.PATH;
                    continue block75;
                }
                case PATH: {
                    if (n7 > 0) {
                        if (n7 == 2 && c2 == 'u' && !bl3) {
                            this._violations.add(Violation.UTF16);
                            bl3 = true;
                            n7 = 4;
                            continue block75;
                        }
                        n8 = (n8 << 4) + TypeUtil.convertHexDigit(c2);
                        if (--n7 != 0) continue block75;
                        switch (n8) {
                            case 0: {
                                throw new IllegalArgumentException("Illegal character in path");
                            }
                            case 47: {
                                this._violations.add(Violation.SEPARATOR);
                                continue block75;
                            }
                            case 37: {
                                this._violations.add(Violation.ENCODING);
                                continue block75;
                            }
                        }
                        continue block75;
                    }
                    switch (c2) {
                        case ';': {
                            this.checkSegment(string, n6, i2, true);
                            n4 = i2 + 1;
                            state = State.PARAM;
                            continue block75;
                        }
                        case '?': {
                            this.checkSegment(string, n6, i2, false);
                            this._path = string.substring(n5, i2);
                            n4 = i2 + 1;
                            state = State.QUERY;
                            continue block75;
                        }
                        case '#': {
                            this.checkSegment(string, n6, i2, false);
                            this._path = string.substring(n5, i2);
                            n4 = i2 + 1;
                            state = State.FRAGMENT;
                            continue block75;
                        }
                        case '/': {
                            if (i2 != 0) {
                                this.checkSegment(string, n6, i2, false);
                            }
                            n6 = i2 + 1;
                            continue block75;
                        }
                        case '.': {
                            bl4 |= n6 == i2;
                            continue block75;
                        }
                        case '%': {
                            bl2 = true;
                            bl3 = false;
                            n7 = 2;
                            n8 = 0;
                            continue block75;
                        }
                    }
                    continue block75;
                }
                case PARAM: {
                    switch (c2) {
                        case '?': {
                            this._path = string.substring(n5, i2);
                            this._param = string.substring(n4, i2);
                            n4 = i2 + 1;
                            state = State.QUERY;
                            continue block75;
                        }
                        case '#': {
                            this._path = string.substring(n5, i2);
                            this._param = string.substring(n4, i2);
                            n4 = i2 + 1;
                            state = State.FRAGMENT;
                            continue block75;
                        }
                        case '/': {
                            bl2 = true;
                            n6 = i2 + 1;
                            state = State.PATH;
                            continue block75;
                        }
                        case ';': {
                            n4 = i2 + 1;
                            continue block75;
                        }
                    }
                    continue block75;
                }
                case QUERY: {
                    if (c2 != '#') continue block75;
                    this._query = string.substring(n4, i2);
                    n4 = i2 + 1;
                    state = State.FRAGMENT;
                    continue block75;
                }
                case ASTERISK: {
                    throw new IllegalArgumentException("Bad character '*'");
                }
                case FRAGMENT: {
                    this._fragment = string.substring(n4, n3);
                    i2 = n3;
                    continue block75;
                }
                default: {
                    throw new IllegalStateException(state.toString());
                }
            }
        }
        switch (state) {
            case START: {
                this._path = "";
                this.checkSegment(string, n6, n3, false);
                break;
            }
            case ASTERISK: {
                break;
            }
            case SCHEME_OR_PATH: 
            case HOST_OR_PATH: {
                this._path = string.substring(n4, n3);
                break;
            }
            case HOST: {
                if (n3 <= n4) break;
                this._host = string.substring(n4, n3);
                break;
            }
            case IPV6: {
                throw new IllegalArgumentException("No closing ']' for ipv6 in " + string);
            }
            case PORT: {
                this._port = TypeUtil.parseInt(string, n4, n3 - n4, 10);
                break;
            }
            case PARAM: {
                this._path = string.substring(n5, n3);
                this._param = string.substring(n4, n3);
                break;
            }
            case PATH: {
                this.checkSegment(string, n6, n3, false);
                this._path = string.substring(n5, n3);
                break;
            }
            case QUERY: {
                this._query = string.substring(n4, n3);
                break;
            }
            case FRAGMENT: {
                this._fragment = string.substring(n4, n3);
                break;
            }
            default: {
                throw new IllegalStateException(state.toString());
            }
        }
        if (!bl2 && !bl4) {
            this._decodedPath = this._param == null ? this._path : this._path.substring(0, this._path.length() - this._param.length() - 1);
        } else if (this._path != null) {
            String string2 = URIUtil.decodePath(this._path);
            this._decodedPath = URIUtil.canonicalPath(string2);
            if (this._decodedPath == null) {
                throw new IllegalArgumentException("Bad URI");
            }
        }
    }

    private void checkSegment(String string, int n2, int n3, boolean bl2) {
        Boolean bl3;
        if (this._emptySegment) {
            this._violations.add(Violation.EMPTY);
        }
        if (n3 == n2) {
            if (n3 >= string.length() || "#?".indexOf(string.charAt(n3)) >= 0) {
                return;
            }
            if (n2 == 0) {
                this._violations.add(Violation.EMPTY);
                return;
            }
            if (!this._emptySegment) {
                this._emptySegment = true;
                return;
            }
        }
        if ((bl3 = __ambiguousSegments.get(string, n2, n3 - n2)) != null) {
            if (Boolean.TRUE.equals(bl3)) {
                this._violations.add(Violation.SEGMENT);
            }
            if (bl2) {
                this._violations.add(Violation.PARAM);
            }
        }
    }

    public String toString() {
        if (this._uri == null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this._scheme != null) {
                stringBuilder.append(this._scheme).append(':');
            }
            if (this._host != null) {
                stringBuilder.append("//");
                if (this._user != null) {
                    stringBuilder.append(this._user).append('@');
                }
                stringBuilder.append(this._host);
            }
            if (this._port > 0) {
                stringBuilder.append(':').append(this._port);
            }
            if (this._path != null) {
                stringBuilder.append(this._path);
            }
            if (this._query != null) {
                stringBuilder.append('?').append(this._query);
            }
            if (this._fragment != null) {
                stringBuilder.append('#').append(this._fragment);
            }
            this._uri = stringBuilder.length() > 0 ? stringBuilder.toString() : "";
        }
        return this._uri;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HttpURI)) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    static {
        __ambiguousSegments.put(".", Boolean.FALSE);
        __ambiguousSegments.put("%2e", Boolean.TRUE);
        __ambiguousSegments.put("%u002e", Boolean.TRUE);
        __ambiguousSegments.put("..", Boolean.FALSE);
        __ambiguousSegments.put(".%2e", Boolean.TRUE);
        __ambiguousSegments.put(".%u002e", Boolean.TRUE);
        __ambiguousSegments.put("%2e.", Boolean.TRUE);
        __ambiguousSegments.put("%2e%2e", Boolean.TRUE);
        __ambiguousSegments.put("%2e%u002e", Boolean.TRUE);
        __ambiguousSegments.put("%u002e.", Boolean.TRUE);
        __ambiguousSegments.put("%u002e%2e", Boolean.TRUE);
        __ambiguousSegments.put("%u002e%u002e", Boolean.TRUE);
    }

    static enum Violation {
        SEGMENT("Ambiguous path segments"),
        SEPARATOR("Ambiguous path separator"),
        PARAM("Ambiguous path parameters"),
        ENCODING("Ambiguous double encoding"),
        EMPTY("Ambiguous empty segments"),
        UTF16("Non standard UTF-16 encoding");

        private final String _message;

        private Violation(String string2) {
            this._message = string2;
        }
    }

    private static enum State {
        START,
        HOST_OR_PATH,
        SCHEME_OR_PATH,
        HOST,
        IPV6,
        PORT,
        PATH,
        PARAM,
        QUERY,
        FRAGMENT,
        ASTERISK;

    }
}

