/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.ArrayTrie;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.BufferUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.Trie;
import java.nio.ByteBuffer;

public enum HttpScheme {
    HTTP("http"),
    HTTPS("https"),
    WS("ws"),
    WSS("wss");

    public static final Trie<HttpScheme> CACHE;
    private final String _string;
    private final ByteBuffer _buffer;

    private HttpScheme(String string2) {
        this._string = string2;
        this._buffer = BufferUtil.toBuffer(string2);
    }

    public boolean is(String string) {
        return string != null && this._string.equalsIgnoreCase(string);
    }

    public String asString() {
        return this._string;
    }

    public String toString() {
        return this._string;
    }

    static {
        CACHE = new ArrayTrie<HttpScheme>();
        for (HttpScheme httpScheme : HttpScheme.values()) {
            CACHE.put(httpScheme.asString(), httpScheme);
        }
    }
}

