/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.dev.failsafe;

import com.gradle.scan.plugin.internal.dep.dev.failsafe.Policy;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.function.CheckedRunnable;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.internal.util.Assert;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.spi.ExecutionInternal;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.spi.ExecutionResult;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.spi.PolicyExecutor;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

class ExecutionImpl<R>
implements ExecutionInternal<R> {
    final List<PolicyExecutor<R>> policyExecutors;
    private volatile Duration startTime;
    private final AtomicInteger attempts;
    private final AtomicInteger executions;
    private final AtomicReference<ExecutionInternal<R>> latest;
    private final ExecutionResult<R> previousResult;
    volatile ExecutionResult<R> result;
    volatile Duration attemptStartTime;
    volatile int cancelledIndex = Integer.MIN_VALUE;
    volatile CheckedRunnable cancelCallback;
    private volatile boolean preExecuted;
    volatile boolean attemptRecorded;
    volatile boolean completed;

    ExecutionImpl(List<? extends Policy<R>> list) {
        this.policyExecutors = new ArrayList<PolicyExecutor<R>>(list.size());
        this.startTime = Duration.ZERO;
        this.attemptStartTime = Duration.ZERO;
        this.attempts = new AtomicInteger();
        this.executions = new AtomicInteger();
        this.latest = new AtomicReference<ExecutionImpl>(this);
        this.previousResult = null;
        ListIterator<Policy<R>> listIterator = list.listIterator(list.size());
        int n2 = 0;
        while (listIterator.hasPrevious()) {
            Policy<R> policy = Assert.notNull(listIterator.previous(), "policies");
            PolicyExecutor<R> policyExecutor = policy.toExecutor(n2);
            this.policyExecutors.add(policyExecutor);
            ++n2;
        }
    }

    ExecutionImpl(ExecutionImpl<R> executionImpl) {
        this.policyExecutors = executionImpl.policyExecutors;
        this.startTime = executionImpl.startTime;
        this.attempts = executionImpl.attempts;
        this.executions = executionImpl.executions;
        this.latest = executionImpl.latest;
        this.latest.set(this);
        this.previousResult = executionImpl.result;
    }

    @Override
    public ExecutionResult<R> getResult() {
        return this.result;
    }

    @Override
    public synchronized void preExecute() {
        if (!this.preExecuted) {
            this.attemptStartTime = Duration.ofNanos(System.nanoTime());
            if (this.startTime == Duration.ZERO) {
                this.startTime = this.attemptStartTime;
            }
            this.preExecuted = true;
        }
    }

    @Override
    public boolean isPreExecuted() {
        return this.preExecuted;
    }

    @Override
    public synchronized void recordAttempt() {
        if (!this.attemptRecorded) {
            this.attempts.incrementAndGet();
            this.attemptRecorded = true;
        }
    }

    @Override
    public synchronized void record(ExecutionResult<R> executionResult) {
        if (this.preExecuted && !this.attemptRecorded) {
            this.recordAttempt();
            this.executions.incrementAndGet();
            this.result = executionResult;
        }
    }

    @Override
    public boolean cancel() {
        boolean bl2 = this.isCancelled();
        if (!bl2) {
            this.cancelledIndex = Integer.MAX_VALUE;
            if (this.cancelCallback != null) {
                try {
                    this.cancelCallback.run();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return !bl2 && !this.completed;
    }

    public boolean isCancelled() {
        return this.cancelledIndex > Integer.MIN_VALUE;
    }

    @Override
    public boolean isCancelled(PolicyExecutor<R> policyExecutor) {
        return this.cancelledIndex > policyExecutor.getPolicyIndex();
    }

    @Override
    public Object getLock() {
        return this.latest;
    }

    @Override
    public Duration getElapsedTime() {
        return Duration.ofNanos(System.nanoTime() - this.startTime.toNanos());
    }

    @Override
    public int getAttemptCount() {
        return this.attempts.get();
    }

    @Override
    public <T extends Throwable> T getLastException() {
        ExecutionResult<R> executionResult = this.result != null ? this.result : this.previousResult;
        return (T)(executionResult == null ? null : executionResult.getException());
    }

    @Override
    public R getLastResult() {
        ExecutionResult<R> executionResult = this.result != null ? this.result : this.previousResult;
        return executionResult == null ? null : (R)executionResult.getResult();
    }

    public String toString() {
        return "[attempts=" + this.attempts + ", executions=" + this.executions + ", lastResult=" + this.getLastResult() + ", lastException=" + this.getLastException() + ']';
    }
}

