/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.std;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.Nulls;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Base64Variants;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.exc.StreamReadException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationConfig;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.impl.NullsFailProvider;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.type.LogicalType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.AccessPattern;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.PrimitiveArrayBuilder;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;

public abstract class PrimitiveArrayDeserializers<T>
extends StdDeserializer<T>
implements ContextualDeserializer {
    protected final Boolean _unwrapSingle;
    private transient Object _emptyValue;
    protected final NullValueProvider _nuller;

    protected PrimitiveArrayDeserializers(Class<T> clazz) {
        super(clazz);
        this._unwrapSingle = null;
        this._nuller = null;
    }

    protected PrimitiveArrayDeserializers(PrimitiveArrayDeserializers<?> primitiveArrayDeserializers, NullValueProvider nullValueProvider, Boolean bl2) {
        super(primitiveArrayDeserializers._valueClass);
        this._unwrapSingle = bl2;
        this._nuller = nullValueProvider;
    }

    public static JsonDeserializer<?> forType(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return IntDeser.instance;
        }
        if (clazz == Long.TYPE) {
            return LongDeser.instance;
        }
        if (clazz == Byte.TYPE) {
            return new ByteDeser();
        }
        if (clazz == Short.TYPE) {
            return new ShortDeser();
        }
        if (clazz == Float.TYPE) {
            return new FloatDeser();
        }
        if (clazz == Double.TYPE) {
            return new DoubleDeser();
        }
        if (clazz == Boolean.TYPE) {
            return new BooleanDeser();
        }
        if (clazz == Character.TYPE) {
            return new CharDeser();
        }
        throw new IllegalStateException();
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        Boolean bl2 = this.findFormatFeature(deserializationContext, beanProperty, this._valueClass, JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        NullValueProvider nullValueProvider = null;
        Nulls nulls = this.findContentNullStyle(deserializationContext, beanProperty);
        if (nulls == Nulls.SKIP) {
            nullValueProvider = NullsConstantProvider.skipper();
        } else if (nulls == Nulls.FAIL) {
            nullValueProvider = beanProperty == null ? NullsFailProvider.constructForRootValue(deserializationContext.constructType(this._valueClass.getComponentType())) : NullsFailProvider.constructForProperty(beanProperty, beanProperty.getType().getContentType());
        }
        if (Objects.equals(bl2, this._unwrapSingle) && nullValueProvider == this._nuller) {
            return this;
        }
        return this.withResolved(nullValueProvider, bl2);
    }

    protected abstract T _concat(T var1, T var2);

    protected abstract T handleSingleElementUnwrapped(JsonParser var1, DeserializationContext var2) throws IOException;

    protected abstract PrimitiveArrayDeserializers<?> withResolved(NullValueProvider var1, Boolean var2);

    protected abstract T _constructEmpty();

    @Override
    public LogicalType logicalType() {
        return LogicalType.Array;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return Boolean.TRUE;
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.CONSTANT;
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) throws JsonMappingException {
        Object object = this._emptyValue;
        if (object == null) {
            this._emptyValue = object = this._constructEmpty();
        }
        return object;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    @Override
    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, T t2) throws IOException {
        Object t3 = this.deserialize(jsonParser, deserializationContext);
        if (t2 == null) {
            return t3;
        }
        int n2 = Array.getLength(t2);
        if (n2 == 0) {
            return t3;
        }
        return this._concat(t2, t3);
    }

    protected T handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        boolean bl2;
        if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
            return this._deserializeFromString(jsonParser, deserializationContext);
        }
        boolean bl3 = bl2 = this._unwrapSingle == Boolean.TRUE || this._unwrapSingle == null && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (bl2) {
            return this.handleSingleElementUnwrapped(jsonParser, deserializationContext);
        }
        return (T)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
    }

    @JacksonStdImpl
    static final class DoubleDeser
    extends PrimitiveArrayDeserializers<double[]> {
        public DoubleDeser() {
            super(double[].class);
        }

        protected DoubleDeser(DoubleDeser doubleDeser, NullValueProvider nullValueProvider, Boolean bl2) {
            super(doubleDeser, nullValueProvider, bl2);
        }

        @Override
        protected PrimitiveArrayDeserializers<?> withResolved(NullValueProvider nullValueProvider, Boolean bl2) {
            return new DoubleDeser(this, nullValueProvider, bl2);
        }

        @Override
        protected double[] _constructEmpty() {
            return new double[0];
        }

        @Override
        public double[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (!jsonParser.isExpectedStartArrayToken()) {
                return (double[])this.handleNonArray(jsonParser, deserializationContext);
            }
            ArrayBuilders.DoubleBuilder doubleBuilder = deserializationContext.getArrayBuilders().getDoubleBuilder();
            double[] dArray = (double[])doubleBuilder.resetAndStart();
            int n2 = 0;
            try {
                JsonToken jsonToken;
                while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                    if (jsonToken == JsonToken.VALUE_NULL && this._nuller != null) {
                        this._nuller.getNullValue(deserializationContext);
                        continue;
                    }
                    double d2 = this._parseDoublePrimitive(jsonParser, deserializationContext);
                    if (n2 >= dArray.length) {
                        dArray = doubleBuilder.appendCompletedChunk(dArray, n2);
                        n2 = 0;
                    }
                    dArray[n2++] = d2;
                }
            }
            catch (Exception exception) {
                throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)dArray, doubleBuilder.bufferedSize() + n2);
            }
            return doubleBuilder.completeAndClearBuffer(dArray, n2);
        }

        @Override
        protected double[] handleSingleElementUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return new double[]{this._parseDoublePrimitive(jsonParser, deserializationContext)};
        }

        @Override
        protected double[] _concat(double[] dArray, double[] dArray2) {
            int n2 = dArray.length;
            int n3 = dArray2.length;
            double[] dArray3 = Arrays.copyOf(dArray, n2 + n3);
            System.arraycopy(dArray2, 0, dArray3, n2, n3);
            return dArray3;
        }
    }

    @JacksonStdImpl
    static final class FloatDeser
    extends PrimitiveArrayDeserializers<float[]> {
        public FloatDeser() {
            super(float[].class);
        }

        protected FloatDeser(FloatDeser floatDeser, NullValueProvider nullValueProvider, Boolean bl2) {
            super(floatDeser, nullValueProvider, bl2);
        }

        @Override
        protected PrimitiveArrayDeserializers<?> withResolved(NullValueProvider nullValueProvider, Boolean bl2) {
            return new FloatDeser(this, nullValueProvider, bl2);
        }

        @Override
        protected float[] _constructEmpty() {
            return new float[0];
        }

        @Override
        public float[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (!jsonParser.isExpectedStartArrayToken()) {
                return (float[])this.handleNonArray(jsonParser, deserializationContext);
            }
            ArrayBuilders.FloatBuilder floatBuilder = deserializationContext.getArrayBuilders().getFloatBuilder();
            float[] fArray = (float[])floatBuilder.resetAndStart();
            int n2 = 0;
            try {
                JsonToken jsonToken;
                while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                    if (jsonToken == JsonToken.VALUE_NULL && this._nuller != null) {
                        this._nuller.getNullValue(deserializationContext);
                        continue;
                    }
                    float f2 = this._parseFloatPrimitive(jsonParser, deserializationContext);
                    if (n2 >= fArray.length) {
                        fArray = floatBuilder.appendCompletedChunk(fArray, n2);
                        n2 = 0;
                    }
                    fArray[n2++] = f2;
                }
            }
            catch (Exception exception) {
                throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)fArray, floatBuilder.bufferedSize() + n2);
            }
            return floatBuilder.completeAndClearBuffer(fArray, n2);
        }

        @Override
        protected float[] handleSingleElementUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return new float[]{this._parseFloatPrimitive(jsonParser, deserializationContext)};
        }

        @Override
        protected float[] _concat(float[] fArray, float[] fArray2) {
            int n2 = fArray.length;
            int n3 = fArray2.length;
            float[] fArray3 = Arrays.copyOf(fArray, n2 + n3);
            System.arraycopy(fArray2, 0, fArray3, n2, n3);
            return fArray3;
        }
    }

    @JacksonStdImpl
    static final class LongDeser
    extends PrimitiveArrayDeserializers<long[]> {
        public static final LongDeser instance = new LongDeser();

        public LongDeser() {
            super(long[].class);
        }

        protected LongDeser(LongDeser longDeser, NullValueProvider nullValueProvider, Boolean bl2) {
            super(longDeser, nullValueProvider, bl2);
        }

        @Override
        protected PrimitiveArrayDeserializers<?> withResolved(NullValueProvider nullValueProvider, Boolean bl2) {
            return new LongDeser(this, nullValueProvider, bl2);
        }

        @Override
        protected long[] _constructEmpty() {
            return new long[0];
        }

        @Override
        public long[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (!jsonParser.isExpectedStartArrayToken()) {
                return (long[])this.handleNonArray(jsonParser, deserializationContext);
            }
            ArrayBuilders.LongBuilder longBuilder = deserializationContext.getArrayBuilders().getLongBuilder();
            long[] lArray = (long[])longBuilder.resetAndStart();
            int n2 = 0;
            try {
                JsonToken jsonToken;
                while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                    long l2;
                    if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                        l2 = jsonParser.getLongValue();
                    } else if (jsonToken == JsonToken.VALUE_NULL) {
                        if (this._nuller != null) {
                            this._nuller.getNullValue(deserializationContext);
                            continue;
                        }
                        this._verifyNullForPrimitive(deserializationContext);
                        l2 = 0L;
                    } else {
                        l2 = this._parseLongPrimitive(jsonParser, deserializationContext);
                    }
                    if (n2 >= lArray.length) {
                        lArray = longBuilder.appendCompletedChunk(lArray, n2);
                        n2 = 0;
                    }
                    lArray[n2++] = l2;
                }
            }
            catch (Exception exception) {
                throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)lArray, longBuilder.bufferedSize() + n2);
            }
            return longBuilder.completeAndClearBuffer(lArray, n2);
        }

        @Override
        protected long[] handleSingleElementUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return new long[]{this._parseLongPrimitive(jsonParser, deserializationContext)};
        }

        @Override
        protected long[] _concat(long[] lArray, long[] lArray2) {
            int n2 = lArray.length;
            int n3 = lArray2.length;
            long[] lArray3 = Arrays.copyOf(lArray, n2 + n3);
            System.arraycopy(lArray2, 0, lArray3, n2, n3);
            return lArray3;
        }
    }

    @JacksonStdImpl
    static final class IntDeser
    extends PrimitiveArrayDeserializers<int[]> {
        public static final IntDeser instance = new IntDeser();

        public IntDeser() {
            super(int[].class);
        }

        protected IntDeser(IntDeser intDeser, NullValueProvider nullValueProvider, Boolean bl2) {
            super(intDeser, nullValueProvider, bl2);
        }

        @Override
        protected PrimitiveArrayDeserializers<?> withResolved(NullValueProvider nullValueProvider, Boolean bl2) {
            return new IntDeser(this, nullValueProvider, bl2);
        }

        @Override
        protected int[] _constructEmpty() {
            return new int[0];
        }

        @Override
        public int[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (!jsonParser.isExpectedStartArrayToken()) {
                return (int[])this.handleNonArray(jsonParser, deserializationContext);
            }
            ArrayBuilders.IntBuilder intBuilder = deserializationContext.getArrayBuilders().getIntBuilder();
            int[] nArray = (int[])intBuilder.resetAndStart();
            int n2 = 0;
            try {
                JsonToken jsonToken;
                while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                    int n3;
                    if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                        n3 = jsonParser.getIntValue();
                    } else if (jsonToken == JsonToken.VALUE_NULL) {
                        if (this._nuller != null) {
                            this._nuller.getNullValue(deserializationContext);
                            continue;
                        }
                        this._verifyNullForPrimitive(deserializationContext);
                        n3 = 0;
                    } else {
                        n3 = this._parseIntPrimitive(jsonParser, deserializationContext);
                    }
                    if (n2 >= nArray.length) {
                        nArray = intBuilder.appendCompletedChunk(nArray, n2);
                        n2 = 0;
                    }
                    nArray[n2++] = n3;
                }
            }
            catch (Exception exception) {
                throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)nArray, intBuilder.bufferedSize() + n2);
            }
            return intBuilder.completeAndClearBuffer(nArray, n2);
        }

        @Override
        protected int[] handleSingleElementUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return new int[]{this._parseIntPrimitive(jsonParser, deserializationContext)};
        }

        @Override
        protected int[] _concat(int[] nArray, int[] nArray2) {
            int n2 = nArray.length;
            int n3 = nArray2.length;
            int[] nArray3 = Arrays.copyOf(nArray, n2 + n3);
            System.arraycopy(nArray2, 0, nArray3, n2, n3);
            return nArray3;
        }
    }

    @JacksonStdImpl
    static final class ShortDeser
    extends PrimitiveArrayDeserializers<short[]> {
        public ShortDeser() {
            super(short[].class);
        }

        protected ShortDeser(ShortDeser shortDeser, NullValueProvider nullValueProvider, Boolean bl2) {
            super(shortDeser, nullValueProvider, bl2);
        }

        @Override
        protected PrimitiveArrayDeserializers<?> withResolved(NullValueProvider nullValueProvider, Boolean bl2) {
            return new ShortDeser(this, nullValueProvider, bl2);
        }

        @Override
        protected short[] _constructEmpty() {
            return new short[0];
        }

        @Override
        public short[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (!jsonParser.isExpectedStartArrayToken()) {
                return (short[])this.handleNonArray(jsonParser, deserializationContext);
            }
            ArrayBuilders.ShortBuilder shortBuilder = deserializationContext.getArrayBuilders().getShortBuilder();
            short[] sArray = (short[])shortBuilder.resetAndStart();
            int n2 = 0;
            try {
                JsonToken jsonToken;
                while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                    short s2;
                    if (jsonToken == JsonToken.VALUE_NULL) {
                        if (this._nuller != null) {
                            this._nuller.getNullValue(deserializationContext);
                            continue;
                        }
                        this._verifyNullForPrimitive(deserializationContext);
                        s2 = 0;
                    } else {
                        s2 = this._parseShortPrimitive(jsonParser, deserializationContext);
                    }
                    if (n2 >= sArray.length) {
                        sArray = shortBuilder.appendCompletedChunk(sArray, n2);
                        n2 = 0;
                    }
                    sArray[n2++] = s2;
                }
            }
            catch (Exception exception) {
                throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)sArray, shortBuilder.bufferedSize() + n2);
            }
            return shortBuilder.completeAndClearBuffer(sArray, n2);
        }

        @Override
        protected short[] handleSingleElementUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return new short[]{this._parseShortPrimitive(jsonParser, deserializationContext)};
        }

        @Override
        protected short[] _concat(short[] sArray, short[] sArray2) {
            int n2 = sArray.length;
            int n3 = sArray2.length;
            short[] sArray3 = Arrays.copyOf(sArray, n2 + n3);
            System.arraycopy(sArray2, 0, sArray3, n2, n3);
            return sArray3;
        }
    }

    @JacksonStdImpl
    static final class ByteDeser
    extends PrimitiveArrayDeserializers<byte[]> {
        public ByteDeser() {
            super(byte[].class);
        }

        protected ByteDeser(ByteDeser byteDeser, NullValueProvider nullValueProvider, Boolean bl2) {
            super(byteDeser, nullValueProvider, bl2);
        }

        @Override
        protected PrimitiveArrayDeserializers<?> withResolved(NullValueProvider nullValueProvider, Boolean bl2) {
            return new ByteDeser(this, nullValueProvider, bl2);
        }

        @Override
        protected byte[] _constructEmpty() {
            return new byte[0];
        }

        @Override
        public LogicalType logicalType() {
            return LogicalType.Binary;
        }

        @Override
        public byte[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            Object object;
            Object object2;
            JsonToken jsonToken;
            block16: {
                jsonToken = jsonParser.currentToken();
                if (jsonToken == JsonToken.VALUE_STRING) {
                    try {
                        return jsonParser.getBinaryValue(deserializationContext.getBase64Variant());
                    }
                    catch (StreamReadException streamReadException) {
                        object2 = streamReadException.getOriginalMessage();
                        if (!((String)object2).contains("base64")) break block16;
                        return (byte[])deserializationContext.handleWeirdStringValue(byte[].class, jsonParser.getText(), (String)object2, new Object[0]);
                    }
                }
            }
            if (jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
                object = jsonParser.getEmbeddedObject();
                if (object == null) {
                    return null;
                }
                if (object instanceof byte[]) {
                    return (byte[])object;
                }
            }
            if (!jsonParser.isExpectedStartArrayToken()) {
                return (byte[])this.handleNonArray(jsonParser, deserializationContext);
            }
            object = deserializationContext.getArrayBuilders().getByteBuilder();
            object2 = (byte[])((PrimitiveArrayBuilder)object).resetAndStart();
            int n2 = 0;
            try {
                while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                    byte by2;
                    if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                        by2 = jsonParser.getByteValue();
                    } else if (jsonToken == JsonToken.VALUE_NULL) {
                        if (this._nuller != null) {
                            this._nuller.getNullValue(deserializationContext);
                            continue;
                        }
                        this._verifyNullForPrimitive(deserializationContext);
                        by2 = 0;
                    } else {
                        by2 = this._parseBytePrimitive(jsonParser, deserializationContext);
                    }
                    if (n2 >= ((Object)object2).length) {
                        object2 = (byte[])((PrimitiveArrayBuilder)object).appendCompletedChunk(object2, n2);
                        n2 = 0;
                    }
                    object2[n2++] = by2;
                }
            }
            catch (Exception exception) {
                throw JsonMappingException.wrapWithPath((Throwable)exception, object2, ((PrimitiveArrayBuilder)object).bufferedSize() + n2);
            }
            return (byte[])((PrimitiveArrayBuilder)object).completeAndClearBuffer(object2, n2);
        }

        @Override
        protected byte[] handleSingleElementUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            byte by2;
            JsonToken jsonToken = jsonParser.currentToken();
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                by2 = jsonParser.getByteValue();
            } else {
                if (jsonToken == JsonToken.VALUE_NULL) {
                    if (this._nuller != null) {
                        this._nuller.getNullValue(deserializationContext);
                        return (byte[])this.getEmptyValue(deserializationContext);
                    }
                    this._verifyNullForPrimitive(deserializationContext);
                    return null;
                }
                Number number = (Number)deserializationContext.handleUnexpectedToken(this._valueClass.getComponentType(), jsonParser);
                by2 = number.byteValue();
            }
            return new byte[]{by2};
        }

        @Override
        protected byte[] _concat(byte[] byArray, byte[] byArray2) {
            int n2 = byArray.length;
            int n3 = byArray2.length;
            byte[] byArray3 = Arrays.copyOf(byArray, n2 + n3);
            System.arraycopy(byArray2, 0, byArray3, n2, n3);
            return byArray3;
        }
    }

    @JacksonStdImpl
    static final class BooleanDeser
    extends PrimitiveArrayDeserializers<boolean[]> {
        public BooleanDeser() {
            super(boolean[].class);
        }

        protected BooleanDeser(BooleanDeser booleanDeser, NullValueProvider nullValueProvider, Boolean bl2) {
            super(booleanDeser, nullValueProvider, bl2);
        }

        @Override
        protected PrimitiveArrayDeserializers<?> withResolved(NullValueProvider nullValueProvider, Boolean bl2) {
            return new BooleanDeser(this, nullValueProvider, bl2);
        }

        @Override
        protected boolean[] _constructEmpty() {
            return new boolean[0];
        }

        @Override
        public boolean[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (!jsonParser.isExpectedStartArrayToken()) {
                return (boolean[])this.handleNonArray(jsonParser, deserializationContext);
            }
            ArrayBuilders.BooleanBuilder booleanBuilder = deserializationContext.getArrayBuilders().getBooleanBuilder();
            boolean[] blArray = (boolean[])booleanBuilder.resetAndStart();
            int n2 = 0;
            try {
                JsonToken jsonToken;
                while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                    boolean bl2;
                    if (jsonToken == JsonToken.VALUE_TRUE) {
                        bl2 = true;
                    } else if (jsonToken == JsonToken.VALUE_FALSE) {
                        bl2 = false;
                    } else if (jsonToken == JsonToken.VALUE_NULL) {
                        if (this._nuller != null) {
                            this._nuller.getNullValue(deserializationContext);
                            continue;
                        }
                        this._verifyNullForPrimitive(deserializationContext);
                        bl2 = false;
                    } else {
                        bl2 = this._parseBooleanPrimitive(jsonParser, deserializationContext);
                    }
                    if (n2 >= blArray.length) {
                        blArray = booleanBuilder.appendCompletedChunk(blArray, n2);
                        n2 = 0;
                    }
                    blArray[n2++] = bl2;
                }
            }
            catch (Exception exception) {
                throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)blArray, booleanBuilder.bufferedSize() + n2);
            }
            return booleanBuilder.completeAndClearBuffer(blArray, n2);
        }

        @Override
        protected boolean[] handleSingleElementUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return new boolean[]{this._parseBooleanPrimitive(jsonParser, deserializationContext)};
        }

        @Override
        protected boolean[] _concat(boolean[] blArray, boolean[] blArray2) {
            int n2 = blArray.length;
            int n3 = blArray2.length;
            boolean[] blArray3 = Arrays.copyOf(blArray, n2 + n3);
            System.arraycopy(blArray2, 0, blArray3, n2, n3);
            return blArray3;
        }
    }

    @JacksonStdImpl
    static final class CharDeser
    extends PrimitiveArrayDeserializers<char[]> {
        public CharDeser() {
            super(char[].class);
        }

        @Override
        protected PrimitiveArrayDeserializers<?> withResolved(NullValueProvider nullValueProvider, Boolean bl2) {
            return this;
        }

        @Override
        protected char[] _constructEmpty() {
            return new char[0];
        }

        @Override
        public char[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
                char[] cArray = jsonParser.getTextCharacters();
                int n2 = jsonParser.getTextOffset();
                int n3 = jsonParser.getTextLength();
                char[] cArray2 = new char[n3];
                System.arraycopy(cArray, n2, cArray2, 0, n3);
                return cArray2;
            }
            if (jsonParser.isExpectedStartArrayToken()) {
                JsonToken jsonToken;
                StringBuilder stringBuilder = new StringBuilder(64);
                while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                    String string;
                    if (jsonToken == JsonToken.VALUE_STRING) {
                        string = jsonParser.getText();
                    } else if (jsonToken == JsonToken.VALUE_NULL) {
                        if (this._nuller != null) {
                            this._nuller.getNullValue(deserializationContext);
                            continue;
                        }
                        this._verifyNullForPrimitive(deserializationContext);
                        string = "\u0000";
                    } else {
                        CharSequence charSequence = (CharSequence)deserializationContext.handleUnexpectedToken(Character.TYPE, jsonParser);
                        string = charSequence.toString();
                    }
                    if (string.length() != 1) {
                        deserializationContext.reportInputMismatch(this, "Cannot convert a JSON String of length %d into a char element of char array", string.length());
                    }
                    stringBuilder.append(string.charAt(0));
                }
                return stringBuilder.toString().toCharArray();
            }
            if (jsonParser.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
                Object object = jsonParser.getEmbeddedObject();
                if (object == null) {
                    return null;
                }
                if (object instanceof char[]) {
                    return (char[])object;
                }
                if (object instanceof String) {
                    return ((String)object).toCharArray();
                }
                if (object instanceof byte[]) {
                    return Base64Variants.getDefaultVariant().encode((byte[])object, false).toCharArray();
                }
            }
            return (char[])deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
        }

        @Override
        protected char[] handleSingleElementUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return (char[])deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
        }

        @Override
        protected char[] _concat(char[] cArray, char[] cArray2) {
            int n2 = cArray.length;
            int n3 = cArray2.length;
            char[] cArray3 = Arrays.copyOf(cArray, n2 + n3);
            System.arraycopy(cArray2, 0, cArray3, n2, n3);
            return cArray3;
        }
    }
}

