/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.PrettyPrinter;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.Instantiatable;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.BeanDescription;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.SerializationFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.BaseSettings;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.ConfigOverrides;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.MapperConfigBase;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.SimpleMixInResolver;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser.FilterProvider;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.RootNameLookup;
import java.io.Serializable;

public final class SerializationConfig
extends MapperConfigBase<SerializationFeature, SerializationConfig>
implements Serializable {
    protected static final PrettyPrinter DEFAULT_PRETTY_PRINTER = new DefaultPrettyPrinter();
    private static final int SER_FEATURE_DEFAULTS = SerializationConfig.collectFeatureDefaults(SerializationFeature.class);
    protected final FilterProvider _filterProvider;
    protected final PrettyPrinter _defaultPrettyPrinter;
    protected final int _serFeatures;
    protected final int _generatorFeatures;
    protected final int _generatorFeaturesToChange;
    protected final int _formatWriteFeatures;
    protected final int _formatWriteFeaturesToChange;

    public SerializationConfig(BaseSettings baseSettings, SubtypeResolver subtypeResolver, SimpleMixInResolver simpleMixInResolver, RootNameLookup rootNameLookup, ConfigOverrides configOverrides) {
        super(baseSettings, subtypeResolver, simpleMixInResolver, rootNameLookup, configOverrides);
        this._serFeatures = SER_FEATURE_DEFAULTS;
        this._filterProvider = null;
        this._defaultPrettyPrinter = DEFAULT_PRETTY_PRINTER;
        this._generatorFeatures = 0;
        this._generatorFeaturesToChange = 0;
        this._formatWriteFeatures = 0;
        this._formatWriteFeaturesToChange = 0;
    }

    private SerializationConfig(SerializationConfig serializationConfig, long l2, int n2, int n3, int n4, int n5, int n6) {
        super(serializationConfig, l2);
        this._serFeatures = n2;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = n3;
        this._generatorFeaturesToChange = n4;
        this._formatWriteFeatures = n5;
        this._formatWriteFeaturesToChange = n6;
    }

    private SerializationConfig(SerializationConfig serializationConfig, BaseSettings baseSettings) {
        super(serializationConfig, baseSettings);
        this._serFeatures = serializationConfig._serFeatures;
        this._filterProvider = serializationConfig._filterProvider;
        this._defaultPrettyPrinter = serializationConfig._defaultPrettyPrinter;
        this._generatorFeatures = serializationConfig._generatorFeatures;
        this._generatorFeaturesToChange = serializationConfig._generatorFeaturesToChange;
        this._formatWriteFeatures = serializationConfig._formatWriteFeatures;
        this._formatWriteFeaturesToChange = serializationConfig._formatWriteFeaturesToChange;
    }

    @Override
    protected final SerializationConfig _withBase(BaseSettings baseSettings) {
        return this._base == baseSettings ? this : new SerializationConfig(this, baseSettings);
    }

    @Override
    protected final SerializationConfig _withMapperFeatures(long l2) {
        return new SerializationConfig(this, l2, this._serFeatures, this._generatorFeatures, this._generatorFeaturesToChange, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig with(SerializationFeature serializationFeature) {
        int n2 = this._serFeatures | serializationFeature.getMask();
        return n2 == this._serFeatures ? this : new SerializationConfig(this, this._mapperFeatures, n2, this._generatorFeatures, this._generatorFeaturesToChange, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public SerializationConfig without(SerializationFeature serializationFeature) {
        int n2 = this._serFeatures & ~serializationFeature.getMask();
        return n2 == this._serFeatures ? this : new SerializationConfig(this, this._mapperFeatures, n2, this._generatorFeatures, this._generatorFeaturesToChange, this._formatWriteFeatures, this._formatWriteFeaturesToChange);
    }

    public PrettyPrinter constructDefaultPrettyPrinter() {
        PrettyPrinter prettyPrinter = this._defaultPrettyPrinter;
        if (prettyPrinter instanceof Instantiatable) {
            prettyPrinter = (PrettyPrinter)((Instantiatable)((Object)prettyPrinter)).createInstance();
        }
        return prettyPrinter;
    }

    public void initialize(JsonGenerator jsonGenerator) {
        PrettyPrinter prettyPrinter;
        if (SerializationFeature.INDENT_OUTPUT.enabledIn(this._serFeatures) && jsonGenerator.getPrettyPrinter() == null && (prettyPrinter = this.constructDefaultPrettyPrinter()) != null) {
            jsonGenerator.setPrettyPrinter(prettyPrinter);
        }
        boolean bl2 = SerializationFeature.WRITE_BIGDECIMAL_AS_PLAIN.enabledIn(this._serFeatures);
        int n2 = this._generatorFeaturesToChange;
        if (n2 != 0 || bl2) {
            int n3 = this._generatorFeatures;
            if (bl2) {
                int n4 = JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN.getMask();
                n3 |= n4;
                n2 |= n4;
            }
            jsonGenerator.overrideStdFeatures(n3, n2);
        }
        if (this._formatWriteFeaturesToChange != 0) {
            jsonGenerator.overrideFormatFeatures(this._formatWriteFeatures, this._formatWriteFeaturesToChange);
        }
    }

    public final boolean isEnabled(SerializationFeature serializationFeature) {
        return (this._serFeatures & serializationFeature.getMask()) != 0;
    }

    public FilterProvider getFilterProvider() {
        return this._filterProvider;
    }

    public PrettyPrinter getDefaultPrettyPrinter() {
        return this._defaultPrettyPrinter;
    }

    public BeanDescription introspect(JavaType javaType) {
        return this.getClassIntrospector().forSerialization(this, javaType, this);
    }
}

