/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.ByteArrayBuilder;
import java.io.Serializable;
import java.util.Arrays;

public final class Base64Variant
implements Serializable {
    private final transient int[] _asciiToBase64 = new int[128];
    private final transient char[] _base64ToAsciiC = new char[64];
    private final transient byte[] _base64ToAsciiB = new byte[64];
    final String _name;
    private final char _paddingChar;
    private final int _maxLineLength;
    private final boolean _writePadding;
    private final PaddingReadBehaviour _paddingReadBehaviour;

    public Base64Variant(String string, String string2, boolean bl2, char c2, int n2) {
        this._name = string;
        this._writePadding = bl2;
        this._paddingChar = c2;
        this._maxLineLength = n2;
        int n3 = string2.length();
        if (n3 != 64) {
            throw new IllegalArgumentException("Base64Alphabet length must be exactly 64 (was " + n3 + ")");
        }
        string2.getChars(0, n3, this._base64ToAsciiC, 0);
        Arrays.fill(this._asciiToBase64, -1);
        int n4 = 0;
        while (n4 < n3) {
            char c3 = this._base64ToAsciiC[n4];
            this._base64ToAsciiB[n4] = (byte)c3;
            this._asciiToBase64[c3] = n4++;
        }
        if (bl2) {
            this._asciiToBase64[c2] = -2;
        }
        this._paddingReadBehaviour = bl2 ? PaddingReadBehaviour.PADDING_REQUIRED : PaddingReadBehaviour.PADDING_FORBIDDEN;
    }

    public Base64Variant(Base64Variant base64Variant, String string, int n2) {
        this(base64Variant, string, base64Variant._writePadding, base64Variant._paddingChar, n2);
    }

    public Base64Variant(Base64Variant base64Variant, String string, boolean bl2, char c2, int n2) {
        this(base64Variant, string, bl2, c2, base64Variant._paddingReadBehaviour, n2);
    }

    private Base64Variant(Base64Variant base64Variant, String string, boolean bl2, char c2, PaddingReadBehaviour paddingReadBehaviour, int n2) {
        this._name = string;
        byte[] byArray = base64Variant._base64ToAsciiB;
        System.arraycopy(byArray, 0, this._base64ToAsciiB, 0, byArray.length);
        char[] cArray = base64Variant._base64ToAsciiC;
        System.arraycopy(cArray, 0, this._base64ToAsciiC, 0, cArray.length);
        int[] nArray = base64Variant._asciiToBase64;
        System.arraycopy(nArray, 0, this._asciiToBase64, 0, nArray.length);
        this._writePadding = bl2;
        this._paddingChar = c2;
        this._maxLineLength = n2;
        this._paddingReadBehaviour = paddingReadBehaviour;
    }

    public String getName() {
        return this._name;
    }

    public boolean usesPadding() {
        return this._writePadding;
    }

    public boolean requiresPaddingOnRead() {
        return this._paddingReadBehaviour == PaddingReadBehaviour.PADDING_REQUIRED;
    }

    public boolean acceptsPaddingOnRead() {
        return this._paddingReadBehaviour != PaddingReadBehaviour.PADDING_FORBIDDEN;
    }

    public boolean usesPaddingChar(char c2) {
        return c2 == this._paddingChar;
    }

    public boolean usesPaddingChar(int n2) {
        return n2 == this._paddingChar;
    }

    public char getPaddingChar() {
        return this._paddingChar;
    }

    public int getMaxLineLength() {
        return this._maxLineLength;
    }

    public int decodeBase64Char(char c2) {
        char c3 = c2;
        return c3 <= '\u007f' ? this._asciiToBase64[c3] : -1;
    }

    public int decodeBase64Char(int n2) {
        return n2 <= 127 ? this._asciiToBase64[n2] : -1;
    }

    public int encodeBase64Chunk(int n2, char[] cArray, int n3) {
        cArray[n3++] = this._base64ToAsciiC[n2 >> 18 & 0x3F];
        cArray[n3++] = this._base64ToAsciiC[n2 >> 12 & 0x3F];
        cArray[n3++] = this._base64ToAsciiC[n2 >> 6 & 0x3F];
        cArray[n3++] = this._base64ToAsciiC[n2 & 0x3F];
        return n3;
    }

    public void encodeBase64Chunk(StringBuilder stringBuilder, int n2) {
        stringBuilder.append(this._base64ToAsciiC[n2 >> 18 & 0x3F]);
        stringBuilder.append(this._base64ToAsciiC[n2 >> 12 & 0x3F]);
        stringBuilder.append(this._base64ToAsciiC[n2 >> 6 & 0x3F]);
        stringBuilder.append(this._base64ToAsciiC[n2 & 0x3F]);
    }

    public int encodeBase64Partial(int n2, int n3, char[] cArray, int n4) {
        cArray[n4++] = this._base64ToAsciiC[n2 >> 18 & 0x3F];
        cArray[n4++] = this._base64ToAsciiC[n2 >> 12 & 0x3F];
        if (this.usesPadding()) {
            cArray[n4++] = n3 == 2 ? this._base64ToAsciiC[n2 >> 6 & 0x3F] : this._paddingChar;
            cArray[n4++] = this._paddingChar;
        } else if (n3 == 2) {
            cArray[n4++] = this._base64ToAsciiC[n2 >> 6 & 0x3F];
        }
        return n4;
    }

    public void encodeBase64Partial(StringBuilder stringBuilder, int n2, int n3) {
        stringBuilder.append(this._base64ToAsciiC[n2 >> 18 & 0x3F]);
        stringBuilder.append(this._base64ToAsciiC[n2 >> 12 & 0x3F]);
        if (this.usesPadding()) {
            stringBuilder.append(n3 == 2 ? this._base64ToAsciiC[n2 >> 6 & 0x3F] : this._paddingChar);
            stringBuilder.append(this._paddingChar);
        } else if (n3 == 2) {
            stringBuilder.append(this._base64ToAsciiC[n2 >> 6 & 0x3F]);
        }
    }

    public int encodeBase64Chunk(int n2, byte[] byArray, int n3) {
        byArray[n3++] = this._base64ToAsciiB[n2 >> 18 & 0x3F];
        byArray[n3++] = this._base64ToAsciiB[n2 >> 12 & 0x3F];
        byArray[n3++] = this._base64ToAsciiB[n2 >> 6 & 0x3F];
        byArray[n3++] = this._base64ToAsciiB[n2 & 0x3F];
        return n3;
    }

    public int encodeBase64Partial(int n2, int n3, byte[] byArray, int n4) {
        byArray[n4++] = this._base64ToAsciiB[n2 >> 18 & 0x3F];
        byArray[n4++] = this._base64ToAsciiB[n2 >> 12 & 0x3F];
        if (this.usesPadding()) {
            byte by2 = (byte)this._paddingChar;
            byArray[n4++] = n3 == 2 ? this._base64ToAsciiB[n2 >> 6 & 0x3F] : by2;
            byArray[n4++] = by2;
        } else if (n3 == 2) {
            byArray[n4++] = this._base64ToAsciiB[n2 >> 6 & 0x3F];
        }
        return n4;
    }

    public String encode(byte[] byArray) {
        return this.encode(byArray, false);
    }

    public String encode(byte[] byArray, boolean bl2) {
        int n2;
        int n3 = byArray.length;
        StringBuilder stringBuilder = new StringBuilder(n3 + (n3 >> 2) + (n3 >> 3));
        if (bl2) {
            stringBuilder.append('\"');
        }
        int n4 = this.getMaxLineLength() >> 2;
        int n5 = 0;
        int n6 = n3 - 3;
        while (n5 <= n6) {
            n2 = byArray[n5++] << 8;
            n2 |= byArray[n5++] & 0xFF;
            n2 = n2 << 8 | byArray[n5++] & 0xFF;
            this.encodeBase64Chunk(stringBuilder, n2);
            if (--n4 > 0) continue;
            stringBuilder.append('\\');
            stringBuilder.append('n');
            n4 = this.getMaxLineLength() >> 2;
        }
        n2 = n3 - n5;
        if (n2 > 0) {
            int n7 = byArray[n5++] << 16;
            if (n2 == 2) {
                n7 |= (byArray[n5++] & 0xFF) << 8;
            }
            this.encodeBase64Partial(stringBuilder, n7, n2);
        }
        if (bl2) {
            stringBuilder.append('\"');
        }
        return stringBuilder.toString();
    }

    public byte[] decode(String string) throws IllegalArgumentException {
        ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder();
        this.decode(string, byteArrayBuilder);
        return byteArrayBuilder.toByteArray();
    }

    public void decode(String string, ByteArrayBuilder byteArrayBuilder) throws IllegalArgumentException {
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            char c2;
            if ((c2 = string.charAt(n2++)) <= ' ') continue;
            int n4 = this.decodeBase64Char(c2);
            if (n4 < 0) {
                this._reportInvalidBase64(c2, 0, null);
            }
            int n5 = n4;
            if (n2 >= n3) {
                this._reportBase64EOF();
            }
            if ((n4 = this.decodeBase64Char(c2 = string.charAt(n2++))) < 0) {
                this._reportInvalidBase64(c2, 1, null);
            }
            n5 = n5 << 6 | n4;
            if (n2 >= n3) {
                if (!this.requiresPaddingOnRead()) {
                    byteArrayBuilder.append(n5 >>= 4);
                    break;
                }
                this._reportBase64EOF();
            }
            if ((n4 = this.decodeBase64Char(c2 = string.charAt(n2++))) < 0) {
                if (n4 != -2) {
                    this._reportInvalidBase64(c2, 2, null);
                }
                if (!this.acceptsPaddingOnRead()) {
                    this._reportBase64UnexpectedPadding();
                }
                if (n2 >= n3) {
                    this._reportBase64EOF();
                }
                if (!this.usesPaddingChar(c2 = string.charAt(n2++))) {
                    this._reportInvalidBase64(c2, 3, "expected padding character '" + this.getPaddingChar() + "'");
                }
                byteArrayBuilder.append(n5 >>= 4);
                continue;
            }
            n5 = n5 << 6 | n4;
            if (n2 >= n3) {
                if (!this.requiresPaddingOnRead()) {
                    byteArrayBuilder.appendTwoBytes(n5 >>= 2);
                    break;
                }
                this._reportBase64EOF();
            }
            if ((n4 = this.decodeBase64Char(c2 = string.charAt(n2++))) < 0) {
                if (n4 != -2) {
                    this._reportInvalidBase64(c2, 3, null);
                }
                if (!this.acceptsPaddingOnRead()) {
                    this._reportBase64UnexpectedPadding();
                }
                byteArrayBuilder.appendTwoBytes(n5 >>= 2);
                continue;
            }
            n5 = n5 << 6 | n4;
            byteArrayBuilder.appendThreeBytes(n5);
        }
    }

    public String toString() {
        return this._name;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        Base64Variant base64Variant = (Base64Variant)object;
        return base64Variant._paddingChar == this._paddingChar && base64Variant._maxLineLength == this._maxLineLength && base64Variant._writePadding == this._writePadding && base64Variant._paddingReadBehaviour == this._paddingReadBehaviour && this._name.equals(base64Variant._name);
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    protected void _reportInvalidBase64(char c2, int n2, String string) throws IllegalArgumentException {
        String string2 = c2 <= ' ' ? "Illegal white space character (code 0x" + Integer.toHexString(c2) + ") as character #" + (n2 + 1) + " of 4-char base64 unit: can only used between units" : (this.usesPaddingChar(c2) ? "Unexpected padding character ('" + this.getPaddingChar() + "') as character #" + (n2 + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character" : (!Character.isDefined(c2) || Character.isISOControl(c2) ? "Illegal character (code 0x" + Integer.toHexString(c2) + ") in base64 content" : "Illegal character '" + c2 + "' (code 0x" + Integer.toHexString(c2) + ") in base64 content"));
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        throw new IllegalArgumentException(string2);
    }

    protected void _reportBase64EOF() throws IllegalArgumentException {
        throw new IllegalArgumentException(this.missingPaddingMessage());
    }

    protected void _reportBase64UnexpectedPadding() throws IllegalArgumentException {
        throw new IllegalArgumentException(this.unexpectedPaddingMessage());
    }

    protected String unexpectedPaddingMessage() {
        return String.format("Unexpected end of base64-encoded String: base64 variant '%s' expects no padding at the end while decoding. This Base64Variant might have been incorrectly configured", this.getName());
    }

    public String missingPaddingMessage() {
        return String.format("Unexpected end of base64-encoded String: base64 variant '%s' expects padding (one or more '%c' characters) at the end. This Base64Variant might have been incorrectly configured", this.getName(), Character.valueOf(this.getPaddingChar()));
    }

    public static enum PaddingReadBehaviour {
        PADDING_FORBIDDEN,
        PADDING_REQUIRED,
        PADDING_ALLOWED;

    }
}

