/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.obfuscation;

import com.gradle.obfuscation.Keep;
import com.gradle.obfuscation.KeepName;
import com.gradle.obfuscation.KeepNameAndProperties;
import com.gradle.obfuscation.KeepProperties;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class ObfuscationControl {
    public static boolean retainsPropertyNames(Class<?> clazz) {
        return ObfuscationControl.hasRetention(clazz, b.PROPERTIES);
    }

    public static void requireClassName(Class<?> clazz, Supplier<String> supplier) {
        ObfuscationControl.requireRetention(clazz, b.CLASS_NAME, supplier);
    }

    public static void requireClassNameAndProperties(Class<?> clazz, Supplier<String> supplier) {
        ObfuscationControl.requireRetention(clazz, b.CLASS_NAME_AND_PROPERTIES, supplier);
    }

    public static void requireAll(Class<?> clazz, Supplier<String> supplier) {
        ObfuscationControl.requireRetention(clazz, b.ALL, supplier);
    }

    private static void requireRetention(Class<?> clazz, b b2, Supplier<String> supplier) {
        if (!ObfuscationControl.hasRetention(clazz, b2)) {
            throw new IllegalStateException("Class " + clazz.getName() + " requires " + b2.name() + " retention (" + b2.a() + "). Reason: " + supplier.get());
        }
    }

    private static boolean hasRetention(Class<?> clazz, b b2) {
        if (ObfuscationControl.isObfuscatable(clazz)) {
            for (a a2 : b2.a) {
                if (!a2.a(clazz)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static boolean isObfuscatable(Class<?> clazz) {
        return clazz.getName().startsWith("com.gradle.") && !clazz.getName().startsWith("com.gradle.scan.eventmodel");
    }

    private ObfuscationControl() {
    }

    private static final class a {
        final Class<? extends Annotation>[] a;

        @SafeVarargs
        a(Class<? extends Annotation> ... classArray) {
            this.a = classArray;
        }

        boolean a(Class<?> clazz) {
            for (Class<? extends Annotation> clazz2 : this.a) {
                if (clazz.isAnnotationPresent(clazz2)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return Arrays.stream(this.a).map(Class::getSimpleName).map(string -> "@" + string).collect(Collectors.joining(" and "));
        }
    }

    private static enum b {
        ALL(new a(Keep.class)),
        CLASS_NAME(new a(Keep.class), new a(KeepName.class), new a(KeepNameAndProperties.class)),
        CLASS_NAME_AND_PROPERTIES(new a(Keep.class), new a(KeepName.class, KeepProperties.class), new a(KeepNameAndProperties.class)),
        PROPERTIES(new a(Keep.class), new a(KeepProperties.class), new a(KeepNameAndProperties.class));

        private final a[] a;

        private b(a ... aArray) {
            this.a = aArray;
        }

        public String a() {
            return Arrays.stream(this.a).map(Object::toString).collect(Collectors.joining(", or "));
        }
    }
}

