/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin;

import com.gradle.scan.b.a.b;
import com.gradle.scan.plugin.BuildScanException;
import com.gradle.scan.plugin.internal.k;
import com.gradle.scan.plugin.internal.meta.CurrentBuildAgentVersion;
import com.gradle.scan.plugin.internal.o.a;
import com.gradle.scan.plugin.internal.p;
import javax.annotation.Nonnull;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;

public final class BuildScanPlugin
implements Plugin<Object> {
    private static final k a = new k(BuildScanPlugin.class, "build scan");

    public void apply(@Nonnull Object object) {
        b buildDataProducer;
        Gradle gradle;
        Project project;
        if (object instanceof Project) {
            project = (Project)object;
            gradle = project.getGradle();
            buildDataProducer = b.a(gradle.getGradleVersion(), CurrentBuildAgentVersion.get());
            BuildScanPlugin.a(buildDataProducer);
            BuildScanPlugin.b(project);
            BuildScanPlugin.c(project);
            if (BuildScanPlugin.a(project)) {
                return;
            }
        } else {
            throw new BuildScanException("The build scan plugin must be applied to the root project (was applied to " + BuildScanPlugin.pluginApplicationTargetDisplayName(object) + ")");
        }
        com.gradle.scan.plugin.internal.a.a(buildDataProducer, gradle, project.getRootDir(), a, action -> action.execute((Object)project));
    }

    public static String pluginApplicationTargetDisplayName(@Nonnull Object object) {
        if (object instanceof Project) {
            return "a project";
        }
        if (object instanceof Settings) {
            return "settings";
        }
        if (object instanceof Gradle) {
            return "init script";
        }
        return object.getClass().getName();
    }

    private static boolean a(Project project) {
        return project.getPlugins().stream().anyMatch(plugin -> plugin.getClass().getName().equals(BuildScanPlugin.class.getName()));
    }

    private static void b(Project project) {
        if (!project.equals(project.getRootProject())) {
            throw new BuildScanException("The Gradle Enterprise plugin can only be applied to the root project.");
        }
    }

    private static void c(Project rootProject) {
        if (rootProject.getState().getExecuted()) {
            throw new BuildScanException(p.a("The Gradle Enterprise plugin must be applied early in the build lifecycle.", "Fixing this problem requires changing how you are applying the Gradle Enterprise plugin to your build.", "", "Please see https://gradle.com/scans/help/plugin-late-apply for how to resolve this problem."));
        }
    }

    private static void a(b buildDataProducer) {
        if (buildDataProducer.a(com.gradle.scan.plugin.internal.o.a.m)) {
            throw new BuildScanException(p.a("This build scan plugin is not compatible with less than Gradle 6.0.", "Please use the Gradle Enterprise plugin instead."));
        }
        if (!buildDataProducer.a(com.gradle.scan.plugin.internal.o.a.c)) {
            if (buildDataProducer.a(com.gradle.scan.plugin.internal.o.a.a)) {
                throw new BuildScanException(p.a("This version of the build scan plugin is not compatible with less than Gradle 5.0.", "Please use version 1.16 of the build scan plugin."));
            }
            throw new BuildScanException(p.a("Build scans are not supported for Gradle 1.x.", "Please use a newer version of Gradle."));
        }
    }
}

