/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.driver.windows;

import com.gradle.scan.plugin.internal.dep.oshi.driver.windows.wmi.Win32Processor;
import com.gradle.scan.plugin.internal.dep.oshi.hardware.CentralProcessor;
import com.gradle.scan.plugin.internal.dep.oshi.hardware.common.AbstractCentralProcessor;
import com.gradle.scan.plugin.internal.dep.oshi.util.platform.windows.WmiUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.tuples.Triplet;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.VersionHelpers;
import com.sun.jna.platform.win32.WinNT;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class LogicalProcessorInformation {
    private static final boolean IS_WIN10_OR_GREATER = VersionHelpers.IsWindows10OrGreater();

    public static Triplet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, List<CentralProcessor.ProcessorCache>> getLogicalProcessorInformationEx() {
        List<CentralProcessor.PhysicalProcessor> list;
        Object object;
        WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX[] sYSTEM_LOGICAL_PROCESSOR_INFORMATION_EXArray = Kernel32Util.getLogicalProcessorInformationEx(65535);
        ArrayList<WinNT.GROUP_AFFINITY[]> arrayList = new ArrayList<WinNT.GROUP_AFFINITY[]>();
        HashSet<CentralProcessor.ProcessorCache> hashSet = new HashSet<CentralProcessor.ProcessorCache>();
        ArrayList<WinNT.GROUP_AFFINITY> arrayList2 = new ArrayList<WinNT.GROUP_AFFINITY>();
        ArrayList<WinNT.NUMA_NODE_RELATIONSHIP> arrayList3 = new ArrayList<WinNT.NUMA_NODE_RELATIONSHIP>();
        HashMap<WinNT.GROUP_AFFINITY, Integer> hashMap = new HashMap<WinNT.GROUP_AFFINITY, Integer>();
        block6: for (WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX object22 : sYSTEM_LOGICAL_PROCESSOR_INFORMATION_EXArray) {
            switch (object22.relationship) {
                case 3: {
                    arrayList.add(((WinNT.PROCESSOR_RELATIONSHIP)object22).groupMask);
                    continue block6;
                }
                case 2: {
                    object = (WinNT.CACHE_RELATIONSHIP)object22;
                    hashSet.add(new CentralProcessor.ProcessorCache(((WinNT.CACHE_RELATIONSHIP)object).level, ((WinNT.CACHE_RELATIONSHIP)object).associativity, ((WinNT.CACHE_RELATIONSHIP)object).lineSize, ((WinNT.CACHE_RELATIONSHIP)object).cacheSize, CentralProcessor.ProcessorCache.Type.values()[((WinNT.CACHE_RELATIONSHIP)object).type]));
                    continue block6;
                }
                case 0: {
                    list = (WinNT.PROCESSOR_RELATIONSHIP)object22;
                    arrayList2.add(((WinNT.PROCESSOR_RELATIONSHIP)((Object)list)).groupMask[0]);
                    if (!IS_WIN10_OR_GREATER) continue block6;
                    hashMap.put(((WinNT.PROCESSOR_RELATIONSHIP)((Object)list)).groupMask[0], Integer.valueOf(((WinNT.PROCESSOR_RELATIONSHIP)((Object)list)).efficiencyClass));
                    continue block6;
                }
                case 1: {
                    arrayList3.add((WinNT.NUMA_NODE_RELATIONSHIP)object22);
                    continue block6;
                }
            }
        }
        arrayList2.sort(Comparator.comparing(gROUP_AFFINITY -> (long)gROUP_AFFINITY.group * 64L + (long)Long.numberOfTrailingZeros(gROUP_AFFINITY.mask.longValue())));
        arrayList.sort(Comparator.comparing(gROUP_AFFINITYArray -> (long)gROUP_AFFINITYArray[0].group * 64L + (long)Long.numberOfTrailingZeros(gROUP_AFFINITYArray[0].mask.longValue())));
        arrayList3.sort(Comparator.comparing(nUMA_NODE_RELATIONSHIP -> nUMA_NODE_RELATIONSHIP.nodeNumber));
        HashMap hashMap2 = new HashMap();
        WbemcliUtil.WmiResult<Win32Processor.ProcessorIdProperty> wmiResult = Win32Processor.queryProcessorId();
        for (int i2 = 0; i2 < wmiResult.getResultCount(); ++i2) {
            hashMap2.put(i2, WmiUtil.getString(wmiResult, Win32Processor.ProcessorIdProperty.PROCESSORID, i2));
        }
        ArrayList<CentralProcessor.LogicalProcessor> arrayList4 = new ArrayList<CentralProcessor.LogicalProcessor>();
        HashMap<Integer, Integer> hashMap3 = new HashMap<Integer, Integer>();
        object = new HashMap();
        for (WinNT.NUMA_NODE_RELATIONSHIP nUMA_NODE_RELATIONSHIP2 : arrayList3) {
            int n2 = nUMA_NODE_RELATIONSHIP2.nodeNumber;
            short s2 = nUMA_NODE_RELATIONSHIP2.groupMask.group;
            long l2 = nUMA_NODE_RELATIONSHIP2.groupMask.mask.longValue();
            int n3 = Long.numberOfTrailingZeros(l2);
            int n4 = 63 - Long.numberOfLeadingZeros(l2);
            for (int i2 = n3; i2 <= n4; ++i2) {
                if ((l2 & 1L << i2) == 0L) continue;
                int n5 = LogicalProcessorInformation.getMatchingCore(arrayList2, s2, i2);
                int n6 = LogicalProcessorInformation.getMatchingPackage(arrayList, s2, i2);
                hashMap3.put(n5, n6);
                object.put(n5, hashMap2.getOrDefault(n6, ""));
                CentralProcessor.LogicalProcessor logicalProcessor = new CentralProcessor.LogicalProcessor(i2, n5, n6, n2, s2);
                arrayList4.add(logicalProcessor);
            }
        }
        list = LogicalProcessorInformation.getPhysProcs(arrayList2, hashMap, hashMap3, (Map<Integer, String>)object);
        return new Triplet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, List<CentralProcessor.ProcessorCache>>(arrayList4, list, AbstractCentralProcessor.orderedProcCaches(hashSet));
    }

    private static List<CentralProcessor.PhysicalProcessor> getPhysProcs(List<WinNT.GROUP_AFFINITY> list, Map<WinNT.GROUP_AFFINITY, Integer> map, Map<Integer, Integer> map2, Map<Integer, String> map3) {
        ArrayList<CentralProcessor.PhysicalProcessor> arrayList = new ArrayList<CentralProcessor.PhysicalProcessor>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            int n2 = map.getOrDefault(list.get(i2), 0);
            String string = map3.getOrDefault(i2, "");
            int n3 = map2.getOrDefault(i2, 0);
            arrayList.add(new CentralProcessor.PhysicalProcessor(n3, i2, n2, string));
        }
        return arrayList;
    }

    private static int getMatchingPackage(List<WinNT.GROUP_AFFINITY[]> list, int n2, int n3) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            for (int i3 = 0; i3 < list.get(i2).length; ++i3) {
                if ((list.get((int)i2)[i3].mask.longValue() & 1L << n3) == 0L || list.get((int)i2)[i3].group != n2) continue;
                return i2;
            }
        }
        return 0;
    }

    private static int getMatchingCore(List<WinNT.GROUP_AFFINITY> list, int n2, int n3) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if ((list.get((int)i2).mask.longValue() & 1L << n3) == 0L || list.get((int)i2).group != n2) continue;
            return i2;
        }
        return 0;
    }

    public static Triplet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, List<CentralProcessor.ProcessorCache>> getLogicalProcessorInformation() {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION[] sYSTEM_LOGICAL_PROCESSOR_INFORMATIONArray = Kernel32Util.getLogicalProcessorInformation();
        for (WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION sYSTEM_LOGICAL_PROCESSOR_INFORMATION : sYSTEM_LOGICAL_PROCESSOR_INFORMATIONArray) {
            if (sYSTEM_LOGICAL_PROCESSOR_INFORMATION.relationship == 3) {
                arrayList.add(sYSTEM_LOGICAL_PROCESSOR_INFORMATION.processorMask.longValue());
                continue;
            }
            if (sYSTEM_LOGICAL_PROCESSOR_INFORMATION.relationship != 0) continue;
            arrayList2.add(sYSTEM_LOGICAL_PROCESSOR_INFORMATION.processorMask.longValue());
        }
        arrayList2.sort(null);
        arrayList.sort(null);
        ArrayList arrayList3 = new ArrayList();
        for (int i2 = 0; i2 < arrayList2.size(); ++i2) {
            long l2 = (Long)arrayList2.get(i2);
            int n2 = Long.numberOfTrailingZeros(l2);
            int n3 = 63 - Long.numberOfLeadingZeros(l2);
            for (int i3 = n2; i3 <= n3; ++i3) {
                if ((l2 & 1L << i3) == 0L) continue;
                CentralProcessor.LogicalProcessor logicalProcessor = new CentralProcessor.LogicalProcessor(i3, i2, LogicalProcessorInformation.getBitMatchingPackageNumber(arrayList, i3));
                arrayList3.add(logicalProcessor);
            }
        }
        return new Triplet<WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION[], Object, Object>((WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION[])arrayList3, null, null);
    }

    private static int getBitMatchingPackageNumber(List<Long> list, int n2) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if ((list.get(i2) & 1L << n2) == 0L) continue;
            return i2;
        }
        return 0;
    }
}

