/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm;

import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.AnnotationVisitor;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.AnnotationWriter;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.Attribute;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.ByteVector;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.ClassVisitor;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.FieldVisitor;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.FieldWriter;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.MethodVisitor;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.MethodWriter;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.ModuleVisitor;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.ModuleWriter;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.RecordComponentVisitor;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.RecordComponentWriter;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.Symbol;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.SymbolTable;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.TypePath;

public class ClassWriter
extends ClassVisitor {
    private int version;
    private final SymbolTable symbolTable;
    private int accessFlags;
    private int thisClass;
    private int superClass;
    private int interfaceCount;
    private int[] interfaces;
    private FieldWriter firstField;
    private FieldWriter lastField;
    private MethodWriter firstMethod;
    private MethodWriter lastMethod;
    private int numberOfInnerClasses;
    private ByteVector innerClasses;
    private int enclosingClassIndex;
    private int enclosingMethodIndex;
    private int signatureIndex;
    private int sourceFileIndex;
    private ByteVector debugExtension;
    private AnnotationWriter lastRuntimeVisibleAnnotation;
    private AnnotationWriter lastRuntimeInvisibleAnnotation;
    private AnnotationWriter lastRuntimeVisibleTypeAnnotation;
    private AnnotationWriter lastRuntimeInvisibleTypeAnnotation;
    private ModuleWriter moduleWriter;
    private int nestHostClassIndex;
    private int numberOfNestMemberClasses;
    private ByteVector nestMemberClasses;
    private int numberOfPermittedSubclasses;
    private ByteVector permittedSubclasses;
    private RecordComponentWriter firstRecordComponent;
    private RecordComponentWriter lastRecordComponent;
    private Attribute firstAttribute;
    private int compute;

    public final void visit(int n2, int n3, String string, String string2, String string3, String[] stringArray) {
        this.version = n2;
        this.accessFlags = n3;
        this.thisClass = this.symbolTable.setMajorVersionAndClassName(n2 & 0xFFFF, string);
        if (string2 != null) {
            this.signatureIndex = this.symbolTable.addConstantUtf8(string2);
        }
        int n4 = this.superClass = string3 == null ? 0 : this.symbolTable.addConstantClass((String)string3).index;
        if (stringArray != null && stringArray.length > 0) {
            this.interfaceCount = stringArray.length;
            this.interfaces = new int[this.interfaceCount];
            for (int i2 = 0; i2 < this.interfaceCount; ++i2) {
                this.interfaces[i2] = this.symbolTable.addConstantClass((String)stringArray[i2]).index;
            }
        }
        if (this.compute == 1 && (n2 & 0xFFFF) >= 51) {
            this.compute = 2;
        }
    }

    public final void visitSource(String string, String string2) {
        if (string != null) {
            this.sourceFileIndex = this.symbolTable.addConstantUtf8(string);
        }
        if (string2 != null) {
            this.debugExtension = new ByteVector().encodeUtf8(string2, 0, Integer.MAX_VALUE);
        }
    }

    public final ModuleVisitor visitModule(String string, int n2, String string2) {
        this.moduleWriter = new ModuleWriter(this.symbolTable, this.symbolTable.addConstantModule((String)string).index, n2, string2 == null ? 0 : this.symbolTable.addConstantUtf8(string2));
        return this.moduleWriter;
    }

    public final void visitNestHost(String string) {
        this.nestHostClassIndex = this.symbolTable.addConstantClass((String)string).index;
    }

    public final void visitOuterClass(String string, String string2, String string3) {
        this.enclosingClassIndex = this.symbolTable.addConstantClass((String)string).index;
        if (string2 != null && string3 != null) {
            this.enclosingMethodIndex = this.symbolTable.addConstantNameAndType(string2, string3);
        }
    }

    public final AnnotationVisitor visitAnnotation(String string, boolean bl2) {
        if (bl2) {
            this.lastRuntimeVisibleAnnotation = AnnotationWriter.create(this.symbolTable, string, this.lastRuntimeVisibleAnnotation);
            return this.lastRuntimeVisibleAnnotation;
        }
        this.lastRuntimeInvisibleAnnotation = AnnotationWriter.create(this.symbolTable, string, this.lastRuntimeInvisibleAnnotation);
        return this.lastRuntimeInvisibleAnnotation;
    }

    public final AnnotationVisitor visitTypeAnnotation(int n2, TypePath typePath, String string, boolean bl2) {
        if (bl2) {
            this.lastRuntimeVisibleTypeAnnotation = AnnotationWriter.create(this.symbolTable, n2, typePath, string, this.lastRuntimeVisibleTypeAnnotation);
            return this.lastRuntimeVisibleTypeAnnotation;
        }
        this.lastRuntimeInvisibleTypeAnnotation = AnnotationWriter.create(this.symbolTable, n2, typePath, string, this.lastRuntimeInvisibleTypeAnnotation);
        return this.lastRuntimeInvisibleTypeAnnotation;
    }

    public final void visitAttribute(Attribute attribute) {
        attribute.nextAttribute = this.firstAttribute;
        this.firstAttribute = attribute;
    }

    public final void visitNestMember(String string) {
        if (this.nestMemberClasses == null) {
            this.nestMemberClasses = new ByteVector();
        }
        ++this.numberOfNestMemberClasses;
        this.nestMemberClasses.putShort(this.symbolTable.addConstantClass((String)string).index);
    }

    public final void visitPermittedSubclass(String string) {
        if (this.permittedSubclasses == null) {
            this.permittedSubclasses = new ByteVector();
        }
        ++this.numberOfPermittedSubclasses;
        this.permittedSubclasses.putShort(this.symbolTable.addConstantClass((String)string).index);
    }

    public final void visitInnerClass(String string, String string2, String string3, int n2) {
        if (this.innerClasses == null) {
            this.innerClasses = new ByteVector();
        }
        Symbol symbol = this.symbolTable.addConstantClass(string);
        if (symbol.info == 0) {
            ++this.numberOfInnerClasses;
            this.innerClasses.putShort(symbol.index);
            this.innerClasses.putShort(string2 == null ? 0 : this.symbolTable.addConstantClass((String)string2).index);
            this.innerClasses.putShort(string3 == null ? 0 : this.symbolTable.addConstantUtf8(string3));
            this.innerClasses.putShort(n2);
            symbol.info = this.numberOfInnerClasses;
        }
    }

    public final RecordComponentVisitor visitRecordComponent(String string, String string2, String string3) {
        RecordComponentWriter recordComponentWriter = new RecordComponentWriter(this.symbolTable, string, string2, string3);
        if (this.firstRecordComponent == null) {
            this.firstRecordComponent = recordComponentWriter;
        } else {
            this.lastRecordComponent.delegate = recordComponentWriter;
        }
        this.lastRecordComponent = recordComponentWriter;
        return this.lastRecordComponent;
    }

    public final FieldVisitor visitField(int n2, String string, String string2, String string3, Object object) {
        FieldWriter fieldWriter = new FieldWriter(this.symbolTable, n2, string, string2, string3, object);
        if (this.firstField == null) {
            this.firstField = fieldWriter;
        } else {
            this.lastField.fv = fieldWriter;
        }
        this.lastField = fieldWriter;
        return this.lastField;
    }

    public final MethodVisitor visitMethod(int n2, String string, String string2, String string3, String[] stringArray) {
        MethodWriter methodWriter = new MethodWriter(this.symbolTable, n2, string, string2, string3, stringArray, this.compute);
        if (this.firstMethod == null) {
            this.firstMethod = methodWriter;
        } else {
            this.lastMethod.mv = methodWriter;
        }
        this.lastMethod = methodWriter;
        return this.lastMethod;
    }

    public final void visitEnd() {
    }

    protected String getCommonSuperClass(String string, String string2) {
        Class<?> clazz;
        Class<?> clazz2;
        ClassLoader classLoader = this.getClassLoader();
        try {
            clazz2 = Class.forName(string.replace('/', '.'), false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TypeNotPresentException(string, classNotFoundException);
        }
        try {
            clazz = Class.forName(string2.replace('/', '.'), false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TypeNotPresentException(string2, classNotFoundException);
        }
        if (clazz2.isAssignableFrom(clazz)) {
            return string;
        }
        if (clazz.isAssignableFrom(clazz2)) {
            return string2;
        }
        if (clazz2.isInterface() || clazz.isInterface()) {
            return "java/lang/Object";
        }
        while (!(clazz2 = clazz2.getSuperclass()).isAssignableFrom(clazz)) {
        }
        return clazz2.getName().replace('.', '/');
    }

    protected ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }
}

