/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl;

import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.EmptyArrays;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

final class OpenSslX509TrustManagerWrapper {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(OpenSslX509TrustManagerWrapper.class);
    private static final TrustManagerWrapper WRAPPER;
    private static final TrustManagerWrapper DEFAULT;

    private OpenSslX509TrustManagerWrapper() {
    }

    static X509TrustManager wrapIfNeeded(X509TrustManager x509TrustManager) {
        return WRAPPER.wrapIfNeeded(x509TrustManager);
    }

    private static SSLContext newSSLContext() throws NoSuchAlgorithmException, NoSuchProviderException {
        return SSLContext.getInstance("TLS", "SunJSSE");
    }

    static {
        TrustManagerWrapper trustManagerWrapper = DEFAULT = new TrustManagerWrapper(){

            @Override
            public X509TrustManager wrapIfNeeded(X509TrustManager x509TrustManager) {
                return x509TrustManager;
            }
        };
        Throwable throwable = null;
        Throwable throwable2 = PlatformDependent.getUnsafeUnavailabilityCause();
        if (throwable2 == null) {
            SSLContext sSLContext;
            try {
                sSLContext = OpenSslX509TrustManagerWrapper.newSSLContext();
                sSLContext.init(null, new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                        throw new CertificateException();
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                        throw new CertificateException();
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return EmptyArrays.EMPTY_X509_CERTIFICATES;
                    }
                }}, null);
            }
            catch (Throwable throwable3) {
                sSLContext = null;
                throwable = throwable3;
            }
            if (throwable != null) {
                LOGGER.debug("Unable to access wrapped TrustManager", throwable);
            } else {
                final SSLContext sSLContext2 = sSLContext;
                Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            Field field = SSLContext.class.getDeclaredField("contextSpi");
                            long l2 = PlatformDependent.objectFieldOffset(field);
                            Object object = PlatformDependent.getObject(sSLContext2, l2);
                            if (object != null) {
                                Class<?> clazz = object.getClass();
                                do {
                                    try {
                                        Field field2 = clazz.getDeclaredField("trustManager");
                                        long l3 = PlatformDependent.objectFieldOffset(field2);
                                        Object object2 = PlatformDependent.getObject(object, l3);
                                        if (object2 instanceof X509ExtendedTrustManager) {
                                            return new UnsafeTrustManagerWrapper(l2, l3);
                                        }
                                    }
                                    catch (NoSuchFieldException noSuchFieldException) {
                                        // empty catch block
                                    }
                                } while ((clazz = clazz.getSuperclass()) != null);
                            }
                            throw new NoSuchFieldException();
                        }
                        catch (NoSuchFieldException | SecurityException exception) {
                            return exception;
                        }
                    }
                });
                if (object instanceof Throwable) {
                    LOGGER.debug("Unable to access wrapped TrustManager", (Throwable)object);
                } else {
                    trustManagerWrapper = (TrustManagerWrapper)object;
                }
            }
        } else {
            LOGGER.debug("Unable to access wrapped TrustManager", throwable);
        }
        WRAPPER = trustManagerWrapper;
    }

    private static final class UnsafeTrustManagerWrapper
    implements TrustManagerWrapper {
        private final long spiOffset;
        private final long tmOffset;

        UnsafeTrustManagerWrapper(long l2, long l3) {
            this.spiOffset = l2;
            this.tmOffset = l3;
        }

        @Override
        public X509TrustManager wrapIfNeeded(X509TrustManager x509TrustManager) {
            if (!(x509TrustManager instanceof X509ExtendedTrustManager)) {
                try {
                    Object object;
                    SSLContext sSLContext = OpenSslX509TrustManagerWrapper.newSSLContext();
                    sSLContext.init(null, new TrustManager[]{x509TrustManager}, null);
                    Object object2 = PlatformDependent.getObject(sSLContext, this.spiOffset);
                    if (object2 != null && (object = PlatformDependent.getObject(object2, this.tmOffset)) instanceof X509ExtendedTrustManager) {
                        return (X509TrustManager)object;
                    }
                }
                catch (KeyManagementException | NoSuchAlgorithmException | NoSuchProviderException generalSecurityException) {
                    PlatformDependent.throwException(generalSecurityException);
                }
            }
            return x509TrustManager;
        }
    }

    private static interface TrustManagerWrapper {
        public X509TrustManager wrapIfNeeded(X509TrustManager var1);
    }
}

