/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.channel.embedded;

import com.gradle.scan.plugin.internal.dep.io.netty.channel.Channel;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelFuture;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelPromise;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.DefaultChannelPromise;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.EventLoop;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.AbstractScheduledEventExecutor;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.Future;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.MockTicker;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.Ticker;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

final class EmbeddedEventLoop
extends AbstractScheduledEventExecutor
implements EventLoop {
    private final Ticker ticker;
    private final Queue<Runnable> tasks = new ArrayDeque<Runnable>(2);

    EmbeddedEventLoop(Ticker ticker) {
        this.ticker = ticker;
    }

    @Override
    public EventLoop next() {
        return (EventLoop)super.next();
    }

    @Override
    public void execute(Runnable runnable) {
        this.tasks.add(ObjectUtil.checkNotNull(runnable, "command"));
    }

    void runTasks() {
        Runnable runnable;
        while ((runnable = this.tasks.poll()) != null) {
            runnable.run();
        }
    }

    long runScheduledTasks() {
        long l2 = this.getCurrentTimeNanos();
        Runnable runnable;
        while ((runnable = this.pollScheduledTask(l2)) != null) {
            runnable.run();
        }
        return this.nextScheduledTaskNano();
    }

    @Override
    public Ticker ticker() {
        return this.ticker;
    }

    @Override
    protected long getCurrentTimeNanos() {
        return this.ticker.nanoTime();
    }

    @Override
    protected void cancelScheduledTasks() {
        super.cancelScheduledTasks();
    }

    @Override
    public Future<?> shutdownGracefully(long l2, long l3, TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<?> terminationFuture() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShuttingDown() {
        return false;
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long l2, TimeUnit timeUnit) {
        return false;
    }

    @Override
    public ChannelFuture register(Channel channel) {
        return this.register(new DefaultChannelPromise(channel, this));
    }

    public ChannelFuture register(ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull(channelPromise, "promise");
        channelPromise.channel().unsafe().register(this, channelPromise);
        return channelPromise;
    }

    @Override
    public boolean inEventLoop() {
        return true;
    }

    @Override
    public boolean inEventLoop(Thread thread) {
        return true;
    }

    static final class FreezableTicker
    implements MockTicker {
        private final Ticker unfrozen = Ticker.systemTicker();
        private long startTime;
        private long frozenTimestamp;
        private boolean timeFrozen;

        FreezableTicker() {
        }

        @Override
        public long nanoTime() {
            if (this.timeFrozen) {
                return this.frozenTimestamp;
            }
            return this.unfrozen.nanoTime() - this.startTime;
        }
    }
}

