/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jdk8;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.BeanDescription;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.MapperFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.SerializationConfig;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser.Serializers;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.type.ReferenceType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.type.TypeFactory;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jdk8.DoubleStreamSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jdk8.IntStreamSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jdk8.LongStreamSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jdk8.OptionalDoubleSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jdk8.OptionalIntSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jdk8.OptionalLongSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jdk8.OptionalSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jdk8.StreamSerializer;
import java.io.Serializable;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class Jdk8Serializers
extends Serializers.Base
implements Serializable {
    @Override
    public JsonSerializer<?> findReferenceSerializer(SerializationConfig serializationConfig, ReferenceType referenceType, BeanDescription beanDescription, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) {
        Class<?> clazz = referenceType.getRawClass();
        if (Optional.class.isAssignableFrom(clazz)) {
            boolean bl2 = typeSerializer == null && serializationConfig.isEnabled(MapperFeature.USE_STATIC_TYPING);
            return new OptionalSerializer(referenceType, bl2, typeSerializer, jsonSerializer);
        }
        if (OptionalInt.class.isAssignableFrom(clazz)) {
            return OptionalIntSerializer.INSTANCE;
        }
        if (OptionalLong.class.isAssignableFrom(clazz)) {
            return OptionalLongSerializer.INSTANCE;
        }
        if (OptionalDouble.class.isAssignableFrom(clazz)) {
            return OptionalDoubleSerializer.INSTANCE;
        }
        return null;
    }

    @Override
    public JsonSerializer<?> findSerializer(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription) {
        Class<?> clazz = javaType.getRawClass();
        if (LongStream.class.isAssignableFrom(clazz)) {
            return LongStreamSerializer.INSTANCE;
        }
        if (IntStream.class.isAssignableFrom(clazz)) {
            return IntStreamSerializer.INSTANCE;
        }
        if (DoubleStream.class.isAssignableFrom(clazz)) {
            return DoubleStreamSerializer.INSTANCE;
        }
        if (Stream.class.isAssignableFrom(clazz)) {
            JavaType[] javaTypeArray = serializationConfig.getTypeFactory().findTypeParameters(javaType, Stream.class);
            JavaType javaType2 = javaTypeArray == null || javaTypeArray.length != 1 ? TypeFactory.unknownType() : javaTypeArray[0];
            return new StreamSerializer(serializationConfig.getTypeFactory().constructParametricType(Stream.class, javaType2), javaType2);
        }
        return null;
    }
}

