/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.SerializableString;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.EnumNamingStrategy;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.EnumFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;

public final class EnumValues
implements Serializable {
    private final Class<Enum<?>> _enumClass;
    private final Enum<?>[] _values;
    private final SerializableString[] _textual;

    private EnumValues(Class<Enum<?>> clazz, SerializableString[] serializableStringArray) {
        this._enumClass = clazz;
        this._values = clazz.getEnumConstants();
        this._textual = serializableStringArray;
    }

    public static EnumValues constructFromName(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass) {
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        boolean bl2 = mapperConfig.isEnabled(EnumFeature.WRITE_ENUMS_TO_LOWERCASE);
        Class<?> clazz = annotatedClass.getRawType();
        Class<Enum<?>> clazz2 = EnumValues._enumClass(clazz);
        Enum<?>[] enumArray = EnumValues._enumConstants(clazz);
        String[] stringArray = annotationIntrospector.findEnumValues(mapperConfig, annotatedClass, enumArray, new String[enumArray.length]);
        SerializableString[] serializableStringArray = new SerializableString[enumArray.length];
        int n2 = enumArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Enum<?> enum_ = enumArray[i2];
            String string = EnumValues._findNameToUse(stringArray[i2], enum_.name(), bl2);
            serializableStringArray[enum_.ordinal()] = mapperConfig.compileString(string);
        }
        return EnumValues.construct(clazz2, serializableStringArray);
    }

    public static EnumValues constructFromToString(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass) {
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        boolean bl2 = mapperConfig.isEnabled(EnumFeature.WRITE_ENUMS_TO_LOWERCASE);
        Class<?> clazz = annotatedClass.getRawType();
        Class<Enum<?>> clazz2 = EnumValues._enumClass(clazz);
        Enum<?>[] enumArray = EnumValues._enumConstants(clazz);
        String[] stringArray = new String[enumArray.length];
        if (annotationIntrospector != null) {
            annotationIntrospector.findEnumValues(mapperConfig, annotatedClass, enumArray, stringArray);
        }
        SerializableString[] serializableStringArray = new SerializableString[enumArray.length];
        for (int i2 = 0; i2 < enumArray.length; ++i2) {
            String string = enumArray[i2].toString();
            string = string == null ? "" : string;
            String string2 = EnumValues._findNameToUse(stringArray[i2], string, bl2);
            serializableStringArray[i2] = mapperConfig.compileString(string2);
        }
        return EnumValues.construct(clazz2, serializableStringArray);
    }

    public static EnumValues constructUsingEnumNamingStrategy(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, EnumNamingStrategy enumNamingStrategy) {
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        boolean bl2 = mapperConfig.isEnabled(EnumFeature.WRITE_ENUMS_TO_LOWERCASE);
        Class<?> clazz = annotatedClass.getRawType();
        Class<Enum<?>> clazz2 = EnumValues._enumClass(clazz);
        Enum<?>[] enumArray = EnumValues._enumConstants(clazz);
        String[] stringArray = new String[enumArray.length];
        if (annotationIntrospector != null) {
            annotationIntrospector.findEnumValues(mapperConfig, annotatedClass, enumArray, stringArray);
        }
        SerializableString[] serializableStringArray = new SerializableString[enumArray.length];
        int n2 = enumArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Enum<?> enum_ = enumArray[i2];
            String string = EnumValues._findNameToUse(stringArray[i2], enumNamingStrategy.convertEnumToExternalName(enum_.name()), bl2);
            serializableStringArray[i2] = mapperConfig.compileString(string);
        }
        return EnumValues.construct(clazz2, serializableStringArray);
    }

    public static EnumValues construct(Class<Enum<?>> clazz, SerializableString[] serializableStringArray) {
        return new EnumValues(clazz, serializableStringArray);
    }

    protected static Class<Enum<?>> _enumClass(Class<?> clazz) {
        return clazz;
    }

    protected static Enum<?>[] _enumConstants(Class<?> clazz) {
        Enum<?>[] enumArray = ClassUtil.findEnumType(clazz).getEnumConstants();
        if (enumArray == null) {
            throw new IllegalArgumentException("No enum constants for class " + clazz.getName());
        }
        return enumArray;
    }

    protected static String _findNameToUse(String string, String string2, boolean bl2) {
        if (string != null) {
            return string;
        }
        if (bl2) {
            return string2.toLowerCase();
        }
        return string2;
    }

    public SerializableString serializedValueFor(Enum<?> enum_) {
        return this._textual[enum_.ordinal()];
    }

    public Collection<SerializableString> values() {
        return Arrays.asList(this._textual);
    }

    public Class<Enum<?>> getEnumClass() {
        return this._enumClass;
    }
}

