/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.software.os.unix.solaris;

import com.gradle.scan.plugin.internal.dep.oshi.driver.unix.solaris.PsInfo;
import com.gradle.scan.plugin.internal.dep.oshi.jna.platform.unix.SolarisLibc;
import com.gradle.scan.plugin.internal.dep.oshi.software.common.AbstractOSProcess;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.OSProcess;
import com.gradle.scan.plugin.internal.dep.oshi.software.os.unix.solaris.SolarisOperatingSystem;
import com.gradle.scan.plugin.internal.dep.oshi.util.ExecutingCommand;
import com.gradle.scan.plugin.internal.dep.oshi.util.Memoizer;
import com.gradle.scan.plugin.internal.dep.oshi.util.ParseUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.UserGroupInfo;
import com.gradle.scan.plugin.internal.dep.oshi.util.tuples.Pair;
import com.sun.jna.Native;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolarisOSProcess
extends AbstractOSProcess {
    private static final Logger LOG = LoggerFactory.getLogger(SolarisOSProcess.class);
    private final SolarisOperatingSystem os;
    private Supplier<Integer> bitness = Memoizer.memoize(this::queryBitness);
    private Supplier<SolarisLibc.SolarisPsInfo> psinfo = Memoizer.memoize(this::queryPsInfo, Memoizer.defaultExpiration());
    private Supplier<String> commandLine = Memoizer.memoize(this::queryCommandLine);
    private Supplier<Pair<List<String>, Map<String, String>>> cmdEnv = Memoizer.memoize(this::queryCommandlineEnvironment);
    private Supplier<SolarisLibc.SolarisPrUsage> prusage = Memoizer.memoize(this::queryPrUsage, Memoizer.defaultExpiration());
    private String name;
    private String path = "";
    private String commandLineBackup;
    private String user;
    private String userID;
    private String group;
    private String groupID;
    private OSProcess.State state = OSProcess.State.INVALID;
    private int parentProcessID;
    private int threadCount;
    private int priority;
    private long virtualSize;
    private long residentSetSize;
    private long kernelTime;
    private long userTime;
    private long startTime;
    private long upTime;
    private long bytesRead;
    private long minorFaults;
    private long majorFaults;
    private long contextSwitches = 0L;

    public SolarisOSProcess(int n2, SolarisOperatingSystem solarisOperatingSystem) {
        super(n2);
        this.os = solarisOperatingSystem;
        this.updateAttributes();
    }

    private SolarisLibc.SolarisPsInfo queryPsInfo() {
        return PsInfo.queryPsInfo(this.getProcessID());
    }

    private SolarisLibc.SolarisPrUsage queryPrUsage() {
        return PsInfo.queryPrUsage(this.getProcessID());
    }

    @Override
    public String getName() {
        return this.name;
    }

    private String queryCommandLine() {
        String string = String.join((CharSequence)" ", this.getArguments());
        return string.isEmpty() ? this.commandLineBackup : string;
    }

    @Override
    public List<String> getArguments() {
        return this.cmdEnv.get().getA();
    }

    private Pair<List<String>, Map<String, String>> queryCommandlineEnvironment() {
        return PsInfo.queryArgsEnv(this.getProcessID(), this.psinfo.get());
    }

    @Override
    public OSProcess.State getState() {
        return this.state;
    }

    @Override
    public int getParentProcessID() {
        return this.parentProcessID;
    }

    @Override
    public long getResidentSetSize() {
        return this.residentSetSize;
    }

    @Override
    public long getKernelTime() {
        return this.kernelTime;
    }

    @Override
    public long getUserTime() {
        return this.userTime;
    }

    @Override
    public long getUpTime() {
        return this.upTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public int getBitness() {
        return this.bitness.get();
    }

    private int queryBitness() {
        List<String> list = ExecutingCommand.runNative("pflags " + this.getProcessID());
        for (String string : list) {
            if (!string.contains("data model")) continue;
            if (string.contains("LP32")) {
                return 32;
            }
            if (!string.contains("LP64")) continue;
            return 64;
        }
        return 0;
    }

    public boolean updateAttributes() {
        SolarisLibc.SolarisPsInfo solarisPsInfo = this.psinfo.get();
        if (solarisPsInfo == null) {
            this.state = OSProcess.State.INVALID;
            return false;
        }
        SolarisLibc.SolarisPrUsage solarisPrUsage = this.prusage.get();
        long l2 = System.currentTimeMillis();
        this.state = SolarisOSProcess.getStateFromOutput((char)solarisPsInfo.pr_lwp.pr_sname);
        this.parentProcessID = solarisPsInfo.pr_ppid;
        this.userID = Integer.toString(solarisPsInfo.pr_euid);
        this.user = UserGroupInfo.getUser(this.userID);
        this.groupID = Integer.toString(solarisPsInfo.pr_egid);
        this.group = UserGroupInfo.getGroupName(this.groupID);
        this.threadCount = solarisPsInfo.pr_nlwp;
        this.priority = solarisPsInfo.pr_lwp.pr_pri;
        this.virtualSize = solarisPsInfo.pr_size.longValue() * 1024L;
        this.residentSetSize = solarisPsInfo.pr_rssize.longValue() * 1024L;
        this.startTime = solarisPsInfo.pr_start.tv_sec.longValue() * 1000L + solarisPsInfo.pr_start.tv_nsec.longValue() / 1000000L;
        long l3 = l2 - this.startTime;
        this.upTime = l3 < 1L ? 1L : l3;
        this.kernelTime = 0L;
        this.userTime = solarisPsInfo.pr_time.tv_sec.longValue() * 1000L + solarisPsInfo.pr_time.tv_nsec.longValue() / 1000000L;
        this.commandLineBackup = Native.toString(solarisPsInfo.pr_psargs);
        this.path = ParseUtil.whitespaces.split(this.commandLineBackup)[0];
        this.name = this.path.substring(this.path.lastIndexOf(47) + 1);
        if (solarisPrUsage != null) {
            this.userTime = solarisPrUsage.pr_utime.tv_sec.longValue() * 1000L + solarisPrUsage.pr_utime.tv_nsec.longValue() / 1000000L;
            this.kernelTime = solarisPrUsage.pr_stime.tv_sec.longValue() * 1000L + solarisPrUsage.pr_stime.tv_nsec.longValue() / 1000000L;
            this.bytesRead = solarisPrUsage.pr_ioch.longValue();
            this.majorFaults = solarisPrUsage.pr_majf.longValue();
            this.minorFaults = solarisPrUsage.pr_minf.longValue();
            this.contextSwitches = solarisPrUsage.pr_ictx.longValue() + solarisPrUsage.pr_vctx.longValue();
        }
        return true;
    }

    static OSProcess.State getStateFromOutput(char c2) {
        OSProcess.State state;
        switch (c2) {
            case 'O': {
                state = OSProcess.State.RUNNING;
                break;
            }
            case 'S': {
                state = OSProcess.State.SLEEPING;
                break;
            }
            case 'R': 
            case 'W': {
                state = OSProcess.State.WAITING;
                break;
            }
            case 'Z': {
                state = OSProcess.State.ZOMBIE;
                break;
            }
            case 'T': {
                state = OSProcess.State.STOPPED;
                break;
            }
            default: {
                state = OSProcess.State.OTHER;
            }
        }
        return state;
    }
}

