/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.util.internal;

import com.gradle.scan.plugin.internal.dep.io.netty.util.IllegalReferenceCountException;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ReferenceCounted;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class ReferenceCountUpdater<T extends ReferenceCounted> {
    protected ReferenceCountUpdater() {
    }

    public static long getUnsafeOffset(Class<? extends ReferenceCounted> clazz, String string) {
        try {
            if (PlatformDependent.hasUnsafe()) {
                return PlatformDependent.objectFieldOffset(clazz.getDeclaredField(string));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1L;
    }

    protected abstract AtomicIntegerFieldUpdater<T> updater();

    protected abstract long unsafeOffset();

    public final int initialValue() {
        return 2;
    }

    public void setInitialValue(T t2) {
        long l2 = this.unsafeOffset();
        if (l2 == -1L) {
            this.updater().set(t2, this.initialValue());
        } else {
            PlatformDependent.safeConstructPutInt(t2, l2, this.initialValue());
        }
    }

    private static int realRefCnt(int n2) {
        return n2 != 2 && n2 != 4 && (n2 & 1) != 0 ? 0 : n2 >>> 1;
    }

    private static int toLiveRealRefCnt(int n2, int n3) {
        if (n2 == 2 || n2 == 4 || (n2 & 1) == 0) {
            return n2 >>> 1;
        }
        throw new IllegalReferenceCountException(0, -n3);
    }

    private int nonVolatileRawCnt(T t2) {
        long l2 = this.unsafeOffset();
        return l2 != -1L ? PlatformDependent.getInt(t2, l2) : this.updater().get(t2);
    }

    public final int refCnt(T t2) {
        return ReferenceCountUpdater.realRefCnt(this.updater().get(t2));
    }

    public final boolean isLiveNonVolatile(T t2) {
        long l2 = this.unsafeOffset();
        int n2 = l2 != -1L ? PlatformDependent.getInt(t2, l2) : this.updater().get(t2);
        return n2 == 2 || n2 == 4 || n2 == 6 || n2 == 8 || (n2 & 1) == 0;
    }

    public final void resetRefCnt(T t2) {
        this.updater().lazySet(t2, this.initialValue());
    }

    public final T retain(T t2) {
        return this.retain0(t2, 1, 2);
    }

    private T retain0(T t2, int n2, int n3) {
        int n4 = this.updater().getAndAdd(t2, n3);
        if (n4 != 2 && n4 != 4 && (n4 & 1) != 0) {
            throw new IllegalReferenceCountException(0, n2);
        }
        if (n4 <= 0 && n4 + n3 >= 0 || n4 >= 0 && n4 + n3 < n4) {
            this.updater().getAndAdd(t2, -n3);
            throw new IllegalReferenceCountException(ReferenceCountUpdater.realRefCnt(n4), n2);
        }
        return t2;
    }

    public final boolean release(T t2) {
        int n2 = this.nonVolatileRawCnt(t2);
        return n2 == 2 ? this.tryFinalRelease0(t2, 2) || this.retryRelease0(t2, 1) : this.nonFinalRelease0(t2, 1, n2, ReferenceCountUpdater.toLiveRealRefCnt(n2, 1));
    }

    public final boolean release(T t2, int n2) {
        int n3 = this.nonVolatileRawCnt(t2);
        int n4 = ReferenceCountUpdater.toLiveRealRefCnt(n3, ObjectUtil.checkPositive(n2, "decrement"));
        return n2 == n4 ? this.tryFinalRelease0(t2, n3) || this.retryRelease0(t2, n2) : this.nonFinalRelease0(t2, n2, n3, n4);
    }

    private boolean tryFinalRelease0(T t2, int n2) {
        return this.updater().compareAndSet(t2, n2, 1);
    }

    private boolean nonFinalRelease0(T t2, int n2, int n3, int n4) {
        if (n2 < n4 && this.updater().compareAndSet(t2, n3, n3 - (n2 << 1))) {
            return false;
        }
        return this.retryRelease0(t2, n2);
    }

    private boolean retryRelease0(T t2, int n2) {
        while (true) {
            int n3;
            int n4;
            if (n2 == (n4 = ReferenceCountUpdater.toLiveRealRefCnt(n3 = this.updater().get(t2), n2))) {
                if (this.tryFinalRelease0(t2, n3)) {
                    return true;
                }
            } else if (n2 < n4) {
                if (this.updater().compareAndSet(t2, n3, n3 - (n2 << 1))) {
                    return false;
                }
            } else {
                throw new IllegalReferenceCountException(n4, -n2);
            }
            Thread.yield();
        }
    }
}

