/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.proxy;

import com.gradle.scan.plugin.internal.dep.io.netty.channel.Channel;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelDuplexHandler;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelFuture;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelFutureListener;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelPromise;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.PendingWriteQueue;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.proxy.ProxyConnectException;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.proxy.ProxyConnectionEvent;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ReferenceCountUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.DefaultPromise;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.EventExecutor;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.Future;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.nio.channels.ConnectionPendingException;
import java.util.concurrent.TimeUnit;

public abstract class ProxyHandler
extends ChannelDuplexHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ProxyHandler.class);
    private final SocketAddress proxyAddress;
    private volatile SocketAddress destinationAddress;
    private volatile long connectTimeoutMillis = 10000L;
    private volatile ChannelHandlerContext ctx;
    private PendingWriteQueue pendingWrites;
    private boolean finished;
    private boolean suppressChannelReadComplete;
    private boolean flushedPrematurely;
    private final LazyChannelPromise connectPromise = new LazyChannelPromise();
    private Future<?> connectTimeoutFuture;
    private final ChannelFutureListener writeListener = new ChannelFutureListener(){

        @Override
        public void operationComplete(ChannelFuture channelFuture) throws Exception {
            if (!channelFuture.isSuccess()) {
                ProxyHandler.this.setConnectFailure(channelFuture.cause());
            }
        }
    };

    protected ProxyHandler(SocketAddress socketAddress) {
        this.proxyAddress = ObjectUtil.checkNotNull(socketAddress, "proxyAddress");
    }

    public abstract String protocol();

    public abstract String authScheme();

    public final <T extends SocketAddress> T destinationAddress() {
        return (T)this.destinationAddress;
    }

    @Override
    public final void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.ctx = channelHandlerContext;
        this.addCodec(channelHandlerContext);
        if (channelHandlerContext.channel().isActive()) {
            this.sendInitialMessage(channelHandlerContext);
        }
    }

    protected abstract void addCodec(ChannelHandlerContext var1) throws Exception;

    protected abstract void removeEncoder(ChannelHandlerContext var1) throws Exception;

    protected abstract void removeDecoder(ChannelHandlerContext var1) throws Exception;

    @Override
    public final void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) throws Exception {
        if (this.destinationAddress != null) {
            channelPromise.setFailure(new ConnectionPendingException());
            return;
        }
        this.destinationAddress = socketAddress;
        channelHandlerContext.connect(this.proxyAddress, socketAddress2, channelPromise);
    }

    @Override
    public final void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.sendInitialMessage(channelHandlerContext);
        channelHandlerContext.fireChannelActive();
    }

    private void sendInitialMessage(ChannelHandlerContext channelHandlerContext) throws Exception {
        Object object;
        long l2 = this.connectTimeoutMillis;
        if (l2 > 0L) {
            this.connectTimeoutFuture = channelHandlerContext.executor().schedule(new Runnable(){

                @Override
                public void run() {
                    if (!ProxyHandler.this.connectPromise.isDone()) {
                        ProxyHandler.this.setConnectFailure(new ProxyConnectException(ProxyHandler.this.exceptionMessage("timeout")));
                    }
                }
            }, l2, TimeUnit.MILLISECONDS);
        }
        if ((object = this.newInitialMessage(channelHandlerContext)) != null) {
            this.sendToProxyServer(object);
        }
        ProxyHandler.readIfNeeded(channelHandlerContext);
    }

    protected abstract Object newInitialMessage(ChannelHandlerContext var1) throws Exception;

    protected final void sendToProxyServer(Object object) {
        this.ctx.writeAndFlush(object).addListener(this.writeListener);
    }

    @Override
    public final void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (this.finished) {
            channelHandlerContext.fireChannelInactive();
        } else {
            this.setConnectFailure(new ProxyConnectException(this.exceptionMessage("disconnected")));
        }
    }

    @Override
    public final void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
        if (this.finished) {
            channelHandlerContext.fireExceptionCaught(throwable);
        } else {
            this.setConnectFailure(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        if (this.finished) {
            this.suppressChannelReadComplete = false;
            channelHandlerContext.fireChannelRead(object);
        } else {
            this.suppressChannelReadComplete = true;
            Throwable throwable = null;
            try {
                boolean bl2 = this.handleResponse(channelHandlerContext, object);
                if (bl2) {
                    this.setConnectSuccess();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            finally {
                ReferenceCountUtil.release(object);
                if (throwable != null) {
                    this.setConnectFailure(throwable);
                }
            }
        }
    }

    protected abstract boolean handleResponse(ChannelHandlerContext var1, Object var2) throws Exception;

    private void setConnectSuccess() {
        this.finished = true;
        this.cancelConnectTimeoutFuture();
        if (!this.connectPromise.isDone()) {
            boolean bl2 = true;
            bl2 &= this.safeRemoveEncoder();
            this.ctx.fireUserEventTriggered(new ProxyConnectionEvent(this.protocol(), this.authScheme(), this.proxyAddress, this.destinationAddress));
            if (bl2 &= this.safeRemoveDecoder()) {
                this.writePendingWrites();
                if (this.flushedPrematurely) {
                    this.ctx.flush();
                }
                this.connectPromise.trySuccess(this.ctx.channel());
            } else {
                ProxyConnectException proxyConnectException = new ProxyConnectException("failed to remove all codec handlers added by the proxy handler; bug?");
                this.failPendingWritesAndClose(proxyConnectException);
            }
        }
    }

    private boolean safeRemoveDecoder() {
        try {
            this.removeDecoder(this.ctx);
            return true;
        }
        catch (Exception exception) {
            logger.warn("Failed to remove proxy decoders:", exception);
            return false;
        }
    }

    private boolean safeRemoveEncoder() {
        try {
            this.removeEncoder(this.ctx);
            return true;
        }
        catch (Exception exception) {
            logger.warn("Failed to remove proxy encoders:", exception);
            return false;
        }
    }

    private void setConnectFailure(Throwable throwable) {
        this.finished = true;
        this.cancelConnectTimeoutFuture();
        if (!this.connectPromise.isDone()) {
            if (!(throwable instanceof ProxyConnectException)) {
                throwable = new ProxyConnectException(this.exceptionMessage(throwable.toString()), throwable);
            }
            this.safeRemoveDecoder();
            this.safeRemoveEncoder();
            this.failPendingWritesAndClose(throwable);
        }
    }

    private void failPendingWritesAndClose(Throwable throwable) {
        this.failPendingWrites(throwable);
        this.connectPromise.tryFailure(throwable);
        this.ctx.fireExceptionCaught(throwable);
        this.ctx.close();
    }

    private void cancelConnectTimeoutFuture() {
        if (this.connectTimeoutFuture != null) {
            this.connectTimeoutFuture.cancel(false);
            this.connectTimeoutFuture = null;
        }
    }

    protected final String exceptionMessage(String string) {
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder = new StringBuilder(128 + string.length()).append(this.protocol()).append(", ").append(this.authScheme()).append(", ").append(this.proxyAddress).append(" => ").append(this.destinationAddress);
        if (!string.isEmpty()) {
            stringBuilder.append(", ").append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public final void channelReadComplete(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (this.suppressChannelReadComplete) {
            this.suppressChannelReadComplete = false;
            ProxyHandler.readIfNeeded(channelHandlerContext);
        } else {
            channelHandlerContext.fireChannelReadComplete();
        }
    }

    @Override
    public final void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
        if (this.finished) {
            this.writePendingWrites();
            channelHandlerContext.write(object, channelPromise);
        } else {
            this.addPendingWrite(channelHandlerContext, object, channelPromise);
        }
    }

    @Override
    public final void flush(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (this.finished) {
            this.writePendingWrites();
            channelHandlerContext.flush();
        } else {
            this.flushedPrematurely = true;
        }
    }

    private static void readIfNeeded(ChannelHandlerContext channelHandlerContext) {
        if (!channelHandlerContext.channel().config().isAutoRead()) {
            channelHandlerContext.read();
        }
    }

    private void writePendingWrites() {
        if (this.pendingWrites != null) {
            this.pendingWrites.removeAndWriteAll();
            this.pendingWrites = null;
        }
    }

    private void failPendingWrites(Throwable throwable) {
        if (this.pendingWrites != null) {
            this.pendingWrites.removeAndFailAll(throwable);
            this.pendingWrites = null;
        }
    }

    private void addPendingWrite(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        PendingWriteQueue pendingWriteQueue = this.pendingWrites;
        if (pendingWriteQueue == null) {
            this.pendingWrites = pendingWriteQueue = new PendingWriteQueue(channelHandlerContext);
        }
        pendingWriteQueue.add(object, channelPromise);
    }

    private final class LazyChannelPromise
    extends DefaultPromise<Channel> {
        private LazyChannelPromise() {
        }

        @Override
        protected EventExecutor executor() {
            if (ProxyHandler.this.ctx == null) {
                throw new IllegalStateException();
            }
            return ProxyHandler.this.ctx.executor();
        }
    }
}

