/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.codec;

import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.Headers;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.HeadersUtils;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.ValueConverter;
import com.gradle.scan.plugin.internal.dep.io.netty.util.HashingStrategy;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.MathUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class DefaultHeaders<K, V, T extends Headers<K, V, T>>
implements Headers<K, V, T> {
    private final HeaderEntry<K, V>[] entries;
    protected final HeaderEntry<K, V> head;
    private final byte hashMask;
    private final ValueConverter<V> valueConverter;
    private final NameValidator<K> nameValidator;
    private final ValueValidator<V> valueValidator;
    private final HashingStrategy<K> hashingStrategy;
    int size;

    public DefaultHeaders(HashingStrategy<K> hashingStrategy, ValueConverter<V> valueConverter, NameValidator<K> nameValidator, int n2) {
        this(hashingStrategy, valueConverter, nameValidator, n2, ValueValidator.NO_VALIDATION);
    }

    public DefaultHeaders(HashingStrategy<K> hashingStrategy, ValueConverter<V> valueConverter, NameValidator<K> nameValidator, int n2, ValueValidator<V> valueValidator) {
        this.valueConverter = ObjectUtil.checkNotNull(valueConverter, "valueConverter");
        this.nameValidator = ObjectUtil.checkNotNull(nameValidator, "nameValidator");
        this.hashingStrategy = ObjectUtil.checkNotNull(hashingStrategy, "nameHashingStrategy");
        this.valueValidator = ObjectUtil.checkNotNull(valueValidator, "valueValidator");
        this.entries = new HeaderEntry[MathUtil.findNextPositivePowerOfTwo(Math.max(2, Math.min(n2, 128)))];
        this.hashMask = (byte)(this.entries.length - 1);
        this.head = new HeaderEntry();
    }

    @Override
    public V get(K k2) {
        ObjectUtil.checkNotNull(k2, "name");
        int n2 = this.hashingStrategy.hashCode(k2);
        int n3 = this.index(n2);
        HeaderEntry<K, V> headerEntry = this.entries[n3];
        V v2 = null;
        while (headerEntry != null) {
            if (headerEntry.hash == n2 && this.hashingStrategy.equals(k2, headerEntry.key)) {
                v2 = headerEntry.value;
            }
            headerEntry = headerEntry.next;
        }
        return v2;
    }

    public V getAndRemove(K k2) {
        int n2 = this.hashingStrategy.hashCode(k2);
        return this.remove0(n2, this.index(n2), ObjectUtil.checkNotNull(k2, "name"));
    }

    @Override
    public List<V> getAll(K k2) {
        ObjectUtil.checkNotNull(k2, "name");
        LinkedList<V> linkedList = new LinkedList<V>();
        int n2 = this.hashingStrategy.hashCode(k2);
        int n3 = this.index(n2);
        HeaderEntry<K, V> headerEntry = this.entries[n3];
        while (headerEntry != null) {
            if (headerEntry.hash == n2 && this.hashingStrategy.equals(k2, headerEntry.key)) {
                linkedList.addFirst(headerEntry.getValue());
            }
            headerEntry = headerEntry.next;
        }
        return linkedList;
    }

    public Iterator<V> valueIterator(K k2) {
        return new ValueIterator(k2);
    }

    public boolean contains(K k2) {
        return this.get(k2) != null;
    }

    public final boolean contains(K k2, V v2, HashingStrategy<? super V> hashingStrategy) {
        ObjectUtil.checkNotNull(k2, "name");
        int n2 = this.hashingStrategy.hashCode(k2);
        int n3 = this.index(n2);
        HeaderEntry<K, V> headerEntry = this.entries[n3];
        while (headerEntry != null) {
            if (headerEntry.hash == n2 && this.hashingStrategy.equals(k2, headerEntry.key) && hashingStrategy.equals(v2, headerEntry.value)) {
                return true;
            }
            headerEntry = headerEntry.next;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.head == this.head.after;
    }

    public Set<K> names() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet(this.size());
        HeaderEntry headerEntry = this.head.after;
        while (headerEntry != this.head) {
            linkedHashSet.add(headerEntry.getKey());
            headerEntry = headerEntry.after;
        }
        return linkedHashSet;
    }

    public T add(K k2, V v2) {
        this.validateName(this.nameValidator, true, k2);
        this.validateValue(this.valueValidator, k2, v2);
        ObjectUtil.checkNotNull(v2, "value");
        int n2 = this.hashingStrategy.hashCode(k2);
        int n3 = this.index(n2);
        this.add0(n2, n3, k2, v2);
        return this.thisT();
    }

    public T addObject(K k2, Object object) {
        return this.add(k2, this.fromObject(k2, object));
    }

    public T add(Headers<? extends K, ? extends V, ?> headers) {
        if (headers == this) {
            throw new IllegalArgumentException("can't add to itself.");
        }
        this.addImpl(headers);
        return this.thisT();
    }

    protected void addImpl(Headers<? extends K, ? extends V, ?> headers) {
        if (headers instanceof DefaultHeaders) {
            DefaultHeaders defaultHeaders = (DefaultHeaders)headers;
            HeaderEntry headerEntry = defaultHeaders.head.after;
            if (defaultHeaders.hashingStrategy == this.hashingStrategy && defaultHeaders.nameValidator == this.nameValidator) {
                while (headerEntry != defaultHeaders.head) {
                    this.add0(headerEntry.hash, this.index(headerEntry.hash), headerEntry.key, headerEntry.value);
                    headerEntry = headerEntry.after;
                }
            } else {
                while (headerEntry != defaultHeaders.head) {
                    this.add(headerEntry.key, headerEntry.value);
                    headerEntry = headerEntry.after;
                }
            }
        } else {
            for (Map.Entry<K, V> entry : headers) {
                this.add(entry.getKey(), entry.getValue());
            }
        }
    }

    public T set(K k2, V v2) {
        this.validateName(this.nameValidator, false, k2);
        this.validateValue(this.valueValidator, k2, v2);
        ObjectUtil.checkNotNull(v2, "value");
        int n2 = this.hashingStrategy.hashCode(k2);
        int n3 = this.index(n2);
        this.remove0(n2, n3, k2);
        this.add0(n2, n3, k2, v2);
        return this.thisT();
    }

    public T setObject(K k2, Object object) {
        V v2 = ObjectUtil.checkNotNull(this.fromObject(k2, object), "convertedValue");
        return this.set(k2, v2);
    }

    public T setObject(K k2, Iterable<?> iterable) {
        this.validateName(this.nameValidator, false, k2);
        int n2 = this.hashingStrategy.hashCode(k2);
        int n3 = this.index(n2);
        this.remove0(n2, n3, k2);
        for (Object obj : iterable) {
            if (obj == null) break;
            V v2 = this.fromObject(k2, obj);
            this.validateValue(this.valueValidator, k2, v2);
            this.add0(n2, n3, k2, v2);
        }
        return this.thisT();
    }

    public T set(Headers<? extends K, ? extends V, ?> headers) {
        if (headers != this) {
            this.clear();
            this.addImpl(headers);
        }
        return this.thisT();
    }

    public boolean remove(K k2) {
        return this.getAndRemove(k2) != null;
    }

    public T clear() {
        Arrays.fill(this.entries, null);
        this.head.after = this.head;
        this.head.before = this.head.after;
        this.size = 0;
        return this.thisT();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new HeaderIterator();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Headers)) {
            return false;
        }
        return this.equals((Headers)object, HashingStrategy.JAVA_HASHER);
    }

    public int hashCode() {
        return this.hashCode(HashingStrategy.JAVA_HASHER);
    }

    public final boolean equals(Headers<K, V, ?> headers, HashingStrategy<V> hashingStrategy) {
        if (headers.size() != this.size()) {
            return false;
        }
        if (this == headers) {
            return true;
        }
        for (K k2 : this.names()) {
            List<V> list = headers.getAll(k2);
            List<V> list2 = this.getAll(k2);
            if (list.size() != list2.size()) {
                return false;
            }
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (hashingStrategy.equals(list.get(i2), list2.get(i2))) continue;
                return false;
            }
        }
        return true;
    }

    public final int hashCode(HashingStrategy<V> hashingStrategy) {
        int n2 = -1028477387;
        for (K k2 : this.names()) {
            n2 = 31 * n2 + this.hashingStrategy.hashCode(k2);
            List<V> list = this.getAll(k2);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                n2 = 31 * n2 + hashingStrategy.hashCode(list.get(i2));
            }
        }
        return n2;
    }

    public String toString() {
        return HeadersUtils.toString(this.getClass(), this.iterator(), this.size());
    }

    protected void validateName(NameValidator<K> nameValidator, boolean bl2, K k2) {
        nameValidator.validateName(k2);
    }

    protected void validateValue(ValueValidator<V> valueValidator, K k2, V v2) {
        try {
            valueValidator.validate(v2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Validation failed for header '" + k2 + "'", illegalArgumentException);
        }
    }

    protected HeaderEntry<K, V> newHeaderEntry(int n2, K k2, V v2, HeaderEntry<K, V> headerEntry) {
        return new HeaderEntry<K, V>(n2, k2, v2, headerEntry, this.head);
    }

    protected ValueConverter<V> valueConverter() {
        return this.valueConverter;
    }

    private int index(int n2) {
        return n2 & this.hashMask;
    }

    private void add0(int n2, int n3, K k2, V v2) {
        this.entries[n3] = this.newHeaderEntry(n2, k2, v2, this.entries[n3]);
        ++this.size;
    }

    private V remove0(int n2, int n3, K k2) {
        HeaderEntry<K, V> headerEntry = this.entries[n3];
        if (headerEntry == null) {
            return null;
        }
        V v2 = null;
        HeaderEntry headerEntry2 = headerEntry.next;
        while (headerEntry2 != null) {
            if (headerEntry2.hash == n2 && this.hashingStrategy.equals(k2, headerEntry2.key)) {
                v2 = headerEntry2.value;
                headerEntry.next = headerEntry2.next;
                headerEntry2.remove();
                --this.size;
            } else {
                headerEntry = headerEntry2;
            }
            headerEntry2 = headerEntry.next;
        }
        headerEntry = this.entries[n3];
        if (headerEntry.hash == n2 && this.hashingStrategy.equals(k2, headerEntry.key)) {
            if (v2 == null) {
                v2 = headerEntry.value;
            }
            this.entries[n3] = headerEntry.next;
            headerEntry.remove();
            --this.size;
        }
        return v2;
    }

    HeaderEntry<K, V> remove0(HeaderEntry<K, V> headerEntry, HeaderEntry<K, V> headerEntry2) {
        int n2 = this.index(headerEntry.hash);
        HeaderEntry<K, V> headerEntry3 = this.entries[n2];
        if (headerEntry3 == headerEntry) {
            this.entries[n2] = headerEntry.next;
            headerEntry2 = this.entries[n2];
        } else if (headerEntry2 == null) {
            headerEntry2 = headerEntry3;
            HeaderEntry headerEntry4 = headerEntry3.next;
            while (headerEntry4 != null && headerEntry4 != headerEntry) {
                headerEntry2 = headerEntry4;
                headerEntry4 = headerEntry4.next;
            }
            assert (headerEntry4 != null) : "Entry not found in its hash bucket: " + headerEntry;
            headerEntry2.next = headerEntry.next;
        } else {
            headerEntry2.next = headerEntry.next;
        }
        headerEntry.remove();
        --this.size;
        return headerEntry2;
    }

    private T thisT() {
        return (T)this;
    }

    private V fromObject(K k2, Object object) {
        try {
            return this.valueConverter.convertObject(ObjectUtil.checkNotNull(object, "value"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Failed to convert object value for header '" + k2 + '\'', illegalArgumentException);
        }
    }

    public DefaultHeaders<K, V, T> copy() {
        DefaultHeaders<K, V, T> defaultHeaders = new DefaultHeaders<K, V, T>(this.hashingStrategy, this.valueConverter, this.nameValidator, this.entries.length);
        defaultHeaders.addImpl(this);
        return defaultHeaders;
    }

    protected static class HeaderEntry<K, V>
    implements Map.Entry<K, V> {
        protected final int hash;
        protected final K key;
        protected V value;
        protected HeaderEntry<K, V> next;
        protected HeaderEntry<K, V> before;
        protected HeaderEntry<K, V> after;

        HeaderEntry(int n2, K k2, V v2, HeaderEntry<K, V> headerEntry, HeaderEntry<K, V> headerEntry2) {
            this.hash = n2;
            this.key = k2;
            this.value = v2;
            this.next = headerEntry;
            this.after = headerEntry2;
            this.before = headerEntry2.before;
            this.pointNeighborsToThis();
        }

        HeaderEntry() {
            this.hash = -1;
            this.key = null;
            this.before = this.after = this;
        }

        protected final void pointNeighborsToThis() {
            this.before.after = this;
            this.after.before = this;
        }

        protected void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V v2) {
            ObjectUtil.checkNotNull(v2, "value");
            V v3 = this.value;
            this.value = v2;
            return v3;
        }

        public final String toString() {
            return this.key.toString() + '=' + this.value.toString();
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.getKey() == null ? entry.getKey() == null : this.getKey().equals(entry.getKey())) && (this.getValue() == null ? entry.getValue() == null : this.getValue().equals(entry.getValue()));
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }

    private final class ValueIterator
    implements Iterator<V> {
        private final K name;
        private final int hash;
        private HeaderEntry<K, V> removalPrevious;
        private HeaderEntry<K, V> previous;
        private HeaderEntry<K, V> next;

        ValueIterator(K k2) {
            this.name = ObjectUtil.checkNotNull(k2, "name");
            this.hash = DefaultHeaders.this.hashingStrategy.hashCode(k2);
            this.calculateNext(DefaultHeaders.this.entries[DefaultHeaders.this.index(this.hash)]);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.previous != null) {
                this.removalPrevious = this.previous;
            }
            this.previous = this.next;
            this.calculateNext(this.next.next);
            return this.previous.value;
        }

        @Override
        public void remove() {
            if (this.previous == null) {
                throw new IllegalStateException();
            }
            this.removalPrevious = DefaultHeaders.this.remove0(this.previous, this.removalPrevious);
            this.previous = null;
        }

        private void calculateNext(HeaderEntry<K, V> headerEntry) {
            while (headerEntry != null) {
                if (headerEntry.hash == this.hash && DefaultHeaders.this.hashingStrategy.equals(this.name, headerEntry.key)) {
                    this.next = headerEntry;
                    return;
                }
                headerEntry = headerEntry.next;
            }
            this.next = null;
        }
    }

    private final class HeaderIterator
    implements Iterator<Map.Entry<K, V>> {
        private HeaderEntry<K, V> current;

        private HeaderIterator() {
            this.current = DefaultHeaders.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.current.after != DefaultHeaders.this.head;
        }

        @Override
        public Map.Entry<K, V> next() {
            this.current = this.current.after;
            if (this.current == DefaultHeaders.this.head) {
                throw new NoSuchElementException();
            }
            return this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("read only");
        }
    }

    public static interface ValueValidator<V> {
        public static final ValueValidator<?> NO_VALIDATION = new ValueValidator<Object>(){

            @Override
            public void validate(Object object) {
            }
        };

        public void validate(V var1);
    }

    public static interface NameValidator<K> {
        public static final NameValidator NOT_NULL = new NameValidator(){

            public void validateName(Object object) {
                ObjectUtil.checkNotNull(object, "name");
            }
        };

        public void validateName(K var1);
    }
}

