/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.buffer;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.PoolChunk;
import java.util.concurrent.locks.ReentrantLock;

final class PoolSubpage<T> {
    final PoolChunk<T> chunk;
    final int elemSize;
    private final int pageShifts;
    private final int runOffset;
    private final int runSize;
    private final long[] bitmap;
    private final int bitmapLength;
    private final int maxNumElems;
    final int headIndex;
    PoolSubpage<T> prev;
    PoolSubpage<T> next;
    boolean doNotDestroy;
    private int nextAvail;
    private int numAvail;
    final ReentrantLock lock;

    PoolSubpage(int n2) {
        this.chunk = null;
        this.lock = new ReentrantLock();
        this.pageShifts = -1;
        this.runOffset = -1;
        this.elemSize = -1;
        this.runSize = -1;
        this.bitmap = null;
        this.bitmapLength = -1;
        this.maxNumElems = 0;
        this.headIndex = n2;
    }

    PoolSubpage(PoolSubpage<T> poolSubpage, PoolChunk<T> poolChunk, int n2, int n3, int n4, int n5) {
        this.headIndex = poolSubpage.headIndex;
        this.chunk = poolChunk;
        this.pageShifts = n2;
        this.runOffset = n3;
        this.runSize = n4;
        this.elemSize = n5;
        this.doNotDestroy = true;
        this.maxNumElems = this.numAvail = n4 / n5;
        int n6 = this.maxNumElems >>> 6;
        if ((this.maxNumElems & 0x3F) != 0) {
            ++n6;
        }
        this.bitmapLength = n6;
        this.bitmap = new long[n6];
        this.nextAvail = 0;
        this.lock = null;
        this.addToPool(poolSubpage);
    }

    long allocate() {
        if (this.numAvail == 0 || !this.doNotDestroy) {
            return -1L;
        }
        int n2 = this.getNextAvail();
        if (n2 < 0) {
            this.removeFromPool();
            throw new AssertionError((Object)("No next available bitmap index found (bitmapIdx = " + n2 + "), even though there are supposed to be (numAvail = " + this.numAvail + ") out of (maxNumElems = " + this.maxNumElems + ") available indexes."));
        }
        int n3 = n2 >>> 6;
        int n4 = n2 & 0x3F;
        assert ((this.bitmap[n3] >>> n4 & 1L) == 0L);
        int n5 = n3;
        this.bitmap[n5] = this.bitmap[n5] | 1L << n4;
        if (--this.numAvail == 0) {
            this.removeFromPool();
        }
        return this.toHandle(n2);
    }

    boolean free(PoolSubpage<T> poolSubpage, int n2) {
        int n3 = n2 >>> 6;
        int n4 = n2 & 0x3F;
        assert ((this.bitmap[n3] >>> n4 & 1L) != 0L);
        int n5 = n3;
        this.bitmap[n5] = this.bitmap[n5] ^ 1L << n4;
        this.setNextAvail(n2);
        if (this.numAvail++ == 0) {
            this.addToPool(poolSubpage);
            if (this.maxNumElems > 1) {
                return true;
            }
        }
        if (this.numAvail != this.maxNumElems) {
            return true;
        }
        if (this.prev == this.next) {
            return true;
        }
        this.doNotDestroy = false;
        this.removeFromPool();
        return false;
    }

    private void addToPool(PoolSubpage<T> poolSubpage) {
        assert (this.prev == null && this.next == null);
        this.prev = poolSubpage;
        this.next = poolSubpage.next;
        this.next.prev = this;
        poolSubpage.next = this;
    }

    private void removeFromPool() {
        assert (this.prev != null && this.next != null);
        this.prev.next = this.next;
        this.next.prev = this.prev;
        this.next = null;
        this.prev = null;
    }

    private void setNextAvail(int n2) {
        this.nextAvail = n2;
    }

    private int getNextAvail() {
        int n2 = this.nextAvail;
        if (n2 >= 0) {
            this.nextAvail = -1;
            return n2;
        }
        return this.findNextAvail();
    }

    private int findNextAvail() {
        for (int i2 = 0; i2 < this.bitmapLength; ++i2) {
            long l2 = this.bitmap[i2];
            if ((l2 ^ 0xFFFFFFFFFFFFFFFFL) == 0L) continue;
            return this.findNextAvail0(i2, l2);
        }
        return -1;
    }

    private int findNextAvail0(int n2, long l2) {
        int n3 = n2 << 6;
        for (int i2 = 0; i2 < 64; ++i2) {
            if ((l2 & 1L) == 0L) {
                int n4 = n3 | i2;
                if (n4 >= this.maxNumElems) break;
                return n4;
            }
            l2 >>>= 1;
        }
        return -1;
    }

    private long toHandle(int n2) {
        int n3 = this.runSize >> this.pageShifts;
        return (long)this.runOffset << 49 | (long)n3 << 34 | 0x200000000L | 0x100000000L | (long)n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int n2;
        if (this.chunk == null) {
            n2 = 0;
        } else {
            boolean bl2;
            PoolSubpage poolSubpage = this.chunk.arena.smallSubpagePools[this.headIndex];
            poolSubpage.lock();
            try {
                bl2 = this.doNotDestroy;
                n2 = this.numAvail;
            }
            finally {
                poolSubpage.unlock();
            }
            if (!bl2) {
                return "(" + this.runOffset + ": not in use)";
            }
        }
        return "(" + this.runOffset + ": " + (this.maxNumElems - n2) + '/' + this.maxNumElems + ", offset: " + this.runOffset + ", length: " + this.runSize + ", elemSize: " + this.elemSize + ')';
    }

    boolean isDoNotDestroy() {
        if (this.chunk == null) {
            return true;
        }
        PoolSubpage poolSubpage = this.chunk.arena.smallSubpagePools[this.headIndex];
        poolSubpage.lock();
        try {
            boolean bl2 = this.doNotDestroy;
            return bl2;
        }
        finally {
            poolSubpage.unlock();
        }
    }

    void destroy() {
        if (this.chunk != null) {
            this.chunk.destroy();
        }
    }

    void lock() {
        this.lock.lock();
    }

    void unlock() {
        this.lock.unlock();
    }
}

