/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser.std;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.PropertyMetadata;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.PropertyName;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.node.ObjectNode;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser.PropertyWriter;
import java.io.IOException;

public class MapProperty
extends PropertyWriter {
    private static final BeanProperty BOGUS_PROP = new BeanProperty.Bogus();
    protected final TypeSerializer _typeSerializer;
    protected final BeanProperty _property;
    protected Object _key;
    protected Object _value;
    protected JsonSerializer<Object> _keySerializer;
    protected JsonSerializer<Object> _valueSerializer;

    public MapProperty(TypeSerializer typeSerializer, BeanProperty beanProperty) {
        super(beanProperty == null ? PropertyMetadata.STD_REQUIRED_OR_OPTIONAL : beanProperty.getMetadata());
        this._typeSerializer = typeSerializer;
        this._property = beanProperty == null ? BOGUS_PROP : beanProperty;
    }

    public void reset(Object object, Object object2, JsonSerializer<Object> jsonSerializer, JsonSerializer<Object> jsonSerializer2) {
        this._key = object;
        this._value = object2;
        this._keySerializer = jsonSerializer;
        this._valueSerializer = jsonSerializer2;
    }

    @Override
    public String getName() {
        if (this._key instanceof String) {
            return (String)this._key;
        }
        return String.valueOf(this._key);
    }

    @Override
    public PropertyName getFullName() {
        return new PropertyName(this.getName());
    }

    @Override
    public void serializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        this._keySerializer.serialize(this._key, jsonGenerator, serializerProvider);
        if (this._typeSerializer == null) {
            this._valueSerializer.serialize(this._value, jsonGenerator, serializerProvider);
        } else {
            this._valueSerializer.serializeWithType(this._value, jsonGenerator, serializerProvider, this._typeSerializer);
        }
    }

    @Override
    public void serializeAsOmittedField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
        if (!jsonGenerator.canOmitFields()) {
            jsonGenerator.writeOmittedField(this.getName());
        }
    }

    @Override
    public void depositSchemaProperty(JsonObjectFormatVisitor jsonObjectFormatVisitor, SerializerProvider serializerProvider) throws JsonMappingException {
        this._property.depositSchemaProperty(jsonObjectFormatVisitor, serializerProvider);
    }

    @Override
    @Deprecated
    public void depositSchemaProperty(ObjectNode objectNode, SerializerProvider serializerProvider) throws JsonMappingException {
    }

    @Override
    public JavaType getType() {
        return this._property.getType();
    }

    @Override
    public AnnotatedMember getMember() {
        return this._property.getMember();
    }
}

