/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ext;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.BeanDescription;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationConfig;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.SerializationConfig;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.Deserializers;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ext.Java7Handlers;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser.Serializers;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser.std.DateSerializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.ExceptionUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class OptionalHandlerFactory
implements Serializable {
    private static final Class<?> CLASS_DOM_NODE;
    private static final Class<?> CLASS_DOM_DOCUMENT;
    private static final Java7Handlers _jdk7Helper;
    public static final OptionalHandlerFactory instance;
    private final Map<String, String> _sqlDeserializers = new HashMap<String, String>();
    private final Map<String, Object> _sqlSerializers;

    protected OptionalHandlerFactory() {
        this._sqlDeserializers.put("java.sql.Date", "com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.std.DateDeserializers$SqlDateDeserializer");
        this._sqlDeserializers.put("java.sql.Timestamp", "com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.std.DateDeserializers$TimestampDeserializer");
        this._sqlSerializers = new HashMap<String, Object>();
        this._sqlSerializers.put("java.sql.Timestamp", DateSerializer.instance);
        this._sqlSerializers.put("java.sql.Date", "com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser.std.SqlDateSerializer");
        this._sqlSerializers.put("java.sql.Time", "com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ser.std.SqlTimeSerializer");
        this._sqlSerializers.put("java.sql.Blob", "com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ext.SqlBlobSerializer");
        this._sqlSerializers.put("javax.sql.rowset.serial.SerialBlob", "com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ext.SqlBlobSerializer");
    }

    public JsonSerializer<?> findSerializer(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription) {
        Object object;
        Class<?> clazz = javaType.getRawClass();
        if (this._IsXOfY(clazz, CLASS_DOM_NODE)) {
            return (JsonSerializer)this.instantiate("com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ext.DOMSerializer", javaType);
        }
        if (_jdk7Helper != null && (object = _jdk7Helper.getSerializerForJavaNioFilePath(clazz)) != null) {
            return object;
        }
        object = clazz.getName();
        Object object2 = this._sqlSerializers.get(object);
        if (object2 != null) {
            if (object2 instanceof JsonSerializer) {
                return (JsonSerializer)object2;
            }
            return (JsonSerializer)this.instantiate((String)object2, javaType);
        }
        if (!((String)object).startsWith("javax.xml.") && !this.hasSuperClassStartingWith(clazz, "javax.xml.")) {
            return null;
        }
        String string = "com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ext.CoreXMLSerializers";
        Object object3 = this.instantiate(string, javaType);
        if (object3 == null) {
            return null;
        }
        return ((Serializers)object3).findSerializer(serializationConfig, javaType, beanDescription);
    }

    public JsonDeserializer<?> findDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        Object object;
        Class<?> clazz = javaType.getRawClass();
        if (_jdk7Helper != null && (object = _jdk7Helper.getDeserializerForJavaNioFilePath(clazz)) != null) {
            return object;
        }
        if (this._IsXOfY(clazz, CLASS_DOM_NODE)) {
            return (JsonDeserializer)this.instantiate("com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ext.DOMDeserializer$NodeDeserializer", javaType);
        }
        if (this._IsXOfY(clazz, CLASS_DOM_DOCUMENT)) {
            return (JsonDeserializer)this.instantiate("com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ext.DOMDeserializer$DocumentDeserializer", javaType);
        }
        object = clazz.getName();
        String string = this._sqlDeserializers.get(object);
        if (string != null) {
            return (JsonDeserializer)this.instantiate(string, javaType);
        }
        if (!((String)object).startsWith("javax.xml.") && !this.hasSuperClassStartingWith(clazz, "javax.xml.")) {
            return null;
        }
        String string2 = "com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.ext.CoreXMLDeserializers";
        Object object2 = this.instantiate(string2, javaType);
        if (object2 == null) {
            return null;
        }
        return ((Deserializers)object2).findBeanDeserializer(javaType, deserializationConfig, beanDescription);
    }

    private boolean _IsXOfY(Class<?> clazz, Class<?> clazz2) {
        return clazz2 != null && clazz2.isAssignableFrom(clazz);
    }

    private Object instantiate(String string, JavaType javaType) {
        try {
            return this.instantiate(Class.forName(string), javaType);
        }
        catch (Throwable throwable) {
            ExceptionUtil.rethrowIfFatal(throwable);
            throw new IllegalStateException("Failed to find class `" + string + "` for handling values of type " + ClassUtil.getTypeDescription(javaType) + ", problem: (" + throwable.getClass().getName() + ") " + throwable.getMessage());
        }
    }

    private Object instantiate(Class<?> clazz, JavaType javaType) {
        try {
            return ClassUtil.createInstance(clazz, false);
        }
        catch (Throwable throwable) {
            ExceptionUtil.rethrowIfFatal(throwable);
            throw new IllegalStateException("Failed to create instance of `" + clazz.getName() + "` for handling values of type " + ClassUtil.getTypeDescription(javaType) + ", problem: (" + throwable.getClass().getName() + ") " + throwable.getMessage());
        }
    }

    private boolean hasSuperClassStartingWith(Class<?> clazz, String string) {
        for (Class<?> clazz2 = clazz.getSuperclass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            if (clazz2 == Object.class) {
                return false;
            }
            if (!clazz2.getName().startsWith(string)) continue;
            return true;
        }
        return false;
    }

    static {
        Object object = null;
        Class<Node> clazz = null;
        try {
            clazz = Node.class;
            object = Document.class;
        }
        catch (Throwable throwable) {
            ExceptionUtil.rethrowIfFatal(throwable);
        }
        CLASS_DOM_NODE = clazz;
        CLASS_DOM_DOCUMENT = object;
        object = null;
        try {
            object = Java7Handlers.instance();
        }
        catch (Throwable throwable) {
            ExceptionUtil.rethrowIfFatal(throwable);
        }
        _jdk7Helper = object;
        instance = new OptionalHandlerFactory();
    }
}

