/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.ContentReference;
import java.io.Serializable;

public class JsonLocation
implements Serializable {
    public static final JsonLocation NA = new JsonLocation(ContentReference.unknown(), -1L, -1L, -1, -1);
    protected final long _totalBytes;
    protected final long _totalChars;
    protected final int _lineNr;
    protected final int _columnNr;
    protected final ContentReference _contentReference;
    protected transient String _sourceDescription;

    public JsonLocation(ContentReference contentReference, long l2, int n2, int n3) {
        this(contentReference, -1L, l2, n2, n3);
    }

    public JsonLocation(ContentReference contentReference, long l2, long l3, int n2, int n3) {
        if (contentReference == null) {
            contentReference = ContentReference.unknown();
        }
        this._contentReference = contentReference;
        this._totalBytes = l2;
        this._totalChars = l3;
        this._lineNr = n2;
        this._columnNr = n3;
    }

    public String sourceDescription() {
        if (this._sourceDescription == null) {
            this._sourceDescription = this._contentReference.buildSourceDescription();
        }
        return this._sourceDescription;
    }

    public StringBuilder appendOffsetDescription(StringBuilder stringBuilder) {
        if (this._contentReference.hasTextualContent()) {
            stringBuilder.append("line: ");
            if (this._lineNr >= 0) {
                stringBuilder.append(this._lineNr);
            } else {
                stringBuilder.append("UNKNOWN");
            }
            stringBuilder.append(", column: ");
            if (this._columnNr >= 0) {
                stringBuilder.append(this._columnNr);
            } else {
                stringBuilder.append("UNKNOWN");
            }
        } else if (this._lineNr > 0) {
            stringBuilder.append("line: ").append(this._lineNr);
            if (this._columnNr > 0) {
                stringBuilder.append(", column: ");
                stringBuilder.append(this._columnNr);
            }
        } else {
            stringBuilder.append("byte offset: #");
            if (this._totalBytes >= 0L) {
                stringBuilder.append(this._totalBytes);
            } else {
                stringBuilder.append("UNKNOWN");
            }
        }
        return stringBuilder;
    }

    public int hashCode() {
        int n2 = this._contentReference == null ? 1 : 2;
        n2 ^= this._lineNr;
        n2 += this._columnNr;
        n2 ^= (int)this._totalChars;
        return n2 += (int)this._totalBytes;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JsonLocation)) {
            return false;
        }
        JsonLocation jsonLocation = (JsonLocation)object;
        if (this._contentReference == null ? jsonLocation._contentReference != null : !this._contentReference.equals(jsonLocation._contentReference)) {
            return false;
        }
        return this._lineNr == jsonLocation._lineNr && this._columnNr == jsonLocation._columnNr && this._totalChars == jsonLocation._totalChars && this._totalBytes == jsonLocation._totalBytes;
    }

    public String toString() {
        String string = this.sourceDescription();
        StringBuilder stringBuilder = new StringBuilder(40 + string.length()).append("[Source: ").append(string).append("; ");
        return this.appendOffsetDescription(stringBuilder).append(']').toString();
    }
}

