/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.gradle;

import com.google.common.base.Preconditions;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.tasks.SourceSet;
import org.gradle.plugins.ide.idea.GenerateIdeaModule;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.util.GUtil;

public class Utils
implements GroovyObject {
    private static final String ANDROID_BASE_PLUGIN_ID = "com.android.base";
    private static final List<String> ANDROID_PLUGIN_IDS;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public Utils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static String getConfigName(String sourceSetName, String type) {
        String baseName = ScriptBytecodeAdapter.compareEqual((Object)sourceSetName, (Object)SourceSet.MAIN_SOURCE_SET_NAME) ? "" : GUtil.toCamelCase((CharSequence)sourceSetName);
        return StringUtils.uncapitalize((String)StringGroovyMethods.plus((String)baseName, (CharSequence)StringUtils.capitalize((String)type)));
    }

    public static String getSourceSetSubstringForTaskNames(String sourceSetName) {
        return ScriptBytecodeAdapter.compareEqual((Object)sourceSetName, (Object)SourceSet.MAIN_SOURCE_SET_NAME) ? "" : GUtil.toCamelCase((CharSequence)sourceSetName);
    }

    public static boolean isAndroidProject(Project project) {
        Reference project2 = new Reference((Object)project);
        public final class _isAndroidProject_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference project;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _isAndroidProject_closure1(Object _outerInstance, Object _thisObject, Reference project) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.project = reference = project;
            }

            public Object doCall(String pluginId) {
                return ((Project)this.project.get()).getPlugins().hasPlugin(pluginId);
            }

            public Object call(String pluginId) {
                return this.doCall(pluginId);
            }

            @Generated
            public Project getProject() {
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isAndroidProject_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return ((Project)project2.get()).getPlugins().hasPlugin(ANDROID_BASE_PLUGIN_ID) || DefaultGroovyMethods.any(ANDROID_PLUGIN_IDS, (Closure)new _isAndroidProject_closure1(Utils.class, Utils.class, project2));
    }

    public static String getKotlinAndroidCompileTaskName(Project project, String variantName) {
        Preconditions.checkState((boolean)Utils.isAndroidProject(project));
        return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"compile", (CharSequence)GUtil.toCamelCase((CharSequence)variantName)), (CharSequence)"Kotlin");
    }

    public static int compareGradleVersion(Project project, String target) {
        Matcher gv = Utils.parseVersionString(project.getGradle().getGradleVersion());
        Matcher tv = Utils.parseVersionString(target);
        int majorVersionDiff = DefaultTypeTransformation.intUnbox((Object)NumberNumberMinus.minus((Number)StringGroovyMethods.toInteger((CharSequence)gv.group(1)), (Number)StringGroovyMethods.toInteger((CharSequence)tv.group(1))));
        if (majorVersionDiff != 0) {
            return majorVersionDiff;
        }
        return DefaultTypeTransformation.intUnbox((Object)NumberNumberMinus.minus((Number)StringGroovyMethods.toInteger((CharSequence)gv.group(2)), (Number)StringGroovyMethods.toInteger((CharSequence)tv.group(2))));
    }

    public static boolean isTest(String sourceSetOrVariantName) {
        return ScriptBytecodeAdapter.compareEqual((Object)sourceSetOrVariantName, (Object)"test") || sourceSetOrVariantName.toLowerCase().contains("androidtest") || sourceSetOrVariantName.toLowerCase().contains("unittest");
    }

    /*
     * WARNING - void declaration
     */
    public static void addToIdeSources(Project project, boolean isTest, File f, boolean isGenerated) {
        void var2_2;
        Reference project2 = new Reference((Object)project);
        Reference isTest2 = new Reference((Object)isTest);
        Reference f2 = new Reference((Object)var2_2);
        Reference isGenerated2 = new Reference((Object)isGenerated);
        public final class _addToIdeSources_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference isTest;
            private /* synthetic */ Reference f;
            private /* synthetic */ Reference isGenerated;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addToIdeSources_closure2(Object _outerInstance, Object _thisObject, Reference project, Reference isTest, Reference f, Reference isGenerated) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.project = reference4 = project;
                this.isTest = reference3 = isTest;
                this.f = reference2 = f;
                this.isGenerated = reference = isGenerated;
            }

            public Object doCall(Object it) {
                IdeaModel model = (IdeaModel)ScriptBytecodeAdapter.castToType((Object)((Project)this.project.get()).getExtensions().findByType(IdeaModel.class), IdeaModel.class);
                if (DefaultTypeTransformation.booleanUnbox((Object)this.isTest.get())) {
                    Set set = DefaultGroovyMethods.plus((Set)model.getModule().getTestSourceDirs(), (Object)this.f.get());
                    model.getModule().setTestSourceDirs(set);
                } else {
                    Set set = DefaultGroovyMethods.plus((Set)model.getModule().getSourceDirs(), (Object)this.f.get());
                    model.getModule().setSourceDirs(set);
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)this.isGenerated.get())) {
                    Set set = DefaultGroovyMethods.plus((Set)model.getModule().getGeneratedSourceDirs(), (Object)this.f.get());
                    model.getModule().setGeneratedSourceDirs(set);
                }
                public final class _closure3
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference f;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure3(Object _outerInstance, Object _thisObject, Reference f) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.f = reference = f;
                    }

                    public Object doCall(Object it) {
                        public final class _closure4
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference f;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure4(Object _outerInstance, Object _thisObject, Reference f) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.f = reference = f;
                            }

                            public Object doCall(Object it) {
                                return ((File)this.f.get()).mkdirs();
                            }

                            @Generated
                            public File getF() {
                                return (File)ScriptBytecodeAdapter.castToType((Object)this.f.get(), File.class);
                            }

                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure4.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        return ((GenerateIdeaModule)it).doFirst((Closure)new _closure4((Object)this, this.getThisObject(), this.f));
                    }

                    @Generated
                    public File getF() {
                        return (File)ScriptBytecodeAdapter.castToType((Object)this.f.get(), File.class);
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure3.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return DefaultGroovyMethods.each((Set)((Project)this.project.get()).getTasks().withType(GenerateIdeaModule.class), (Closure)new _closure3((Object)this, this.getThisObject(), this.f));
            }

            @Generated
            public Project getProject() {
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            @Generated
            public boolean getIsTest() {
                return DefaultTypeTransformation.booleanUnbox((Object)this.isTest.get());
            }

            @Generated
            public File getF() {
                return (File)ScriptBytecodeAdapter.castToType((Object)this.f.get(), File.class);
            }

            @Generated
            public boolean getIsGenerated() {
                return DefaultTypeTransformation.booleanUnbox((Object)this.isGenerated.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addToIdeSources_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ((Project)project2.get()).getPlugins().withId("idea", (Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _addToIdeSources_closure2(Utils.class, Utils.class, project2, isTest2, f2, isGenerated2)), Action.class));
    }

    private static Matcher parseVersionString(String version) {
        Matcher matcher = (Matcher)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)version, (Object)"(\\d*)\\.(\\d*).*"), Matcher.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)matcher) || !matcher.matches()) {
            throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{version}, new String[]{"Failed to parse version \"", "\""})));
        }
        return matcher;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Utils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        List list;
        ANDROID_PLUGIN_IDS = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"android", "android-library", "com.android.application", "com.android.feature", "com.android.instantapp", "com.android.library", "com.android.test"});
    }
}

