/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle.skaffold;

import com.google.cloud.tools.jib.gradle.ExtraDirectoryParameters;
import com.google.cloud.tools.jib.gradle.JibExtension;
import com.google.cloud.tools.jib.gradle.skaffold.SkaffoldWatchParameters;
import com.google.cloud.tools.jib.plugins.common.SkaffoldFilesOutput;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.StartParameter;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskAction;

public class FilesTaskV2
extends DefaultTask {
    private final SkaffoldFilesOutput skaffoldFilesOutput = new SkaffoldFilesOutput();
    @Nullable
    private JibExtension jibExtension;

    public FilesTaskV2 setJibExtension(JibExtension jibExtension) {
        this.jibExtension = jibExtension;
        return this;
    }

    @TaskAction
    public void listFiles() throws IOException {
        Preconditions.checkNotNull((Object)this.jibExtension);
        Project project = this.getProject();
        if (project != project.getRootProject()) {
            this.addGradleFiles(project.getRootProject());
        }
        this.addProjectFiles(project);
        List extraDirectories = this.jibExtension.getExtraDirectories().getPaths().stream().map(ExtraDirectoryParameters::getFrom).collect(Collectors.toList());
        extraDirectories.stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).forEach(this.skaffoldFilesOutput::addInput);
        Set<ProjectDependency> projectDependencies = this.findProjectDependencies(project);
        HashSet<File> projectDependencyJars = new HashSet<File>();
        for (ProjectDependency projectDependency : projectDependencies) {
            Project dependentProject = this.getDependentProject(projectDependency);
            this.addProjectFiles(dependentProject);
            String configurationName = projectDependency.getTargetConfiguration();
            if (configurationName == null) {
                configurationName = "default";
            }
            for (Configuration targetConfiguration : dependentProject.getConfigurations().getByName(configurationName).getHierarchy()) {
                for (PublishArtifact artifact : targetConfiguration.getArtifacts()) {
                    projectDependencyJars.add(artifact.getFile());
                }
            }
        }
        for (File file : project.getConfigurations().getByName((String)this.jibExtension.getConfigurationName().get())) {
            if (projectDependencyJars.contains(file) || !file.toString().contains("SNAPSHOT")) continue;
            this.skaffoldFilesOutput.addInput(file.toPath());
            projectDependencyJars.add(file);
        }
        SkaffoldWatchParameters watch = this.jibExtension.getSkaffold().getWatch();
        watch.getBuildIncludes().forEach(this.skaffoldFilesOutput::addBuild);
        watch.getIncludes().forEach(this.skaffoldFilesOutput::addInput);
        watch.getExcludes().forEach(this.skaffoldFilesOutput::addIgnore);
        System.out.println();
        System.out.println("BEGIN JIB JSON");
        System.out.println(this.skaffoldFilesOutput.getJsonString());
    }

    private void addGradleFiles(Project project) {
        Path projectPath = project.getProjectDir().toPath();
        this.skaffoldFilesOutput.addBuild(project.getBuildFile().toPath());
        this.addSettingsFile(project, projectPath);
        if (Files.exists(projectPath.resolve("gradle.properties"), new LinkOption[0])) {
            this.skaffoldFilesOutput.addBuild(projectPath.resolve("gradle.properties"));
        }
    }

    private void addSettingsFile(Project project, Path projectPath) {
        boolean settingsFileAdded = false;
        try {
            StartParameter startParameter = project.getGradle().getStartParameter();
            Method getSettingsFileMethod = startParameter.getClass().getMethod("getSettingsFile", new Class[0]);
            File settingsFile = (File)getSettingsFileMethod.invoke((Object)startParameter, new Object[0]);
            if (settingsFile != null) {
                this.skaffoldFilesOutput.addBuild(settingsFile.toPath());
                settingsFileAdded = true;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        if (!settingsFileAdded && Files.exists(projectPath.resolve("settings.gradle"), new LinkOption[0])) {
            this.skaffoldFilesOutput.addBuild(projectPath.resolve("settings.gradle"));
        }
    }

    private void addProjectFiles(Project project) {
        SourceSet mainSourceSet;
        this.addGradleFiles(project);
        SourceSetContainer sourceSetContainer = (SourceSetContainer)project.getExtensions().findByType(SourceSetContainer.class);
        if (sourceSetContainer != null && (mainSourceSet = (SourceSet)sourceSetContainer.findByName("main")) != null) {
            mainSourceSet.getAllSource().getSourceDirectories().forEach(sourceDirectory -> {
                if (sourceDirectory.exists()) {
                    this.skaffoldFilesOutput.addInput(sourceDirectory.toPath());
                }
            });
        }
    }

    private Set<ProjectDependency> findProjectDependencies(Project project) {
        Preconditions.checkNotNull((Object)this.jibExtension);
        HashSet<ProjectDependency> projectDependencies = new HashSet<ProjectDependency>();
        ArrayDeque<Project> projects = new ArrayDeque<Project>();
        projects.push(project);
        String configurationName = (String)this.jibExtension.getConfigurationName().get();
        while (!projects.isEmpty()) {
            Project currentProject = (Project)projects.pop();
            Configuration runtimeClasspath = (Configuration)currentProject.getConfigurations().findByName(configurationName);
            if (runtimeClasspath == null) continue;
            for (Configuration configuration : runtimeClasspath.getHierarchy()) {
                for (Dependency dependency : configuration.getDependencies()) {
                    ProjectDependency projectDependency;
                    if (!(dependency instanceof ProjectDependency) || projectDependencies.contains(projectDependency = (ProjectDependency)dependency)) continue;
                    projects.push(this.getDependentProject(projectDependency));
                    projectDependencies.add(projectDependency);
                }
            }
        }
        return projectDependencies;
    }

    private Project getDependentProject(ProjectDependency projectDependency) {
        try {
            Method getDependencyProjectMethod = projectDependency.getClass().getMethod("getDependencyProject", new Class[0]);
            return (Project)getDependencyProjectMethod.invoke((Object)projectDependency, new Object[0]);
        }
        catch (NoSuchMethodException getDependencyProjectMethod) {
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to resolve dependent project from " + projectDependency, e);
        }
        try {
            Method getPathMethod = projectDependency.getClass().getMethod("getPath", new Class[0]);
            String path = (String)getPathMethod.invoke((Object)projectDependency, new Object[0]);
            return this.getProject().project(path);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to resolve dependent project from " + projectDependency, e);
        }
    }
}

