/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.http;

import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Consumer;

public class NotifyingOutputStream
extends OutputStream {
    private final OutputStream underlyingOutputStream;
    private final Consumer<Long> byteCountListener;
    private long byteCount = 0L;

    public NotifyingOutputStream(OutputStream underlyingOutputStream, Consumer<Long> byteCountListener) {
        this.underlyingOutputStream = underlyingOutputStream;
        this.byteCountListener = byteCountListener;
    }

    @Override
    public void write(int singleByte) throws IOException {
        this.underlyingOutputStream.write(singleByte);
        this.countAndCallListener(1);
    }

    @Override
    public void write(byte[] byteArray) throws IOException {
        this.underlyingOutputStream.write(byteArray);
        this.countAndCallListener(byteArray.length);
    }

    @Override
    public void write(byte[] byteArray, int offset, int length) throws IOException {
        this.underlyingOutputStream.write(byteArray, offset, length);
        this.countAndCallListener(length);
    }

    @Override
    public void flush() throws IOException {
        this.underlyingOutputStream.flush();
        this.countAndCallListener(0);
    }

    @Override
    public void close() throws IOException {
        this.underlyingOutputStream.close();
        this.countAndCallListener(0);
    }

    private void countAndCallListener(int written) {
        this.byteCount += (long)written;
        if (this.byteCount == 0L) {
            return;
        }
        this.byteCountListener.accept(this.byteCount);
        this.byteCount = 0L;
    }
}

