/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.LogEvent;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class MainClassFinder {
    public static Result find(List<Path> files, Consumer<LogEvent> logger) {
        ArrayList<String> mainClasses = new ArrayList<String>();
        for (Path file : files) {
            if (!Files.exists(file, new LinkOption[0])) {
                logger.accept(LogEvent.debug("MainClassFinder: " + file + " does not exist; ignoring"));
                continue;
            }
            if (!Files.isRegularFile(file, new LinkOption[0])) {
                logger.accept(LogEvent.debug("MainClassFinder: " + file + " is not a regular file; skipping"));
                continue;
            }
            if (!file.toString().endsWith(".class")) {
                logger.accept(LogEvent.debug("MainClassFinder: " + file + " is not a class file; skipping"));
                continue;
            }
            MainClassVisitor mainClassVisitor = new MainClassVisitor();
            try {
                InputStream classFileInputStream = Files.newInputStream(file, new OpenOption[0]);
                try {
                    ClassReader reader = new ClassReader(classFileInputStream);
                    reader.accept((ClassVisitor)mainClassVisitor, 0);
                    if (!mainClassVisitor.visitedMainClass) continue;
                    mainClasses.add(reader.getClassName().replace('/', '.'));
                }
                finally {
                    if (classFileInputStream == null) continue;
                    classFileInputStream.close();
                }
            }
            catch (IllegalArgumentException ex) {
                throw new UnsupportedOperationException("Check the full stace trace, and if the root cause is from ASM ClassReader about unsupported class file version, see https://github.com/GoogleContainerTools/jib/blob/master/docs/faq.md#i-am-seeing-unsupported-class-file-major-version-when-building", ex);
            }
            catch (ArrayIndexOutOfBoundsException ignored) {
                logger.accept(LogEvent.warn("Invalid class file found: " + file));
            }
            catch (IOException ignored) {
                logger.accept(LogEvent.warn("Could not read file: " + file));
            }
        }
        if (mainClasses.size() == 1) {
            return Result.success((String)mainClasses.get(0));
        }
        if (mainClasses.isEmpty()) {
            return Result.mainClassNotFound();
        }
        return Result.multipleMainClasses(mainClasses);
    }

    private static class MainClassVisitor
    extends ClassVisitor {
        private static final int JAVA_25_CLASS_VERSION = 69;
        private static final String MAIN_WITH_ARGS_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String[].class)});
        private static final String MAIN_NO_ARGS_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]);
        private static final int OPTIONAL_MODIFIERS = 135312;
        private boolean visitedMainClass;
        private int classVersion;

        private MainClassVisitor() {
            super(589824);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classVersion = version;
            super.visit(version, access, name, signature, superName, interfaces);
        }

        @Nullable
        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            boolean isValidDescriptor;
            if (!name.equals("main")) {
                return null;
            }
            if ((access & 2) != 0) {
                return null;
            }
            if (this.classVersion < 69) {
                int requiredAccess = 9;
                if ((access & 0xFFFDEF6F) == requiredAccess && descriptor.equals(MAIN_WITH_ARGS_DESCRIPTOR)) {
                    this.visitedMainClass = true;
                }
                return null;
            }
            boolean bl = isValidDescriptor = descriptor.equals(MAIN_WITH_ARGS_DESCRIPTOR) || descriptor.equals(MAIN_NO_ARGS_DESCRIPTOR);
            if (!isValidDescriptor) {
                return null;
            }
            int relevantAccess = access & 0xFFFDEF6A;
            if (relevantAccess == 8 || relevantAccess == 0) {
                this.visitedMainClass = true;
            }
            return null;
        }
    }

    public static class Result {
        private final Type type;
        private final List<String> foundMainClasses;

        private static Result success(String foundMainClass) {
            return new Result(Type.MAIN_CLASS_FOUND, Collections.singletonList(foundMainClass));
        }

        private static Result mainClassNotFound() {
            return new Result(Type.MAIN_CLASS_NOT_FOUND, Collections.emptyList());
        }

        private static Result multipleMainClasses(List<String> foundMainClasses) {
            return new Result(Type.MULTIPLE_MAIN_CLASSES, foundMainClasses);
        }

        private Result(Type type, List<String> foundMainClasses) {
            this.foundMainClasses = foundMainClasses;
            this.type = type;
        }

        public String getFoundMainClass() {
            Preconditions.checkState((Type.MAIN_CLASS_FOUND == this.type ? 1 : 0) != 0);
            Preconditions.checkState((this.foundMainClasses.size() == 1 ? 1 : 0) != 0);
            return this.foundMainClasses.get(0);
        }

        public Type getType() {
            return this.type;
        }

        public List<String> getFoundMainClasses() {
            return this.foundMainClasses;
        }

        public static enum Type {
            MAIN_CLASS_FOUND,
            MAIN_CLASS_NOT_FOUND,
            MULTIPLE_MAIN_CLASSES;

        }
    }
}

