/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.gradle.BuildDockerTask;
import com.google.cloud.tools.jib.gradle.BuildImageTask;
import com.google.cloud.tools.jib.gradle.BuildTarTask;
import com.google.cloud.tools.jib.gradle.GradleProjectProperties;
import com.google.cloud.tools.jib.gradle.JibExtension;
import com.google.cloud.tools.jib.gradle.TaskCommon;
import com.google.cloud.tools.jib.gradle.skaffold.CheckJibVersionTask;
import com.google.cloud.tools.jib.gradle.skaffold.FilesTaskV2;
import com.google.cloud.tools.jib.gradle.skaffold.InitTask;
import com.google.cloud.tools.jib.gradle.skaffold.SyncMapTask;
import com.google.cloud.tools.jib.plugins.common.VersionChecker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.util.GradleVersion;

public class JibPlugin
implements Plugin<Project> {
    @VisibleForTesting
    static final GradleVersion GRADLE_MIN_VERSION = GradleVersion.version((String)"5.1");
    public static final String JIB_EXTENSION_NAME = "jib";
    public static final String BUILD_IMAGE_TASK_NAME = "jib";
    public static final String BUILD_TAR_TASK_NAME = "jibBuildTar";
    public static final String BUILD_DOCKER_TASK_NAME = "jibDockerBuild";
    public static final String SKAFFOLD_FILES_TASK_V2_NAME = "_jibSkaffoldFilesV2";
    public static final String SKAFFOLD_INIT_TASK_NAME = "_jibSkaffoldInit";
    public static final String SKAFFOLD_SYNC_MAP_TASK_NAME = "_jibSkaffoldSyncMap";
    public static final String SKAFFOLD_CHECK_REQUIRED_VERSION_TASK_NAME = "_skaffoldFailIfJibOutOfDate";
    public static final String REQUIRED_VERSION_PROPERTY_NAME = "jib.requiredVersion";

    private static void checkGradleVersion() {
        if (GRADLE_MIN_VERSION.compareTo(GradleVersion.current()) > 0) {
            throw new GradleException("Detected " + GradleVersion.current() + ", but jib requires " + GRADLE_MIN_VERSION + " or higher. You can upgrade by running 'gradle wrapper --gradle-version=" + GRADLE_MIN_VERSION.getVersion() + "'.");
        }
    }

    private static void checkJibVersion() {
        String requiredVersion = System.getProperty(REQUIRED_VERSION_PROPERTY_NAME);
        if (requiredVersion == null) {
            return;
        }
        String actualVersion = GradleProjectProperties.TOOL_VERSION;
        if (actualVersion == null) {
            throw new GradleException("Could not determine Jib plugin version");
        }
        VersionChecker<GradleVersion> checker = new VersionChecker<GradleVersion>(GradleVersion::version);
        if (!checker.compatibleVersion(requiredVersion, actualVersion)) {
            String failure = String.format("Jib plugin version is %s but is required to be %s", actualVersion, requiredVersion);
            throw new GradleException(failure);
        }
    }

    public void apply(Project project) {
        JibPlugin.checkGradleVersion();
        JibPlugin.checkJibVersion();
        JibExtension jibExtension = (JibExtension)project.getExtensions().create("jib", JibExtension.class, new Object[]{project});
        TaskContainer tasks = project.getTasks();
        TaskProvider buildImageTask = tasks.register("jib", BuildImageTask.class, task -> {
            task.setGroup("Jib");
            task.setDescription("Builds a container image to a registry.");
            task.setJibExtension(jibExtension);
        });
        TaskProvider buildDockerTask = tasks.register(BUILD_DOCKER_TASK_NAME, BuildDockerTask.class, task -> {
            task.setGroup("Jib");
            task.setDescription("Builds a container image to a Docker daemon.");
            task.setJibExtension(jibExtension);
        });
        TaskProvider buildTarTask = tasks.register(BUILD_TAR_TASK_NAME, BuildTarTask.class, task -> {
            task.setGroup("Jib");
            task.setDescription("Builds a container image to a tarball.");
            task.setJibExtension(jibExtension);
        });
        tasks.register(SKAFFOLD_FILES_TASK_V2_NAME, FilesTaskV2.class).configure(task -> task.setJibExtension(jibExtension));
        tasks.register(SKAFFOLD_INIT_TASK_NAME, InitTask.class).configure(task -> task.setJibExtension(jibExtension));
        TaskProvider syncMapTask = tasks.register(SKAFFOLD_SYNC_MAP_TASK_NAME, SyncMapTask.class, task -> task.setJibExtension(jibExtension));
        tasks.register(SKAFFOLD_CHECK_REQUIRED_VERSION_TASK_NAME, CheckJibVersionTask.class);
        project.afterEvaluate(projectAfterEvaluation -> {
            TaskProvider<Task> warTask = TaskCommon.getWarTaskProvider(projectAfterEvaluation);
            TaskProvider<Task> bootWarTask = TaskCommon.getBootWarTaskProvider(projectAfterEvaluation);
            ArrayList<Object> jibDependencies = new ArrayList<Object>();
            if (warTask != null || bootWarTask != null) {
                if (warTask != null) {
                    jibDependencies.add(warTask);
                }
                if (bootWarTask != null) {
                    jibDependencies.add(bootWarTask);
                }
            } else if ("packaged".equals(jibExtension.getContainerizingMode())) {
                TaskProvider jarTask = projectAfterEvaluation.getTasks().named("jar");
                jibDependencies.add(jarTask);
                if (projectAfterEvaluation.getPlugins().hasPlugin("org.springframework.boot")) {
                    String jarPath;
                    String bootJarPath;
                    Task bootJarTask = projectAfterEvaluation.getTasks().getByName("bootJar");
                    if (bootJarTask.getEnabled() && (bootJarPath = bootJarTask.getOutputs().getFiles().getAsPath()).equals(jarPath = ((Task)jarTask.get()).getOutputs().getFiles().getAsPath())) {
                        if (!((Task)jarTask.get()).getEnabled()) {
                            ((Jar)jarTask.get()).getArchiveClassifier().set((Object)"original");
                        } else {
                            throw new GradleException("Both 'bootJar' and 'jar' tasks are enabled, but they write their jar file into the same location at " + jarPath + ". Did you forget to set 'archiveClassifier' on either task?");
                        }
                    }
                    ((Task)jarTask.get()).setEnabled(true);
                }
            }
            SourceSet mainSourceSet = (SourceSet)((SourceSetContainer)projectAfterEvaluation.getExtensions().getByType(SourceSetContainer.class)).getByName("main");
            jibDependencies.add(mainSourceSet.getRuntimeClasspath());
            jibDependencies.add(projectAfterEvaluation.getConfigurations().getByName((String)jibExtension.getConfigurationName().get()));
            ImmutableSet jibTaskProviders = ImmutableSet.of((Object)buildImageTask, (Object)buildDockerTask, (Object)buildTarTask, (Object)syncMapTask);
            jibTaskProviders.forEach(provider -> provider.configure(task -> jibDependencies.forEach(dep -> task.dependsOn(new Object[]{dep}))));
        });
    }
}

