/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.plugins.common.RawConfiguration;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;

public class ExtraDirectoryParameters
implements RawConfiguration.ExtraDirectoriesConfiguration {
    private Project project;
    private Property<Path> from;
    private Property<String> into;
    private ListProperty<String> includes;
    private ListProperty<String> excludes;

    @Inject
    public ExtraDirectoryParameters(ObjectFactory objects, Project project) {
        this.project = project;
        this.from = objects.property(Path.class).value((Object)Paths.get("", new String[0]));
        this.into = objects.property(String.class).value((Object)"/");
        this.includes = objects.listProperty(String.class).empty();
        this.excludes = objects.listProperty(String.class).empty();
    }

    ExtraDirectoryParameters(ObjectFactory objects, Project project, Path from, String into) {
        this(objects, project);
        this.from = objects.property(Path.class).value((Object)from);
        this.into = objects.property(String.class).value((Object)into);
    }

    @Input
    public String getFromString() {
        return ((Path)this.from.get()).toString();
    }

    @Override
    @Internal
    public Path getFrom() {
        return (Path)this.from.get();
    }

    public void setFrom(Object from) {
        this.from.set((Object)this.project.file(from).toPath());
    }

    public void setFrom(Provider<Object> from) {
        this.from.set(from.map(obj -> this.project.file(obj).toPath()));
    }

    @Override
    @Input
    public String getInto() {
        return (String)this.into.get();
    }

    public void setInto(String into) {
        this.into.set((Object)into);
    }

    public void setInto(Provider<String> into) {
        this.into.set(into);
    }

    @Input
    public ListProperty<String> getIncludes() {
        return this.includes;
    }

    @Input
    public ListProperty<String> getExcludes() {
        return this.excludes;
    }

    @Override
    @Internal
    public List<String> getIncludesList() {
        return (List)this.includes.get();
    }

    @Override
    @Internal
    public List<String> getExcludesList() {
        return (List)this.excludes.get();
    }
}

