/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.plugins.common.AuthProperty;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;

public class AuthParameters
implements AuthProperty {
    private Property<String> username;
    private Property<String> password;
    private final String source;

    @Inject
    public AuthParameters(ObjectFactory objectFactory, String source) {
        this.username = objectFactory.property(String.class);
        this.password = objectFactory.property(String.class);
        this.source = source;
    }

    @Override
    @Input
    @Optional
    @Nullable
    public String getUsername() {
        return (String)this.username.getOrNull();
    }

    public void setUsername(String username) {
        this.username.set((Object)username);
    }

    public void setUsername(Provider<String> username) {
        this.username.set(username);
    }

    @Override
    @Input
    @Optional
    @Nullable
    public String getPassword() {
        return (String)this.password.getOrNull();
    }

    public void setPassword(String password) {
        this.password.set((Object)password);
    }

    public void setPassword(Provider<String> password) {
        this.password.set(password);
    }

    @Override
    @Internal
    public String getAuthDescriptor() {
        return this.source;
    }

    @Override
    @Internal
    public String getUsernameDescriptor() {
        return this.getAuthDescriptor() + ".username";
    }

    @Override
    @Internal
    public String getPasswordDescriptor() {
        return this.getAuthDescriptor() + ".password";
    }
}

