/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common.logging;

import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.plugins.common.logging.ConsoleLogger;
import com.google.cloud.tools.jib.plugins.common.logging.SingleThreadedExecutor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

class AnsiLoggerWithFooter
implements ConsoleLogger {
    private static final int MAX_FOOTER_WIDTH = 50;
    private static final String CURSOR_UP_SEQUENCE_TEMPLATE = "\u001b[%dA";
    private static final String CURSOR_UP_SEQUENCE = String.format("\u001b[%dA", 1);
    private static final String ERASE_DISPLAY_BELOW = "\u001b[0J";
    private static final String BOLD = "\u001b[1m";
    private static final String UNBOLD = "\u001b[0m";
    private final ImmutableMap<LogEvent.Level, Consumer<String>> messageConsumers;
    private final Consumer<String> lifecycleConsumer;
    private final SingleThreadedExecutor singleThreadedExecutor;
    private List<String> footerLines = Collections.emptyList();
    private boolean enableTwoCursorUpJump;

    @VisibleForTesting
    static List<String> truncateToMaxWidth(List<String> lines) {
        ArrayList<String> truncatedLines = new ArrayList<String>();
        for (String line : lines) {
            if (line.length() > 50) {
                truncatedLines.add(line.substring(0, 47) + "...");
                continue;
            }
            truncatedLines.add(line);
        }
        return truncatedLines;
    }

    AnsiLoggerWithFooter(ImmutableMap<LogEvent.Level, Consumer<String>> messageConsumers, SingleThreadedExecutor singleThreadedExecutor, boolean enableTwoCursorUpJump) {
        Preconditions.checkArgument((boolean)messageConsumers.containsKey((Object)LogEvent.Level.LIFECYCLE), (Object)"Cannot construct AnsiLoggerFooter without LIFECYCLE message consumer");
        this.messageConsumers = messageConsumers;
        this.lifecycleConsumer = (Consumer)Preconditions.checkNotNull((Object)((Consumer)messageConsumers.get((Object)LogEvent.Level.LIFECYCLE)));
        this.singleThreadedExecutor = singleThreadedExecutor;
        this.enableTwoCursorUpJump = enableTwoCursorUpJump;
    }

    @Override
    public void log(LogEvent.Level logLevel, String message) {
        if (!this.messageConsumers.containsKey((Object)logLevel)) {
            return;
        }
        Consumer messageConsumer = (Consumer)this.messageConsumers.get((Object)logLevel);
        this.singleThreadedExecutor.execute(() -> {
            boolean didErase = this.eraseFooter();
            if (didErase) {
                if (this.enableTwoCursorUpJump) {
                    messageConsumer.accept(String.format(CURSOR_UP_SEQUENCE_TEMPLATE, 2));
                    messageConsumer.accept(message);
                } else {
                    messageConsumer.accept(CURSOR_UP_SEQUENCE + message);
                }
            } else {
                messageConsumer.accept(message);
            }
            this.printInBold(this.footerLines);
        });
    }

    @Override
    public void setFooter(List<String> newFooterLines) {
        List<String> truncatedNewFooterLines = AnsiLoggerWithFooter.truncateToMaxWidth(newFooterLines);
        if (truncatedNewFooterLines.equals(this.footerLines)) {
            return;
        }
        this.singleThreadedExecutor.execute(() -> {
            boolean didErase = this.eraseFooter();
            if (didErase) {
                if (this.enableTwoCursorUpJump) {
                    this.lifecycleConsumer.accept(String.format(CURSOR_UP_SEQUENCE_TEMPLATE, 2));
                    this.printInBold(truncatedNewFooterLines);
                } else {
                    this.printInBold(truncatedNewFooterLines, CURSOR_UP_SEQUENCE);
                }
            } else {
                this.printInBold(truncatedNewFooterLines);
            }
            this.footerLines = truncatedNewFooterLines;
        });
    }

    private boolean eraseFooter() {
        if (this.footerLines.isEmpty()) {
            return false;
        }
        StringBuilder footerEraserBuilder = new StringBuilder();
        footerEraserBuilder.append(String.format(CURSOR_UP_SEQUENCE_TEMPLATE, this.footerLines.size()));
        footerEraserBuilder.append(ERASE_DISPLAY_BELOW);
        this.lifecycleConsumer.accept(footerEraserBuilder.toString());
        return true;
    }

    private void printInBold(List<String> lines) {
        this.printInBold(lines, "");
    }

    private void printInBold(List<String> lines, String firstLinePrefix) {
        for (int i = 0; i < lines.size(); ++i) {
            this.lifecycleConsumer.accept((i == 0 ? firstLinePrefix : "") + BOLD + lines.get(i) + UNBOLD);
        }
    }
}

