/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.google.cloud.tools.jib.event.events.TimerEvent;
import java.util.function.Consumer;

public class TimerEventHandler
implements Consumer<TimerEvent> {
    private final Consumer<String> logMessageConsumer;

    private static StringBuilder getTabs(TimerEvent.Timer timer) {
        StringBuilder tabs = new StringBuilder();
        while (timer.getParent().isPresent()) {
            tabs.append("\t");
            timer = timer.getParent().get();
        }
        return tabs;
    }

    private static String buildLogMessage(TimerEvent timerEvent) {
        StringBuilder logMessageBuilder = TimerEventHandler.getTabs(timerEvent.getTimer());
        if (timerEvent.getState() == TimerEvent.State.START) {
            return logMessageBuilder.append("TIMING\t").append(timerEvent.getDescription()).toString();
        }
        return logMessageBuilder.append("TIMED\t").append(timerEvent.getDescription()).append(" : ").append((double)(timerEvent.getDuration().toNanos() / 1000L) / 1000.0).append(" ms").toString();
    }

    public TimerEventHandler(Consumer<String> logMessageConsumer) {
        this.logMessageConsumer = logMessageConsumer;
    }

    @Override
    public void accept(TimerEvent timerEvent) {
        this.logMessageConsumer.accept(TimerEventHandler.buildLogMessage(timerEvent));
    }
}

