/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.cloud.tools.jib.json.JsonTemplate;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;

public class JsonTemplateMapper {
    private static final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule());

    public static <T extends JsonTemplate> T readJsonFromFile(Path jsonFile, Class<T> templateClass) throws IOException {
        try (InputStream fileIn = Files.newInputStream(jsonFile, new OpenOption[0]);){
            JsonTemplate jsonTemplate = (JsonTemplate)objectMapper.readValue(fileIn, templateClass);
            return (T)jsonTemplate;
        }
    }

    public static <T extends JsonTemplate> T readJsonFromFileWithLock(Path jsonFile, Class<T> templateClass) throws IOException {
        FileChannel channel = FileChannel.open(jsonFile, StandardOpenOption.READ);
        channel.lock(0L, Long.MAX_VALUE, true);
        try (InputStream inputStream = Channels.newInputStream(channel);){
            JsonTemplate jsonTemplate = (JsonTemplate)objectMapper.readValue(inputStream, templateClass);
            return (T)jsonTemplate;
        }
    }

    public static <T extends JsonTemplate> T readJson(InputStream jsonStream, Class<T> templateClass) throws IOException {
        return (T)((JsonTemplate)objectMapper.readValue(jsonStream, templateClass));
    }

    public static <T extends JsonTemplate> T readJson(String jsonString, Class<T> templateClass) throws IOException {
        return (T)((JsonTemplate)objectMapper.readValue(jsonString, templateClass));
    }

    public static <T extends JsonTemplate> T readJson(byte[] jsonBytes, Class<T> templateClass) throws IOException {
        return (T)((JsonTemplate)objectMapper.readValue(jsonBytes, templateClass));
    }

    public static <T extends JsonTemplate> List<T> readListOfJson(String jsonString, Class<T> templateClass) throws IOException {
        CollectionType listType = objectMapper.getTypeFactory().constructCollectionType(List.class, templateClass);
        return (List)objectMapper.readValue(jsonString, (JavaType)listType);
    }

    public static String toUtf8String(JsonTemplate template) throws IOException {
        return JsonTemplateMapper.toUtf8String((Object)template);
    }

    public static String toUtf8String(List<? extends JsonTemplate> templates) throws IOException {
        return JsonTemplateMapper.toUtf8String(templates);
    }

    public static byte[] toByteArray(JsonTemplate template) throws IOException {
        return JsonTemplateMapper.toByteArray((Object)template);
    }

    public static byte[] toByteArray(List<? extends JsonTemplate> templates) throws IOException {
        return JsonTemplateMapper.toByteArray(templates);
    }

    public static void writeTo(JsonTemplate template, OutputStream out) throws IOException {
        JsonTemplateMapper.writeTo((Object)template, out);
    }

    public static void writeTo(List<? extends JsonTemplate> templates, OutputStream out) throws IOException {
        JsonTemplateMapper.writeTo(templates, out);
    }

    private static String toUtf8String(Object template) throws IOException {
        return new String(JsonTemplateMapper.toByteArray(template), StandardCharsets.UTF_8);
    }

    private static byte[] toByteArray(Object template) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonTemplateMapper.writeTo(template, (OutputStream)out);
        return out.toByteArray();
    }

    private static void writeTo(Object template, OutputStream out) throws IOException {
        objectMapper.writeValue(out, template);
    }

    private JsonTemplateMapper() {
    }
}

