/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image.json;

import com.google.api.client.util.Preconditions;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.hash.Digests;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ImageToJsonTranslator;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.image.json.V22ManifestListTemplate;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import java.io.IOException;
import java.util.List;

public class ManifestListGenerator {
    private final List<Image> images;

    public ManifestListGenerator(List<Image> images) {
        this.images = images;
    }

    public <T extends BuildableManifestTemplate> ManifestTemplate getManifestListTemplate(Class<T> manifestTemplateClass) throws IOException {
        Preconditions.checkArgument((manifestTemplateClass == V22ManifestTemplate.class ? 1 : 0) != 0, (Object)"Build an OCI image index is not yet supported");
        Preconditions.checkState((!this.images.isEmpty() ? 1 : 0) != 0, (Object)"no images given");
        V22ManifestListTemplate manifestList = new V22ManifestListTemplate();
        for (Image image : this.images) {
            ImageToJsonTranslator imageTranslator = new ImageToJsonTranslator(image);
            BlobDescriptor configDescriptor = Digests.computeDigest(imageTranslator.getContainerConfiguration());
            T manifestTemplate = imageTranslator.getManifestTemplate(manifestTemplateClass, configDescriptor);
            BlobDescriptor manifestDescriptor = Digests.computeDigest(manifestTemplate);
            V22ManifestListTemplate.ManifestDescriptorTemplate manifest = new V22ManifestListTemplate.ManifestDescriptorTemplate();
            manifest.setMediaType(manifestTemplate.getManifestMediaType());
            manifest.setSize(manifestDescriptor.getSize());
            manifest.setDigest(manifestDescriptor.getDigest().toString());
            manifest.setPlatform(image.getArchitecture(), image.getOs());
            manifestList.addManifest(manifest);
        }
        return manifestList;
    }
}

