/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import java.nio.file.Path;
import java.nio.file.Paths;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;

public class OutputPathsParameters {
    private final Project project;
    private Path digest;
    private Path tar;
    private Path imageId;
    private Path imageJson;

    @Inject
    public OutputPathsParameters(Project project) {
        this.project = project;
        this.digest = project.getBuildDir().toPath().resolve("jib-image.digest");
        this.imageId = project.getBuildDir().toPath().resolve("jib-image.id");
        this.imageJson = project.getBuildDir().toPath().resolve("jib-image.json");
        this.tar = project.getBuildDir().toPath().resolve("jib-image.tar");
    }

    @Input
    public String getDigest() {
        return this.getRelativeToProjectRoot(this.digest, "jib.outputPaths.digest").toString();
    }

    @Internal
    Path getDigestPath() {
        return this.getRelativeToProjectRoot(this.digest, "jib.outputPaths.digest");
    }

    public void setDigest(String digest) {
        this.digest = Paths.get(digest, new String[0]);
    }

    @Input
    public String getImageId() {
        return this.getRelativeToProjectRoot(this.imageId, "jib.outputPaths.imageId").toString();
    }

    @Internal
    Path getImageIdPath() {
        return this.getRelativeToProjectRoot(this.imageId, "jib.outputPaths.imageId");
    }

    public void setImageId(String id) {
        this.imageId = Paths.get(id, new String[0]);
    }

    @Input
    public String getImageJson() {
        return this.getRelativeToProjectRoot(this.imageJson, "jib.outputPaths.imageJson").toString();
    }

    @Internal
    Path getImageJsonPath() {
        return this.getRelativeToProjectRoot(this.imageJson, "jib.outputPaths.imageJson");
    }

    public void setImageJson(String imageJson) {
        this.imageJson = Paths.get(imageJson, new String[0]);
    }

    @Input
    public String getTar() {
        return this.getRelativeToProjectRoot(this.tar, "jib.outputPaths.tar").toString();
    }

    @Internal
    Path getTarPath() {
        return this.getRelativeToProjectRoot(this.tar, "jib.outputPaths.tar");
    }

    public void setTar(String tar) {
        this.tar = Paths.get(tar, new String[0]);
    }

    private Path getRelativeToProjectRoot(Path configuration, String propertyName) {
        String property = System.getProperty(propertyName);
        Path path = property != null ? Paths.get(property, new String[0]) : configuration;
        return path.isAbsolute() ? path : this.project.getProjectDir().toPath().resolve(path);
    }
}

