/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Parser;
import com.github.jknack.handlebars.ParserFactory;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.internal.HbsErrorReporter;
import com.github.jknack.handlebars.internal.HbsErrorStrategy;
import com.github.jknack.handlebars.internal.HbsLexer;
import com.github.jknack.handlebars.internal.HbsParser;
import com.github.jknack.handlebars.internal.MustacheSpec;
import com.github.jknack.handlebars.internal.TemplateBuilder;
import com.github.jknack.handlebars.internal.WhiteSpaceControl;
import com.github.jknack.handlebars.internal.antlr.ANTLRErrorListener;
import com.github.jknack.handlebars.internal.antlr.CharStream;
import com.github.jknack.handlebars.internal.antlr.CharStreams;
import com.github.jknack.handlebars.internal.antlr.CommonToken;
import com.github.jknack.handlebars.internal.antlr.CommonTokenStream;
import com.github.jknack.handlebars.internal.antlr.LexerNoViableAltException;
import com.github.jknack.handlebars.internal.antlr.Recognizer;
import com.github.jknack.handlebars.internal.antlr.atn.ParserATNSimulator;
import com.github.jknack.handlebars.internal.antlr.atn.PredictionMode;
import com.github.jknack.handlebars.internal.antlr.misc.Interval;
import com.github.jknack.handlebars.internal.antlr.tree.ParseTreeWalker;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HbsParserFactory
implements ParserFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public Parser create(final Handlebars handlebars, final String startDelimiter, final String endDelimiter) {
        return new Parser(){

            @Override
            public Template parse(TemplateSource source) throws IOException {
                HbsParserFactory.this.logger.debug("About to parse: {}", (Object)source);
                String sourceName = source.filename();
                final HbsErrorReporter errorReporter = new HbsErrorReporter(sourceName);
                String content = source.content(handlebars.getCharset());
                HbsLexer lexer = HbsParserFactory.this.newLexer(CharStreams.fromString(content, sourceName), startDelimiter, endDelimiter);
                HbsParserFactory.this.configure(lexer, errorReporter);
                final HbsParser parser = HbsParserFactory.this.newParser(lexer);
                HbsParserFactory.this.configure(parser, errorReporter);
                HbsParserFactory.this.logger.debug("Building AST");
                HbsParser.TemplateContext tree = parser.template();
                if (handlebars.prettyPrint()) {
                    HbsParserFactory.this.logger.debug("Applying Mustache spec");
                    new ParseTreeWalker().walk(new MustacheSpec(), tree);
                }
                if (lexer.whiteSpaceControl) {
                    HbsParserFactory.this.logger.debug("Applying white spaces control");
                    new ParseTreeWalker().walk(new WhiteSpaceControl(), tree);
                }
                TemplateBuilder builder = new TemplateBuilder(handlebars, source){

                    @Override
                    protected void reportError(CommonToken offendingToken, int line, int column, String message) {
                        errorReporter.syntaxError(parser, offendingToken, line, column, message, null);
                    }
                };
                HbsParserFactory.this.logger.debug("Creating templates");
                Template template = builder.visit(tree);
                return template;
            }
        };
    }

    private HbsLexer newLexer(CharStream stream, String startDelimiter, String endDelimiter) {
        return new HbsLexer(stream, startDelimiter, endDelimiter){

            @Override
            public void notifyListeners(LexerNoViableAltException e) {
                String text = this._input.getText(Interval.of(this._tokenStartCharIndex, this._input.index()));
                String msg = "found: '" + this.getErrorDisplay(text) + "'";
                ANTLRErrorListener listener = this.getErrorListenerDispatch();
                listener.syntaxError(this, null, this._tokenStartLine, this._tokenStartCharPositionInLine, msg, e);
            }

            @Override
            public void recover(LexerNoViableAltException e) {
                throw new IllegalArgumentException(e);
            }
        };
    }

    private HbsParser newParser(final HbsLexer lexer) {
        return new HbsParser(new CommonTokenStream(lexer)){

            @Override
            void setStart(String start) {
                lexer.start = start;
            }

            @Override
            void setEnd(String end) {
                lexer.end = end;
            }
        };
    }

    private void configure(HbsParser parser, ANTLRErrorListener errorReporter) {
        this.configure((Recognizer<?, ?>)parser, errorReporter);
        parser.setErrorHandler(new HbsErrorStrategy());
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
    }

    private void configure(Recognizer<?, ?> recognizer, ANTLRErrorListener errorReporter) {
        recognizer.removeErrorListeners();
        recognizer.addErrorListener(errorReporter);
    }
}

