/*
 * Decompiled with CFR 0.152.
 */
package icu.azim;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import icu.azim.AzimDPExtension;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Copy;

public class AzimDP
implements Plugin<Project> {
    public void apply(Project project) {
        AzimDPExtension settings = (AzimDPExtension)project.getExtensions().create("azimdp", AzimDPExtension.class, new Object[0]);
        project.task("generate-dependency-list").doLast(task -> {
            ArrayList excluded = new ArrayList();
            Logger logger = project.getLogger();
            logger.info("Top-level dependencies: ");
            task.getProject().getConfigurations().getByName("runtimeClasspath").getResolvedConfiguration().getFirstLevelModuleDependencies().forEach(resolvedDependency -> {
                if (this.shouldExclude(settings.getExclude(), settings.isIgnoreVersions(), (ResolvedDependency)resolvedDependency)) {
                    logger.info("Excluding " + this.resolvedToString((ResolvedDependency)resolvedDependency) + " and it's dependencies");
                    excluded.addAll(this.flatten((ResolvedDependency)resolvedDependency));
                } else {
                    logger.info("Including " + this.resolvedToString((ResolvedDependency)resolvedDependency) + " and it's dependencies");
                }
            });
            logger.info("All resolved dependencies: ");
            ArrayList resolved = new ArrayList();
            task.getProject().getConfigurations().getByName("runtimeClasspath").getIncoming().getArtifacts().getArtifacts().forEach(artifact -> {
                if (excluded.stream().anyMatch(ex -> this.areSame(settings.isIgnoreVersions(), this.resolvedToString((ResolvedDependency)ex), artifact.getId().getComponentIdentifier().toString()))) {
                    logger.info("Excluding " + artifact.getId().getComponentIdentifier().toString());
                } else {
                    logger.info("Including " + artifact.getId().getComponentIdentifier().toString());
                    resolved.add(artifact.getId().getComponentIdentifier().toString());
                }
            });
            JsonArray resultingArray = new JsonArray();
            for (String selector : resolved) {
                JsonObject element = new JsonObject();
                String[] dependency = selector.split(":");
                element.addProperty("groupId", dependency[0]);
                element.addProperty("artifactId", dependency[1]);
                element.addProperty("version", dependency[2]);
                resultingArray.add((JsonElement)element);
            }
            Path file = Paths.get(settings.getPath(), new String[0]);
            Path parent = file.getParent() != null ? file.getParent() : Paths.get("", new String[0]);
            File result = new File(new File(project.getBuildDir(), "AzimDP"), settings.getPath());
            if (result.getParentFile() != null) {
                result.getParentFile().mkdirs();
            }
            try {
                FileWriter writer = new FileWriter(result);
                Gson gson = settings.isBeautify() ? new GsonBuilder().setPrettyPrinting().create() : new Gson();
                gson.toJson((JsonElement)resultingArray, (Appendable)writer);
                writer.flush();
                writer.close();
                logger.info("Total number of dependencies written to file: " + resultingArray.size());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            project.getTasks().named("processResources", Copy.class, t -> {
                CopySpecInternal copyPluginDescriptors = t.getRootSpec().addChild();
                copyPluginDescriptors.into((Object)parent.toString());
                copyPluginDescriptors.from(new Object[]{result.toString()});
            });
        });
    }

    private boolean shouldExclude(List<String> toExclude, boolean ignoreVersion, ResolvedDependency dependency) {
        for (String e : toExclude) {
            String[] exclude = e.split(":");
            if (!exclude[0].equals(dependency.getModuleGroup()) || !exclude[1].equals(dependency.getModuleName()) || !ignoreVersion && !exclude[2].equals(dependency.getModuleVersion())) continue;
            return true;
        }
        return false;
    }

    private boolean areSame(boolean ignoreVersion, String one, String other) {
        String[] b;
        String[] a = one.split(":");
        return a[0].equals((b = other.split(":"))[0]) && a[1].equals(b[1]) && (ignoreVersion || a[2].equals(b[2]));
    }

    private boolean areSame(boolean ignoreVersion, ResolvedDependency resolved, DependencyResult res) {
        return this.areSame(ignoreVersion, resolved.getModuleGroup() + ":" + resolved.getModuleName() + ":" + resolved.getModuleVersion(), res.getRequested().toString());
    }

    private String resolvedToString(ResolvedDependency d) {
        return d.getModuleGroup() + ":" + d.getModuleName() + ":" + d.getModuleVersion();
    }

    private void printChildren(ResolvedDependency resolvedDependency, String offset) {
        resolvedDependency.getChildren().forEach(child -> {
            System.out.println(offset + this.resolvedToString((ResolvedDependency)child) + " " + child.getConfiguration());
            this.printChildren((ResolvedDependency)child, offset + "-");
        });
    }

    private List<ResolvedDependency> flatten(ResolvedDependency resolvedDependency) {
        ArrayList<ResolvedDependency> result = new ArrayList<ResolvedDependency>();
        result.add(resolvedDependency);
        resolvedDependency.getChildren().forEach(d -> result.addAll(this.flatten((ResolvedDependency)d)));
        return result;
    }
}

