/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.gradle;

import aQute.bnd.build.Project;
import aQute.bnd.gradle.AbstractBndrun;
import aQute.bnd.gradle.BndUtils;
import aQute.lib.io.IO;
import aQute.service.reporter.Report;
import java.io.File;
import java.util.List;
import java.util.Objects;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.options.Option;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;

@CacheableTask
public class TestOSGi
extends AbstractBndrun {
    public static final String OPTION_TESTS = "tests";
    private final DirectoryProperty resultsDirectory;
    private List<String> tests;
    private final Property<JavaLauncher> javaLauncher;

    @OutputDirectory
    public DirectoryProperty getResultsDirectory() {
        return this.resultsDirectory;
    }

    @Input
    @Optional
    public List<String> getTests() {
        return this.tests;
    }

    @Option(option="tests", description="Configures the test class names to be run.")
    public void setTests(List<String> tests) {
        this.tests = tests;
    }

    @Nested
    @Optional
    public Property<JavaLauncher> getJavaLauncher() {
        return this.javaLauncher;
    }

    public TestOSGi() {
        this.setGroup("verification");
        org.gradle.api.Project project = this.getProject();
        ObjectFactory objects = project.getObjects();
        Provider<Directory> testResultsDir = BndUtils.testResultsDir(project);
        String taskName = this.getName();
        this.resultsDirectory = objects.directoryProperty().convention(testResultsDir.map(d -> d.dir(taskName)));
        this.javaLauncher = objects.property(JavaLauncher.class).convention(BndUtils.defaultToolFor(project, JavaToolchainService::launcherFor));
    }

    @Override
    protected void worker(Project run) throws Exception {
        if (this.getJavaLauncher().isPresent() && Objects.equals(run.getProperty("java", "java"), "java")) {
            run.setProperty("java", IO.absolutePath((File)BndUtils.unwrapFile((Provider<? extends FileSystemLocation>)this.getJavaLauncher().map(JavaLauncher::getExecutablePath))));
        }
        this.getLogger().info("Running tests for {} in {}", (Object)run.getPropertiesFile(), (Object)run.getBase());
        this.getLogger().debug("Run properties: {}", (Object)run.getProperties());
        File resultsDir = BndUtils.unwrapFile((Provider<? extends FileSystemLocation>)this.getResultsDirectory());
        try {
            run.test(resultsDir, this.getTests());
        }
        finally {
            BndUtils.logReport((Report)run, this.getLogger());
        }
        if (!this.isIgnoreFailures() && !run.isOk()) {
            throw new GradleException(String.format("%s test failure", run.getPropertiesFile()));
        }
    }
}

